/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.ClientEventHandler;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import ichttt.mods.mcpaint.common.item.ItemStamp;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcpaint")
public class MCPaint {
    public static final String MODID = "mcpaint";
    public static final Logger LOGGER = LogManager.getLogger((String)"mcpaint");
    private static final String NETWORKING_VERSION = "3";
    public static SimpleChannel NETWORKING;

    public MCPaint() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(MCPaint.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::setupClient));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::lateSetup));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MCPaintConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MCPaintConfig.generalSpec);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NETWORKING = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "channel")).networkProtocolVersion(() -> NETWORKING_VERSION).clientAcceptedVersions(s -> s.equals(NETWORKING_VERSION)).serverAcceptedVersions(s -> s.equals(NETWORKING_VERSION)).simpleChannel();
        NETWORKING.registerMessage(1, MessagePaintData.class, MessagePaintData::encode, MessagePaintData::new, MessagePaintData.ServerHandler.INSTANCE::onMessage);
        NETWORKING.registerMessage(2, MessageDrawAbort.class, MessageDrawAbort::encode, MessageDrawAbort::new, MessageDrawAbort.Handler::onMessage);
        NETWORKING.registerMessage(3, MessagePaintData.ClientMessage.class, MessagePaintData::encode, MessagePaintData.ClientMessage::new, MessagePaintData.ClientHandler.INSTANCE::onMessage);
        NETWORKING.registerMessage(4, MessageClearSide.class, MessageClearSide::encode, MessageClearSide::new, MessageClearSide.ServerHandler::onMessage);
        NETWORKING.registerMessage(5, MessageClearSide.ClientMessage.class, MessageClearSide::encode, MessageClearSide.ClientMessage::new, MessageClearSide.ClientHandler::onMessage);
        LOGGER.info("Registered networking");
        CapabilityPaintable.register();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemBrush(new ResourceLocation(MODID, "brush")));
        registry.register((IForgeRegistryEntry)new ItemStamp(new ResourceLocation(MODID, "stamp")));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151575_d, new ResourceLocation(MODID, "canvas_wood")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151576_e, new ResourceLocation(MODID, "canvas_rock")));
        event.getRegistry().register((IForgeRegistryEntry)new BlockCanvas(Material.field_151578_c, new ResourceLocation(MODID, "canvas_ground")));
    }

    @SubscribeEvent
    public static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityType type = (TileEntityType)TileEntityType.Builder.func_223042_a(TileEntityCanvas::new, (Block[])new Block[]{EventHandler.CANVAS_GROUND, EventHandler.CANVAS_ROCK, EventHandler.CANVAS_WOOD}).func_206865_a(null).setRegistryName(MODID, "canvas_te");
        event.getRegistry().register((IForgeRegistryEntry)type);
    }
}

