/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.gui.button.GuiButtonTextToggle;
import ichttt.mods.mcpaint.client.gui.button.GuiColorButton;
import ichttt.mods.mcpaint.client.gui.drawutil.EnumDrawType;
import ichttt.mods.mcpaint.client.gui.drawutil.PictureState;
import ichttt.mods.mcpaint.client.render.RenderUtil;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class DrawScreen
extends Screen
implements Slider.ISlider {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("mcpaint", "textures/gui/setup.png");
    public static final int ZERO_ALPHA = new Color(255, 255, 255, 0).getRGB();
    private static final int PICTURE_START_LEFT = 6;
    private static final int PICTURE_START_TOP = 9;
    private static final int xSize = 176;
    private static final int ySize = 166;
    private static final int toolXSize = 80;
    private static final int toolYSize = 95;
    private static final int sizeXSize = 80;
    private static final int sizeYSize = 34;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final BlockPos pos;
    private final Direction facing;
    private final BlockState state;
    private final IBakedModel model;
    private final LinkedList<PictureState> statesForUndo = new LinkedList();
    private final LinkedList<PictureState> statesForRedo = new LinkedList();
    private final boolean hadPaint;
    private Color color = Color.BLACK;
    private PictureState paintingState;
    private PictureState currentState;
    private int guiLeft;
    private int guiTop;
    private boolean clickStartedInPicture = false;
    private final List<GuiButtonTextToggle> textToggleList = new ArrayList<GuiButtonTextToggle>();
    private EnumDrawType activeDrawType = EnumDrawType.PENCIL;
    private int toolSize = 1;
    private Button undo;
    private Button redo;
    private Button lessSize;
    private Button moreSize;
    private Slider redSlider;
    private Slider blueSlider;
    private Slider greenSlider;
    private Slider alphaSlider;
    private boolean hasSizeWindow;
    private boolean noRevert = false;
    private boolean updating = false;

    public DrawScreen(IPaintable canvas, List<IPaintable> prevImages, BlockPos pos, Direction facing, BlockState state) {
        super((ITextComponent)new TranslationTextComponent("mcpaint.drawgui", new Object[0]));
        Objects.requireNonNull(canvas, "Canvas is null");
        Preconditions.checkArgument((boolean)canvas.hasPaintData(), (Object)"No data in canvas");
        this.pos = pos;
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        this.currentState = new PictureState(canvas);
        for (IPaintable paint : prevImages) {
            this.statesForUndo.add(new PictureState(paint));
        }
        this.hadPaint = true;
    }

    protected DrawScreen(byte scaleFactor, BlockPos pos, Direction facing, BlockState state) {
        super((ITextComponent)new TranslationTextComponent("mcpaint.drawgui", new Object[0]));
        int[][] picture;
        this.pos = Objects.requireNonNull(pos);
        this.facing = facing;
        this.state = state;
        this.model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        for (int[] tileArray : picture = new int[128 / scaleFactor][128 / scaleFactor]) {
            Arrays.fill(tileArray, ZERO_ALPHA);
        }
        this.currentState = new PictureState(picture, scaleFactor);
        this.hadPaint = false;
    }

    public void init() {
        this.hasSizeWindow = false;
        this.textToggleList.clear();
        this.guiLeft = (this.width - 176) / 2;
        this.guiTop = (this.height - 166) / 2;
        Button saveImage = new Button(this.guiLeft + 176, this.guiTop + 96, 80, 20, "Export", button -> {
            try {
                this.saveImage(true);
            }
            catch (IOException e) {
                MCPaint.LOGGER.error("Could not save image!", (Throwable)e);
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Failed to save file!"), true);
                this.minecraft.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Failed to save file!"), false);
            }
        });
        Button rotateRight = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.rright", (Object[])new Object[0]), button -> {
            int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
            for (int x = 0; x < this.currentState.picture.length; ++x) {
                int[] yData = this.currentState.picture[x];
                for (int y = 0; y < yData.length; ++y) {
                    newData[yData.length - y - 1][x] = yData[y];
                }
            }
            this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
        });
        Button rotateLeft = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.rleft", (Object[])new Object[0]), button -> {
            int[][] newData = new int[this.currentState.picture.length][this.currentState.picture[0].length];
            for (int x = 0; x < this.currentState.picture.length; ++x) {
                int[] yData = this.currentState.picture[x];
                for (int y = 0; y < yData.length; ++y) {
                    newData[y][this.currentState.picture.length - x - 1] = yData[y];
                }
            }
            this.newPictureState(new PictureState(newData, this.currentState.scaleFactor));
        });
        this.redo = new Button(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.redo", (Object[])new Object[0]), button -> this.redo());
        this.undo = new Button(this.guiLeft - 80 + 3, this.guiTop + 5 + 22 + 22, 36, 20, I18n.func_135052_a((String)"mcpaint.gui.undo", (Object[])new Object[0]), button -> this.undo());
        GuiButtonTextToggle pickColor = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5 + 22, 36, 20, EnumDrawType.PICK_COLOR, this::handleToolButton);
        GuiButtonTextToggle erase = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5 + 22, 36, 20, EnumDrawType.ERASER, this::handleToolButton);
        GuiButtonTextToggle fill = new GuiButtonTextToggle(this.guiLeft - 80 + 2 + 39, this.guiTop + 5, 36, 20, EnumDrawType.FILL, this::handleToolButton);
        GuiButtonTextToggle pencil = new GuiButtonTextToggle(this.guiLeft - 80 + 3, this.guiTop + 5, 36, 20, EnumDrawType.PENCIL, this::handleToolButton);
        this.moreSize = new Button(this.guiLeft - 80 + 3 + 55, this.guiTop + 95 + 5, 20, 20, ">", button -> {
            ++this.toolSize;
            this.handleSizeChanged();
        });
        this.lessSize = new Button(this.guiLeft - 80 + 3, this.guiTop + 95 + 5, 20, 20, "<", button -> {
            --this.toolSize;
            this.handleSizeChanged();
        });
        Button done = new Button(this.guiLeft + 88 - 100, this.guiTop + 166 + 20, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            if (Arrays.stream(this.currentState.picture).anyMatch(ints -> Arrays.stream(ints).anyMatch(value -> value != ZERO_ALPHA))) {
                this.noRevert = true;
                MCPaintUtil.uploadPictureToServer(this.minecraft.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, false);
            } else if (this.hadPaint) {
                MCPaintUtil.uploadPictureToServer(this.minecraft.field_71441_e.func_175625_s(this.pos), this.facing, this.currentState.scaleFactor, this.currentState.picture, true);
            }
            this.minecraft.func_147108_a(null);
        });
        GuiColorButton black = new GuiColorButton(0, this.guiLeft + 137, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton white = new GuiColorButton(1, this.guiLeft + 137 + 18, this.guiTop + 9, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton gray = new GuiColorButton(2, this.guiLeft + 137, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton red = new GuiColorButton(3, this.guiLeft + 137 + 18, this.guiTop + 9 + 18, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton orange = new GuiColorButton(4, this.guiLeft + 137, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton yellow = new GuiColorButton(5, this.guiLeft + 137 + 18, this.guiTop + 9 + 36, 16, 16, Color.BLUE.getRGB(), this::handleColorChange);
        GuiColorButton lime = new GuiColorButton(6, this.guiLeft + 137, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton green = new GuiColorButton(7, this.guiLeft + 137 + 18, this.guiTop + 9 + 54, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton lightBlue = new GuiColorButton(8, this.guiLeft + 137, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton darkBlue = new GuiColorButton(9, this.guiLeft + 137 + 18, this.guiTop + 9 + 72, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton purple = new GuiColorButton(10, this.guiLeft + 137, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        GuiColorButton pink = new GuiColorButton(11, this.guiLeft + 137 + 18, this.guiTop + 9 + 90, 16, 16, Color.BLACK.getRGB(), this::handleColorChange);
        this.redSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 4, "mcpaint.gui.red");
        this.greenSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 26, "mcpaint.gui.green");
        this.blueSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 48, "mcpaint.gui.blue");
        this.alphaSlider = this.makeSlider(this.guiLeft + 176 + 3, this.guiTop + 70, "mcpaint.gui.alpha");
        this.addButton((Widget)saveImage);
        this.addButton((Widget)rotateRight);
        this.addButton((Widget)rotateLeft);
        this.addButton((Widget)this.redo);
        this.addButton((Widget)this.undo);
        this.addButton((Widget)pickColor);
        this.addButton((Widget)erase);
        this.addButton((Widget)fill);
        this.addButton((Widget)pencil);
        this.addButton((Widget)done);
        this.addButton((Widget)black);
        this.addButton((Widget)white);
        this.addButton((Widget)gray);
        this.addButton((Widget)red);
        this.addButton((Widget)orange);
        this.addButton((Widget)yellow);
        this.addButton((Widget)lime);
        this.addButton((Widget)green);
        this.addButton((Widget)lightBlue);
        this.addButton((Widget)darkBlue);
        this.addButton((Widget)purple);
        this.addButton((Widget)pink);
        this.addButton((Widget)this.redSlider);
        this.addButton((Widget)this.greenSlider);
        this.addButton((Widget)this.blueSlider);
        this.addButton((Widget)this.alphaSlider);
        for (Widget button2 : this.buttons) {
            if (!(button2 instanceof GuiButtonTextToggle)) continue;
            this.textToggleList.add((GuiButtonTextToggle)button2);
        }
        pencil.onClick(0.0, 0.0);
        this.lessSize.onClick(0.0, 0.0);
        black.onClick(0.0, 0.0);
        this.redo.onClick(0.0, 0.0);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int[][] toDraw;
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        this.blit(this.guiLeft, this.guiTop, 0, 0, 176, 166);
        this.blit(this.guiLeft + 176, this.guiTop, 176, 0, 80, 95);
        this.blit(this.guiLeft - 80, this.guiTop, 176, 0, 80, 95);
        if (this.hasSizeWindow) {
            this.blit(this.guiLeft - 80, this.guiTop + 95 + 1, 176, 96, 80, 34);
            this.drawCenteredString(this.font, this.toolSize + "", this.guiLeft - 80 + 40, this.guiTop + 95 + 11, Color.WHITE.getRGB());
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        List quads = this.model.getQuads(this.state, this.facing.func_176734_d(), new Random(), (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad quad : quads) {
            TextureAtlasSprite sprite = quad.func_187508_a();
            RenderSystem.pushMatrix();
            this.minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            if (quad.func_178212_b()) {
                int color = this.minecraft.func_184125_al().func_228054_a_(this.state, (ILightReader)this.minecraft.field_71441_e, this.pos, quad.func_178211_c());
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                RenderSystem.color3f((float)red, (float)green, (float)blue);
            }
            DrawScreen.blit((int)(this.guiLeft + 6), (int)(this.guiTop + 9), (int)-1, (int)128, (int)128, (TextureAtlasSprite)sprite);
            RenderSystem.popMatrix();
        }
        super.render(mouseX, mouseY, partialTicks);
        DrawScreen.fill((int)(this.guiLeft + 138), (int)(this.guiTop + 125), (int)(this.guiLeft + 138 + 32), (int)(this.guiTop + 125 + 32), (int)this.color.getRGB());
        int offsetMouseX = mouseX - this.guiLeft - 6;
        int offsetMouseY = mouseY - this.guiTop - 9;
        boolean drawSelect = this.isInWindow(offsetMouseX, offsetMouseY) && this.activeDrawType != EnumDrawType.PICK_COLOR;
        int[][] nArray = toDraw = this.paintingState == null ? this.currentState.picture : this.paintingState.picture;
        if (drawSelect) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            toDraw = MCPaintUtil.copyOf(toDraw);
            this.activeDrawType.draw(toDraw, this.color, pixelPosX, pixelPosY, this.toolSize);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtil.renderInGui(this.guiLeft + 6, this.guiTop + 9, this.currentState.scaleFactor, buffer, toDraw);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.handleMouse(mouseX, mouseY, mouseButton)) {
            this.clickStartedInPicture = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double v2, double v3) {
        if (this.clickStartedInPicture && this.handleMouse(mouseX, mouseY, clickedMouseButton)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, v2, v3);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.clickStartedInPicture = false;
        if (this.paintingState != null) {
            this.newPictureState(this.paintingState);
            this.paintingState = null;
        }
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public boolean keyPressed(int keyCode, int i1, int i2) {
        if (keyCode == 90 && InputMappings.func_216506_a((long)this.minecraft.func_228018_at_().func_198092_i(), (int)341)) {
            if (InputMappings.func_216506_a((long)this.minecraft.func_228018_at_().func_198092_i(), (int)340)) {
                this.redo();
            } else {
                this.undo();
            }
            return true;
        }
        return super.keyPressed(keyCode, i1, i2);
    }

    private void handleColorChange(Color color) {
        this.color = color;
        this.updateSliders();
    }

    protected void handleToolButton(Button button) {
        for (GuiButtonTextToggle toggleButton : this.textToggleList) {
            boolean toggled;
            toggleButton.toggled = toggled = toggleButton == button;
            if (!toggled) continue;
            this.activeDrawType = toggleButton.type;
            if (this.activeDrawType.hasSizeRegulator && !this.hasSizeWindow) {
                this.addButton((Widget)this.moreSize);
                this.addButton((Widget)this.lessSize);
            } else if (!this.activeDrawType.hasSizeRegulator && this.hasSizeWindow) {
                this.buttons.remove(this.moreSize);
                this.buttons.remove(this.lessSize);
            }
            this.hasSizeWindow = this.activeDrawType.hasSizeRegulator;
        }
    }

    public void onClose() {
        if (!this.noRevert) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageDrawAbort(this.pos));
        }
    }

    private void newPictureState(PictureState state) {
        if (state.isSame(this.currentState)) {
            return;
        }
        this.statesForRedo.clear();
        this.statesForUndo.add(this.currentState);
        this.currentState = state;
        if (this.statesForUndo.size() > 20) {
            this.statesForUndo.removeFirst();
        }
        this.updateUndoRedoButton();
    }

    private void undo() {
        if (this.statesForUndo.size() > 0) {
            this.statesForRedo.add(this.currentState);
            this.currentState = this.statesForUndo.removeLast();
        }
        this.updateUndoRedoButton();
    }

    private void redo() {
        if (this.statesForRedo.size() > 0) {
            this.statesForUndo.add(this.currentState);
            this.currentState = this.statesForRedo.removeLast();
        }
        this.updateUndoRedoButton();
    }

    private void updateUndoRedoButton() {
        this.undo.active = !this.statesForUndo.isEmpty();
        this.redo.active = !this.statesForRedo.isEmpty();
    }

    private boolean handleMouse(double mouseXD, double mouseYD, int mouseButton) {
        int mouseY;
        int offsetMouseY;
        if (mouseButton != 0) {
            return false;
        }
        int mouseX = (int)Math.round(mouseXD);
        int offsetMouseX = mouseX - this.guiLeft - 6;
        if (this.isInWindow(offsetMouseX, offsetMouseY = (mouseY = (int)Math.round(mouseYD)) - this.guiTop - 9)) {
            int pixelPosX = offsetMouseX / this.currentState.scaleFactor;
            int pixelPosY = offsetMouseY / this.currentState.scaleFactor;
            if (this.paintingState == null) {
                this.paintingState = new PictureState(this.currentState);
            }
            if (pixelPosX < this.paintingState.picture.length && pixelPosY < this.paintingState.picture.length && this.color != null) {
                this.color = this.activeDrawType.draw(this.paintingState.picture, this.color, pixelPosX, pixelPosY, this.toolSize);
                this.updateSliders();
                return true;
            }
        }
        return false;
    }

    private boolean isInWindow(int offsetMouseX, int offsetMouseY) {
        return offsetMouseX >= 0 && offsetMouseX < this.currentState.picture.length * this.currentState.scaleFactor && offsetMouseY >= 0 && offsetMouseY < this.currentState.picture.length * this.currentState.scaleFactor;
    }

    private Slider makeSlider(int xPos, int yPos, String key) {
        return new Slider(xPos, yPos, 74, 20, I18n.func_135052_a((String)key, (Object[])new Object[0]), "", 0.0, 255.0, 0.0, false, true, null, (Slider.ISlider)this);
    }

    private void updateSliders() {
        this.redSlider.setValue((double)this.color.getRed());
        this.blueSlider.setValue((double)this.color.getBlue());
        this.greenSlider.setValue((double)this.color.getGreen());
        this.alphaSlider.setValue((double)this.color.getAlpha());
        this.updating = true;
        this.redSlider.updateSlider();
        this.blueSlider.updateSlider();
        this.greenSlider.updateSlider();
        this.alphaSlider.updateSlider();
        this.updating = false;
    }

    private void handleSizeChanged() {
        if (this.toolSize >= 10) {
            this.toolSize = 10;
            this.moreSize.active = false;
        } else {
            this.moreSize.active = true;
        }
        if (this.toolSize <= 1) {
            this.toolSize = 1;
            this.lessSize.active = false;
        } else {
            this.lessSize.active = true;
        }
    }

    private void saveImage(boolean background) throws IOException {
        BufferedImage paint = new BufferedImage(128 / this.currentState.scaleFactor, 128 / this.currentState.scaleFactor, 2);
        for (int x = 0; x < this.currentState.picture.length; ++x) {
            for (int y = 0; y < this.currentState.picture[0].length; ++y) {
                paint.setRGB(x, y, this.currentState.picture[x][y]);
            }
        }
        BufferedImage output = new BufferedImage(paint.getWidth(), paint.getHeight(), 2);
        if (background) {
            List quads = this.model.getQuads(this.state, this.facing.func_176734_d(), new Random(), (IModelData)EmptyModelData.INSTANCE);
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.func_187508_a();
                IResource resource = this.minecraft.func_195551_G().func_199002_a(this.getResourceLocation(sprite));
                Throwable throwable = null;
                try {
                    Image image = ImageIO.read(resource.func_199027_b());
                    if (quad.func_178212_b()) {
                        int color = this.minecraft.func_184125_al().func_228054_a_(this.state, (ILightReader)this.minecraft.field_71441_e, this.pos, quad.func_178211_c());
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        Image asBufferedImage = image;
                        for (int x = 0; x < ((BufferedImage)asBufferedImage).getWidth(); ++x) {
                            for (int y = 0; y < ((BufferedImage)asBufferedImage).getHeight(); ++y) {
                                Color originalColor = new Color(((BufferedImage)asBufferedImage).getRGB(x, y), true);
                                int newRed = Math.round((float)originalColor.getRed() * red);
                                int newGreen = Math.round((float)originalColor.getGreen() * green);
                                int newBlue = Math.round((float)originalColor.getBlue() * blue);
                                ((BufferedImage)asBufferedImage).setRGB(x, y, new Color(newRed, newGreen, newBlue, originalColor.getAlpha()).getRGB());
                            }
                        }
                    }
                    image = image.getScaledInstance(output.getWidth(), output.getHeight(), 2);
                    output.getGraphics().drawImage(image, 0, 0, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
        }
        output.getGraphics().drawImage(paint, 0, 0, null);
        File file = new File(this.minecraft.field_71412_D, "paintings");
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create folder");
        }
        File finalFile = DrawScreen.getTimestampedPNGFileForDirectory(file);
        if (!ImageIO.write((RenderedImage)output, "png", finalFile)) {
            throw new IOException("Could not encode image as png!");
        }
        StringTextComponent component = new StringTextComponent(finalFile.getName());
        component = component.func_211708_a(TextFormatting.UNDERLINE).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalFile.getAbsolutePath())));
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("mcpaint.gui.saved", new Object[]{component}), false);
    }

    public void onChangeSliderValue(Slider slider) {
        if (this.updating) {
            return;
        }
        this.color = new Color(this.redSlider.getValueInt(), this.greenSlider.getValueInt(), this.blueSlider.getValueInt(), this.alphaSlider.getValueInt());
    }

    private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
        ResourceLocation resourcelocation = p_184396_1_.func_195668_m();
        return new ResourceLocation(resourcelocation.func_110624_b(), String.format("textures/%s%s", resourcelocation.func_110623_a(), ".png"));
    }

    private static File getTimestampedPNGFileForDirectory(File gameDirectory) {
        String s = DATE_FORMAT.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

