/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.client.gui;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.client.gui.DrawScreen;
import ichttt.mods.mcpaint.networking.MessageDrawAbort;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSetupCanvas
extends Screen {
    private static final ResourceLocation BACKGROUND = DrawScreen.BACKGROUND;
    private static final int yOffset = 166;
    private static final int xSize = 106;
    private static final int ySize = 79;
    private static final int MAX_MULTIPLIER = 16;
    private final BlockPos pos;
    private final Direction facing;
    private final BlockState state;
    private final int baseX;
    private final int baseY;
    private boolean handled = false;
    private Button moreSize;
    private Button lessSize;
    private int currentMulti;
    private int guiLeft;
    private int guiTop;

    public GuiSetupCanvas(BlockPos pos, Direction facing, BlockState state, int baseX, int baseY) {
        super((ITextComponent)new TranslationTextComponent("mcpaint.drawsetup", new Object[0]));
        this.pos = pos;
        this.facing = facing;
        this.state = state;
        this.baseX = baseX;
        this.baseY = baseY;
        this.currentMulti = 2;
    }

    public void init() {
        this.guiLeft = (this.width - 106) / 2;
        this.guiTop = (this.height - 79) / 2;
        this.lessSize = new Button(this.guiLeft + 5, this.guiTop + 26, 20, 20, "<", button -> {
            this.currentMulti /= 2;
            this.handleSizeChanged();
        });
        this.moreSize = new Button(this.guiLeft + 83, this.guiTop + 26, 20, 20, ">", button -> {
            this.currentMulti *= 2;
            this.handleSizeChanged();
        });
        this.addButton((Widget)new Button(this.guiLeft + 5, this.guiTop + 56, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            this.handled = true;
            this.minecraft.func_147108_a(null);
            this.minecraft.func_147108_a((Screen)new DrawScreen((byte)(16 / this.currentMulti), this.pos, this.facing, this.state));
        }));
        this.addButton((Widget)this.lessSize);
        this.addButton((Widget)this.moreSize);
        this.handleSizeChanged();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        this.blit(this.guiLeft, this.guiTop, 0, 166, 106, 79);
        this.drawCenteredString(this.minecraft.field_71466_p, "Resolution:", this.guiLeft + 53 + 1, this.guiTop + 8, Color.WHITE.getRGB());
        this.drawCenteredString(this.minecraft.field_71466_p, this.baseX * this.currentMulti + "x" + this.baseY * this.currentMulti, this.guiLeft + 53 + 1, this.guiTop + 32, Color.WHITE.getRGB());
        super.render(mouseX, mouseY, partialTicks);
    }

    public void onClose() {
        if (!this.handled) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageDrawAbort(this.pos));
        }
    }

    private void handleSizeChanged() {
        if (this.currentMulti >= 16) {
            this.currentMulti = 16;
            this.moreSize.active = false;
        } else {
            this.moreSize.active = true;
        }
        if (this.currentMulti <= 1) {
            this.currentMulti = 1;
            this.lessSize.active = false;
        } else {
            this.lessSize.active = true;
        }
    }
}

