/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.client.render.ISTERStamp;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ItemBrush
extends Item {
    public static Item.Properties getProperties() {
        Item.Properties properties = new Item.Properties();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> properties.setISTER(ISTERStamp::getInstance));
        properties.func_200916_a(ItemGroup.field_78031_c).func_200917_a(1).func_200915_b(32);
        return properties;
    }

    public ItemBrush(ResourceLocation registryName) {
        super(ItemBrush.getProperties());
        this.setRegistryName(registryName);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        RayTraceResult raytraceresult = ItemBrush.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(this.processMiss(world, player, hand, held, raytraceresult), (Object)held);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)raytraceresult;
        BlockPos pos = blockRayTraceResult.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        Direction facing = blockRayTraceResult.func_216354_b();
        return new ActionResult(this.processHit(world, player, hand, pos, state, facing), (Object)held);
    }

    protected ActionResultType processMiss(World world, PlayerEntity player, Hand hand, ItemStack stack, @Nullable RayTraceResult result) {
        return ActionResultType.FAIL;
    }

    protected ActionResultType processHit(World world, PlayerEntity player, Hand hand, BlockPos pos, BlockState state, Direction facing) {
        if (state.func_177230_c() instanceof BlockCanvas) {
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            if (canvas.isSideBlockedForPaint(facing)) {
                return ActionResultType.FAIL;
            }
            ItemStack held = player.func_184586_b(hand);
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_222118_a(1, (LivingEntity)player, p_220282_1_ -> p_220282_1_.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        if (Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)facing) && state.func_185904_a().func_76218_k() && state.func_185901_i() == BlockRenderType.MODEL && !state.func_177230_c().hasTileEntity(state)) {
            EnumSet<Direction> disallowedFaces = EnumSet.noneOf(Direction.class);
            for (Direction testFacing : Direction.values()) {
                if (Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)testFacing)) continue;
                disallowedFaces.add(testFacing);
            }
            if (state.func_185904_a().func_76217_h()) {
                world.func_175656_a(pos, EventHandler.CANVAS_WOOD.getStateFrom((IBlockReader)world, pos, state));
            } else if (state.func_185904_a().func_76229_l()) {
                world.func_175656_a(pos, EventHandler.CANVAS_GROUND.getStateFrom((IBlockReader)world, pos, state));
            } else {
                world.func_175656_a(pos, EventHandler.CANVAS_ROCK.getStateFrom((IBlockReader)world, pos, state));
            }
            TileEntityCanvas canvas = (TileEntityCanvas)Objects.requireNonNull(world.func_175625_s(pos));
            canvas.setInitialData(state, disallowedFaces);
            canvas.func_70296_d();
            ItemStack held = player.func_184586_b(hand);
            this.startPainting(canvas, world, held, pos, facing.func_176734_d(), state);
            held.func_222118_a(1, (LivingEntity)player, p_220282_1_ -> p_220282_1_.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void startPainting(TileEntityCanvas canvas, World world, ItemStack heldItem, BlockPos pos, Direction facing, BlockState state) {
        if (world.field_72995_K) {
            if (canvas.hasPaintFor(facing)) {
                ArrayList<IPaintable> list = new ArrayList<IPaintable>(1);
                list.add(canvas.getPaintFor(facing));
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(list, canvas.func_174877_v(), facing, canvas.getContainedState()));
            } else {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(pos, facing, canvas.getContainedState()));
            }
        }
    }
}

