/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.networking.MessageClearSide;
import ichttt.mods.mcpaint.networking.MessagePaintData;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class MCPaintUtil {
    public static boolean isPosInvalid(ServerPlayerEntity player, BlockPos pos) {
        if (!player.field_70170_p.func_175667_e(pos)) {
            MCPaint.LOGGER.warn("Player" + player.func_200200_C_() + " is trying to write to unloaded block");
            player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Trying to write to unloaded block"));
            return true;
        }
        if (MathHelper.func_76133_a((double)player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) > (float)(Math.round(player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e()) + 5L)) {
            MCPaint.LOGGER.warn("Player" + player.func_200200_C_() + " is writing to out of reach block!");
            return true;
        }
        return false;
    }

    public static int[][] copyOf(int[][] array) {
        int[][] copy = new int[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (int[])array[i].clone();
        }
        return copy;
    }

    public static boolean[][] copyOf(boolean[][] array) {
        boolean[][] copy = new boolean[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = (boolean[])array[i].clone();
        }
        return copy;
    }

    public static void uploadPictureToServer(@Nullable TileEntity te, Direction facing, byte scaleFactor, int[][] picture, boolean clear) {
        if (!(te instanceof TileEntityCanvas)) {
            MCPaint.LOGGER.error("Could not set paint! Found block " + (te == null ? "NONE" : te.func_200662_C()));
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Could not set paint!"), true);
            return;
        }
        TileEntityCanvas canvas = (TileEntityCanvas)te;
        if (clear) {
            MCPaint.NETWORKING.sendToServer((Object)new MessageClearSide(te.func_174877_v(), facing));
            canvas.removePaint(facing);
        } else {
            MessagePaintData.createAndSend(te.func_174877_v(), facing, scaleFactor, picture, arg_0 -> ((SimpleChannel)MCPaint.NETWORKING).sendToServer(arg_0));
            IPaintable paintable = canvas.getPaintFor(facing);
            paintable.setData(scaleFactor, picture, canvas, facing);
        }
    }

    @Nonnull
    public static ServerPlayerEntity checkServer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void checkClient(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalArgumentException("Wrong side for client packet handler: " + context.getDirection());
        }
        context.setPacketHandled(true);
    }
}

