/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockCanvas
extends Block {
    public static final BooleanProperty SOLID = BooleanProperty.func_177716_a((String)"solid");
    public static final BooleanProperty NORMAL_CUBE = BooleanProperty.func_177716_a((String)"normal_cube");

    public BlockCanvas(Material material, ResourceLocation regNam) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(1.0f, 4.0f).func_235828_a_((state, world, pos) -> (Boolean)state.func_177229_b((Property)NORMAL_CUBE)));
        this.setRegistryName(regNam);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCanvas();
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_185903_a(player, world, pos);
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getExplosionResistance(canvas.getContainedState(), world, pos, explosion);
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_177230_c().getSoundType(canvas.getContainedState(), world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void func_180657_a(@Nonnull World world, PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityCanvas && ((TileEntityCanvas)te).getContainedState() != null) {
            TileEntityCanvas canvas = (TileEntityCanvas)te;
            state = canvas.getContainedState();
            state.func_177230_c().func_180657_a(world, player, pos, state, te, stack);
            return;
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.func_177230_c().canHarvestBlock(state, world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_215685_b(world, pos, context);
        }
        return super.func_220071_b(state, world, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_215700_a(world, pos, context);
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            return canvas.getContainedState().func_196951_e(world, pos);
        }
        return super.func_196247_c(state, world, pos);
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntityCanvas canvas;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).getContainedState() != null) {
            return canvas.getContainedState().func_199611_f(world, pos, context);
        }
        return super.func_199600_g(state, world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SOLID, NORMAL_CUBE});
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull BlockState state, RayTraceResult target, @Nonnull IBlockReader world, @Nonnull BlockPos pos, PlayerEntity player) {
        TileEntityCanvas canvas = (TileEntityCanvas)world.func_175625_s(pos);
        if (canvas != null && canvas.getContainedState() != null) {
            state = canvas.getContainedState();
            return state.func_177230_c().getPickBlock(canvas.getContainedState(), target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    public SoundType func_220072_p(BlockState state) {
        return super.func_220072_p(state);
    }

    public BlockState getStateFrom(IBlockReader world, BlockPos pos, BlockState state) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(state.func_200132_m()))).func_206870_a((Property)NORMAL_CUBE, (Comparable)Boolean.valueOf(state.func_215686_e(world, pos)));
    }
}

