/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.block;

import ichttt.mods.mcpaint.MCPaint;
import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.render.batch.IOptimisationCallback;
import ichttt.mods.mcpaint.client.render.batch.RenderCache;
import ichttt.mods.mcpaint.client.render.batch.SimpleCallback;
import ichttt.mods.mcpaint.client.render.buffer.BufferManager;
import ichttt.mods.mcpaint.common.EventHandler;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintValidator;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.capability.Paint;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class TileEntityCanvas
extends TileEntity
implements IPaintValidator {
    public static final ModelProperty<BlockState> BLOCK_STATE_PROPERTY = new ModelProperty();
    private final Map<Direction, IPaintable> facingToPaintMap = new EnumMap<Direction, IPaintable>(Direction.class);
    private BlockState containedState;
    private final Map<Direction, Object> bufferMap = new EnumMap<Direction, Object>(Direction.class);
    private final Set<Direction> disallowedFaces = EnumSet.noneOf(Direction.class);

    public TileEntityCanvas() {
        super(EventHandler.CANVAS_TE);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        if (this.containedState != null) {
            tag.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.containedState));
        }
        CompoundNBT faces = new CompoundNBT();
        for (Map.Entry<Direction, IPaintable> entry : this.facingToPaintMap.entrySet()) {
            faces.func_218657_a(entry.getKey().func_176742_j(), (INBT)CapabilityPaintable.writeToNBT(entry.getValue(), new CompoundNBT()));
        }
        tag.func_218657_a("faces", (INBT)faces);
        if (!this.disallowedFaces.isEmpty()) {
            CompoundNBT blockedFaces = new CompoundNBT();
            for (Direction facing : Direction.values()) {
                blockedFaces.func_74757_a(facing.func_176742_j(), this.disallowedFaces.contains(facing));
            }
            tag.func_218657_a("blocked", (INBT)blockedFaces);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.containedState = tag.func_150297_b("blockState", 10) ? NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("blockState")) : null;
        CompoundNBT faces = tag.func_74775_l("faces");
        for (String key : faces.func_150296_c()) {
            Paint paint = new Paint(this);
            CapabilityPaintable.readFromNBT(paint, faces.func_74775_l(key));
            this.facingToPaintMap.put(Direction.func_176739_a((String)key), paint);
        }
        this.disallowedFaces.clear();
        if (tag.func_74764_b("blocked")) {
            CompoundNBT blockedFaces = tag.func_74775_l("blocked");
            for (String key : blockedFaces.func_150296_c()) {
                if (!blockedFaces.func_74767_n(key)) continue;
                this.disallowedFaces.add(Direction.func_176739_a((String)key));
            }
        }
    }

    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityPaintable.PAINTABLE) {
            return LazyOptional.of(() -> this.getPaintFor(facing));
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public boolean isValidPixelCount(short pixelCountX, short pixelCountY) {
        return pixelCountX == 0 && pixelCountY == 0 || pixelCountX == 128 && pixelCountY == 128;
    }

    public void setInitialData(BlockState state, Set<Direction> disallowedFaces) {
        this.containedState = state;
        this.disallowedFaces.addAll(disallowedFaces);
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
        }
    }

    public BlockState getContainedState() {
        return this.containedState;
    }

    public IPaintable getPaintFor(Direction facing) {
        return this.facingToPaintMap.computeIfAbsent(facing, face -> new Paint(this));
    }

    public boolean hasPaintFor(Direction facing) {
        IPaintable paint = this.facingToPaintMap.get(facing);
        if (paint == null) {
            return false;
        }
        return paint.hasPaintData();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BufferManager getBuffer(final Direction facing) {
        Object obj = this.bufferMap.get(facing);
        if (obj instanceof BufferManager) {
            return (BufferManager)obj;
        }
        if (obj instanceof IOptimisationCallback) {
            return null;
        }
        if (obj != null) {
            MCPaint.LOGGER.error("Unknown object " + obj);
            return null;
        }
        SimpleCallback callback = new SimpleCallback(){

            @Override
            public void provideFinishedBuffer(BufferManager builder) {
                if (this.isInvalid()) {
                    return;
                }
                RenderCache.cache(TileEntityCanvas.this.getPaintFor(facing), builder);
                TileEntityCanvas.this.bufferMap.put(facing, builder);
            }
        };
        this.bufferMap.put(facing, callback);
        RenderCache.getOrRequest(this.facingToPaintMap.get(facing), callback);
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void unbindBuffers() {
        for (Map.Entry<Direction, Object> entry : this.bufferMap.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof SimpleCallback) {
                ((SimpleCallback)obj).invalidate();
                continue;
            }
            if (!(obj instanceof BufferManager)) continue;
            RenderCache.cache(this.getPaintFor(entry.getKey()), (BufferManager)obj);
        }
        this.bufferMap.clear();
    }

    public double func_145833_n() {
        int distOffset = (Integer)MCPaintConfig.CLIENT.maxPaintRenderDistance.get() + 8;
        return distOffset * distOffset;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
        this.unbindBuffers();
    }

    public void invalidateBuffer(Direction facing) {
        Object obj = this.bufferMap.remove(facing);
        if (obj instanceof SimpleCallback) {
            ((SimpleCallback)obj).invalidate();
        } else if (obj instanceof BufferManager) {
            RenderCache.uncache(this.getPaintFor(facing));
        } else {
            MCPaint.LOGGER.warn("Unknown obj " + obj);
        }
    }

    public void onChunkUnloaded() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            this.unbindBuffers();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BLOCK_STATE_PROPERTY, (Object)this.containedState).build();
    }

    public boolean isSideBlockedForPaint(Direction facing) {
        return this.disallowedFaces.contains(facing);
    }

    public void removePaint(Direction facing) {
        this.facingToPaintMap.remove(facing);
    }
}

