/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.common.item;

import ichttt.mods.mcpaint.MCPaintConfig;
import ichttt.mods.mcpaint.client.ClientHooks;
import ichttt.mods.mcpaint.common.MCPaintUtil;
import ichttt.mods.mcpaint.common.block.BlockCanvas;
import ichttt.mods.mcpaint.common.block.TileEntityCanvas;
import ichttt.mods.mcpaint.common.capability.CapabilityPaintable;
import ichttt.mods.mcpaint.common.capability.IPaintable;
import ichttt.mods.mcpaint.common.item.ItemBrush;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ItemStamp
extends ItemBrush {
    public ItemStamp(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected ActionResultType processMiss(World world, PlayerEntity player, Hand hand, ItemStack stack, @Nullable RayTraceResult result) {
        if ((result == null || result.func_216346_c() == RayTraceResult.Type.MISS) && player.func_213283_Z() == Pose.CROUCHING) {
            IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("Paintable cap needs to be present!"));
            if (paint.getPictureData() == null) {
                return ActionResultType.PASS;
            }
            paint.clear(null, null);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected ActionResultType processHit(World world, PlayerEntity player, Hand hand, BlockPos pos, BlockState state, Direction facing) {
        ItemStack held = player == null ? ItemStack.field_190927_a : player.func_184586_b(hand);
        IPaintable paint = (IPaintable)Objects.requireNonNull(held.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("Missing paint on brush!")));
        if (paint.hasPaintData()) {
            return super.processHit(world, player, hand, pos, state, facing);
        }
        if (player != null && player.func_213283_Z() == Pose.CROUCHING) {
            TileEntityCanvas canvas;
            TileEntity te;
            facing = facing.func_176734_d();
            if (state.func_177230_c() instanceof BlockCanvas && (te = world.func_175625_s(pos)) instanceof TileEntityCanvas && (canvas = (TileEntityCanvas)te).hasPaintFor(facing)) {
                paint.copyFrom(canvas.getPaintFor(facing), canvas, facing);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    @Override
    protected void startPainting(TileEntityCanvas canvas, World world, ItemStack heldItem, BlockPos pos, Direction facing, BlockState state) {
        if (world.field_72995_K) {
            IPaintable heldPaint = (IPaintable)Objects.requireNonNull(heldItem.getCapability(CapabilityPaintable.PAINTABLE, null).orElseThrow(() -> new RuntimeException("No paint in stamp")));
            if (((Boolean)MCPaintConfig.CLIENT.directApplyStamp.get()).booleanValue()) {
                canvas.getPaintFor(facing).copyFrom(heldPaint, canvas, facing);
                MCPaintUtil.uploadPictureToServer(canvas, facing, heldPaint.getScaleFactor(), heldPaint.getPictureData(), false);
            } else {
                LinkedList<IPaintable> paintList = new LinkedList<IPaintable>();
                if (canvas.hasPaintFor(facing)) {
                    paintList.add(canvas.getPaintFor(facing));
                }
                paintList.add(heldPaint);
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHooks.showGuiDraw(paintList, pos, facing, canvas.getContainedState()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IPaintable paintable = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE, null).orElse(null);
        if (paintable != null && paintable.hasPaintData()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("mcpaint.tooltip.stamp.paint"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("mcpaint.tooltip.stamp.nopaint"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null) {
            IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE).orElseThrow(() -> new IllegalArgumentException("Missing paintable on brush!"));
            CapabilityPaintable.readFromNBT(paint, nbt);
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        IPaintable paint = (IPaintable)stack.getCapability(CapabilityPaintable.PAINTABLE).orElseThrow(() -> new IllegalArgumentException("Missing paintable on brush!"));
        return CapabilityPaintable.writeToNBT(paint, new CompoundNBT());
    }
}

