/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.mcpaint.networking;

import ichttt.mods.mcpaint.networking.MessagePaintData;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageClearSide {
    private final BlockPos pos;
    private final Direction facing;

    public MessageClearSide(PacketBuffer buffer) {
        this(buffer.func_179259_c(), Direction.func_82600_a((int)buffer.readByte()));
    }

    public MessageClearSide(BlockPos pos, Direction facing) {
        this.pos = pos;
        this.facing = facing;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeByte(this.facing.func_176745_a());
    }

    public static class ClientMessage
    extends MessageClearSide {
        public ClientMessage(PacketBuffer buffer) {
            super(buffer);
        }

        public ClientMessage(BlockPos pos, Direction facing) {
            super(pos, facing);
        }
    }

    public static class ClientHandler {
        public static void onMessage(MessageClearSide message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context context = supplier.get();
            context.enqueueWork(() -> MessagePaintData.ClientHandler.INSTANCE.handleSide(context, message.pos, message.facing, (byte)0, null));
            context.setPacketHandled(true);
        }
    }

    public static class ServerHandler {
        public static void onMessage(MessageClearSide message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context context = supplier.get();
            context.enqueueWork(() -> MessagePaintData.ServerHandler.INSTANCE.handleSide(context, message.pos, message.facing, (byte)0, null));
            context.setPacketHandled(true);
        }
    }
}

