/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.capability.SummonableCapability;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.CopyAttackTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.TrackSummonerGoal;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.item.ArmorBlockItem;
import chumbanotz.mutantbeasts.item.HulkHammerItem;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.SeismicWave;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mutantbeasts")
public class EventHandler {
    @SubscribeEvent
    public static void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        if (SummonableCapability.isEntityEligible(((Entity)event.getObject()).func_200600_R())) {
            event.addCapability(SummonableCapability.ID, (ICapabilityProvider)new SummonableCapability.Provider());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof CreatureEntity) {
            CreatureEntity creature = (CreatureEntity)event.getEntity();
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                creature.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal(creature, MutantCreeperEntity.class, 16.0f, 1.33, 1.33));
            }
            if (creature.func_200600_R() == EntityType.field_200784_X) {
                creature.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal(creature, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151071_bq}), false));
            }
            if (creature instanceof VillagerEntity) {
                creature.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal(creature, MutantZombieEntity.class, 8.0f, (double)0.8f, (double)0.8f));
            }
            if (SummonableCapability.getLazy((Entity)creature).isPresent()) {
                creature.field_70714_bg.func_75776_a(0, (Goal)new TrackSummonerGoal((MobEntity)creature));
                creature.field_70714_bg.func_75776_a(3, (Goal)new MoveTowardsRestrictionGoal(creature, 1.0));
                creature.field_70715_bh.func_75776_a(0, (Goal)new CopyAttackTargetGoal(creature, false, SummonableCapability.get((Entity)creature)::getSummoner));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (event.getTarget().func_200600_R() == EntityType.field_200784_X && !event.getEntityLiving().func_70644_a(Effects.field_76431_k) && stack.func_77973_b() == Items.field_151071_bq) {
            if (!event.getPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            ((CreatureEntity)event.getTarget()).func_195064_c(new EffectInstance(Effects.field_76431_k, 600, 99));
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        float damage;
        PlayerEntity playerEntity;
        ItemStack stack;
        if (event.getEntityLiving() instanceof PlayerEntity && (stack = (playerEntity = (PlayerEntity)event.getEntityLiving()).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof ArmorBlockItem && !event.getSource().func_76363_c() && !((damage = event.getAmount()) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            stack.func_222118_a((int)damage, (LivingEntity)playerEntity, e -> e.func_213361_c(EquipmentSlotType.HEAD));
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (livingEntity instanceof PlayerEntity && EntityUtil.canBlockDamageSource(livingEntity, source) && source.func_76346_g() instanceof MutantCreeperEntity && source.func_94541_c()) {
            MutantCreeperEntity mutantCreeperEntity = (MutantCreeperEntity)source.func_76346_g();
            if (mutantCreeperEntity.field_70725_aQ > 0) {
                livingEntity.func_184607_cu().func_222118_a(Integer.MAX_VALUE, livingEntity, e -> e.func_213334_d(livingEntity.func_184600_cs()));
                livingEntity.func_70097_a(event.getSource(), event.getAmount() * 0.5f);
            } else {
                EntityUtil.disableShield(livingEntity, source, mutantCreeperEntity.func_70830_n() ? 200 : 100);
                livingEntity.func_70097_a(source, event.getAmount() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (SpiderPigEntity.isPigOrSpider(event.getEntityLiving()) && event.getSource().func_76346_g() instanceof SpiderPigEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EventHandler.playShoulderEntitySound(event.player, event.player.func_192023_dk());
        EventHandler.playShoulderEntitySound(event.player, event.player.func_192025_dl());
        if (!event.player.field_70170_p.field_72995_K && HulkHammerItem.WAVES.keySet().contains(event.player.func_110124_au())) {
            PlayerEntity player = event.player;
            List<SeismicWave> waveList = HulkHammerItem.WAVES.get(player.func_110124_au());
            while (waveList.size() > 16) {
                waveList.remove(0);
            }
            SeismicWave wave = waveList.remove(0);
            wave.affectBlocks(player.field_70170_p, (Entity)player);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)(wave.func_177956_o() + 1), (double)wave.func_177952_p(), (double)(wave.func_177958_n() + 1), (double)(wave.func_177956_o() + 2), (double)(wave.func_177952_p() + 1));
            for (Entity entity : player.field_70170_p.func_72839_b((Entity)player, box)) {
                if (!(entity instanceof LivingEntity) || player.func_184187_bx() == entity) continue;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player).func_151518_m(), (float)(6 + player.func_70681_au().nextInt(3)));
            }
            if (waveList.isEmpty()) {
                HulkHammerItem.WAVES.remove(player.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        World world = event.getPlayer().field_70170_p;
        PlayerEntity player = event.getPlayer();
        if (!world.field_72995_K) {
            boolean isHand;
            ItemStack stack = event.getEntityItem().func_92059_d();
            boolean bl = isHand = stack.func_77973_b() == MBItems.ENDERSOUL_HAND && stack.func_77951_h();
            if (stack.func_77973_b() == Items.field_151061_bv || isHand) {
                int count = 0;
                for (EndersoulFragmentEntity orb : world.func_175647_a(EndersoulFragmentEntity.class, player.func_174813_aQ().func_186662_g(8.0), EndersoulFragmentEntity::isTamed)) {
                    if (orb.getCollector() != player) continue;
                    ++count;
                    orb.func_70106_y();
                }
                if (count > 0) {
                    EntityUtil.spawnLargePortalParticles((Entity)player, 256, 1.8f, true);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.func_77952_i() - addDmg;
                        stack.func_196085_b(Math.max(dmg, 0));
                    } else {
                        ItemStack newStack = new ItemStack((IItemProvider)MBItems.ENDERSOUL_HAND);
                        newStack.func_196085_b(MBItems.ENDERSOUL_HAND.getMaxDamage(stack) - addDmg);
                        event.getEntityItem().func_92058_a(newStack);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (SummonableCapability.isEntityEligible(livingEntity.func_200600_R()) && SummonableCapability.getLazy((Entity)livingEntity).isPresent()) {
            SummonableCapability.getLazy((Entity)livingEntity).invalidate();
        }
    }

    private static void playShoulderEntitySound(PlayerEntity player, @Nullable CompoundNBT compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.func_74764_b("Silent")) break block2;
                if (compoundNBT.func_74767_n("Silent")) break block3;
            }
            EntityType.func_220327_a((String)compoundNBT.func_74779_i("id")).filter(MBEntityType.CREEPER_MINION::equals).ifPresent(entityType -> {
                if (player.field_70170_p.field_73012_v.nextInt(500) == 0) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, MBSoundEvents.ENTITY_CREEPER_MINION_AMBIENT, player.func_184176_by(), 1.0f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.5f);
                }
            });
        }
    }
}

