/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.animationapi;

import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.client.animationapi.Transform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Animator {
    private int tempTick;
    private int prevTempTick;
    private boolean correctAnim;
    private final Model mainModel;
    private IAnimatedEntity animEntity;
    private final Map<RendererModel, Transform> transformMap = new HashMap<RendererModel, Transform>();
    private final Map<RendererModel, Transform> prevTransformMap = new HashMap<RendererModel, Transform>();

    public Animator(Model model) {
        this.mainModel = model;
    }

    public IAnimatedEntity getEntity() {
        return this.animEntity;
    }

    public void update(IAnimatedEntity entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.animEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
        for (RendererModel box : this.mainModel.field_78092_r) {
            box.field_78795_f = 0.0f;
            box.field_78796_g = 0.0f;
            box.field_78808_h = 0.0f;
        }
    }

    public boolean setAnimation(int animID) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.animEntity.getAnimationID() == animID;
        return this.correctAnim;
    }

    public void startKeyframe(int duration) {
        if (this.correctAnim) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStaticKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe();
    }

    public void rotate(RendererModel box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).addRotation(x, y, z);
        }
    }

    public void move(RendererModel box, float x, float y, float z) {
        if (this.correctAnim) {
            this.getTransform(box).addOffset(x, y, z);
        }
    }

    private Transform getTransform(RendererModel box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endKeyframe() {
        this.endKeyframe(false);
    }

    private void endKeyframe(boolean stationary) {
        if (this.correctAnim) {
            int animTick = this.animEntity.getAnimationTick();
            if (animTick >= this.prevTempTick && animTick < this.tempTick) {
                if (stationary) {
                    for (RendererModel model : this.prevTransformMap.keySet()) {
                        Transform transform = this.prevTransformMap.get(model);
                        model.field_78795_f += transform.getRotationX();
                        model.field_78796_g += transform.getRotationY();
                        model.field_78808_h += transform.getRotationZ();
                        model.field_78800_c += transform.getOffsetX();
                        model.field_78797_d += transform.getOffsetY();
                        model.field_78798_e += transform.getOffsetZ();
                    }
                } else {
                    Transform transform;
                    float tick = ((float)(animTick - this.prevTempTick) + 1.0f) / (float)(this.tempTick - this.prevTempTick);
                    float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    for (RendererModel model : this.prevTransformMap.keySet()) {
                        transform = this.prevTransformMap.get(model);
                        model.field_78795_f += dec * transform.getRotationX();
                        model.field_78796_g += dec * transform.getRotationY();
                        model.field_78808_h += dec * transform.getRotationZ();
                        model.field_78800_c += dec * transform.getOffsetX();
                        model.field_78797_d += dec * transform.getOffsetY();
                        model.field_78798_e += dec * transform.getOffsetZ();
                    }
                    for (RendererModel model : this.transformMap.keySet()) {
                        transform = this.transformMap.get(model);
                        model.field_78795_f += inc * transform.getRotationX();
                        model.field_78796_g += inc * transform.getRotationY();
                        model.field_78808_h += inc * transform.getRotationZ();
                        model.field_78800_c += inc * transform.getOffsetX();
                        model.field_78797_d += inc * transform.getOffsetY();
                        model.field_78798_e += inc * transform.getOffsetZ();
                    }
                }
            }
            if (!stationary) {
                this.prevTransformMap.clear();
                this.prevTransformMap.putAll(this.transformMap);
                this.transformMap.clear();
            }
        }
    }
}

