/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperChargeLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.CreeperMinionModel;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperMinionRenderer
extends MobRenderer<CreeperMinionEntity, CreeperMinionModel> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/creeper/creeper.png");
    public static final ResourceLocation COLLAR_TEXTURE = MutantBeasts.getEntityTexture("creeper_minion_collar");

    public CreeperMinionRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new CreeperMinionModel(), 0.5f);
        this.func_177094_a(new CreeperChargeLayer<CreeperMinionEntity, CreeperMinionModel>((IEntityRenderer<CreeperMinionEntity, CreeperMinionModel>)this, new CreeperMinionModel(2.0f), CreeperMinionEntity::getPowered));
        this.func_177094_a(new CollarLayer((IEntityRenderer<CreeperMinionEntity, CreeperMinionModel>)this));
    }

    protected void preRenderCallback(CreeperMinionEntity entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1 * 0.5f;
        float f3 = (1.0f + f * 0.1f) / f1 * 0.5f;
        GlStateManager.scalef((float)f2, (float)f3, (float)f2);
        GlStateManager.translatef((float)0.0f, (float)(entitylivingbaseIn.func_70906_o() ? -0.02f : 0.1f), (float)0.0f);
    }

    protected int getColorMultiplier(CreeperMinionEntity entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(CreeperMinionEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CollarLayer
    extends LayerRenderer<CreeperMinionEntity, CreeperMinionModel> {
        private final CreeperMinionModel creeperMinionModel = new CreeperMinionModel(0.01f);

        public CollarLayer(IEntityRenderer<CreeperMinionEntity, CreeperMinionModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(CreeperMinionEntity entityIn, float p_212842_2_, float p_212842_3_, float p_212842_4_, float p_212842_5_, float p_212842_6_, float p_212842_7_, float p_212842_8_) {
            if (!entityIn.func_82150_aj() && entityIn.getCollarColor() != null) {
                this.func_215333_a(COLLAR_TEXTURE);
                float[] afloat = entityIn.getCollarColor().func_193349_f();
                GlStateManager.color3f((float)afloat[0], (float)afloat[1], (float)afloat[2]);
                ((CreeperMinionModel)this.func_215332_c()).func_217111_a(this.creeperMinionModel);
                this.creeperMinionModel.render(entityIn, p_212842_2_, p_212842_3_, p_212842_5_, p_212842_6_, p_212842_7_, p_212842_8_);
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

