/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantArrowModel;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantArrowRenderer
extends EntityRenderer<MutantArrowEntity> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_arrow");
    private final MutantArrowModel arrowModel = new MutantArrowModel();

    public MutantArrowRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public boolean shouldRender(MutantArrowEntity livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void doRender(MutantArrowEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.enableNormalize();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_180548_c(entity);
        for (int i = 0; i < entity.getClones(); ++i) {
            GlStateManager.pushMatrix();
            float scale = entity.getSpeed() - (float)i * 0.08f;
            double x1 = (entity.getTargetX() - entity.field_70165_t) * (double)((float)entity.field_70173_aa + partialTicks) * (double)scale;
            double y1 = (entity.getTargetY() - entity.field_70163_u) * (double)((float)entity.field_70173_aa + partialTicks) * (double)scale;
            double z1 = (entity.getTargetZ() - entity.field_70161_v) * (double)((float)entity.field_70173_aa + partialTicks) * (double)scale;
            GlStateManager.translatef((float)((float)x1), (float)((float)y1), (float)((float)z1));
            GlStateManager.rotatef((float)entity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)entity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)1.2f, (float)1.2f, (float)1.2f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)i * 0.08f));
            this.arrowModel.render(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.popMatrix();
        }
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(MutantArrowEntity entity) {
        return TEXTURE;
    }
}

