/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperChargeLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantCreeperModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantCreeperRenderer
extends MutantRenderer<MutantCreeperEntity, MutantCreeperModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_creeper");

    public MutantCreeperRenderer(EntityRendererManager manager) {
        super(manager, new MutantCreeperModel(), 1.5f);
        this.func_177094_a(new CreeperChargeLayer<MutantCreeperEntity, MutantCreeperModel>((IEntityRenderer<MutantCreeperEntity, MutantCreeperModel>)this, new MutantCreeperModel(2.0f), MutantCreeperEntity::func_70830_n));
    }

    protected void preRenderCallback(MutantCreeperEntity livingEntity, float partialTickTime) {
        float scale = 1.2f;
        if (livingEntity.field_70725_aQ > 0) {
            float f = (float)livingEntity.field_70725_aQ / 100.0f;
            scale -= f * 0.4f;
        }
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
    }

    protected int getColorMultiplier(MutantCreeperEntity livingEntity, float lightBrightness, float partialTickTime) {
        int a = (int)livingEntity.func_70831_j(partialTickTime);
        int r = 255;
        int g = 255;
        int b = 255;
        if (livingEntity.func_70830_n()) {
            r = 160;
            g = 180;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    protected float getDeathMaxRotation(MutantCreeperEntity livingEntity) {
        return 0.0f;
    }

    protected ResourceLocation getEntityTexture(MutantCreeperEntity entity) {
        return TEXTURE;
    }
}

