/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantEndermanModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EndermanModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class MutantEndermanRenderer
extends MutantRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
    private static final Field RENDER_POS_X = ObfuscationReflectionHelper.findField(EntityRendererManager.class, (String)"field_78725_b");
    private static final Field RENDER_POS_Y = ObfuscationReflectionHelper.findField(EntityRendererManager.class, (String)"field_78726_c");
    private static final Field RENDER_POS_Z = ObfuscationReflectionHelper.findField(EntityRendererManager.class, (String)"field_78723_d");
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/mutant_enderman");
    private static final ResourceLocation GLOW_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/glow");
    private static final ResourceLocation EYES_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/eyes");
    private static final ResourceLocation DEATH_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/death");
    private final MutantEndermanModel endermanModel;
    private final EndermanModel<MutantEndermanEntity> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(EntityRendererManager manager) {
        super(manager, new MutantEndermanModel(), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_77045_g;
        this.cloneModel = new EndermanModel(0.0f);
        this.func_177094_a(new EyesLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new GlowLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new HeldBlocksLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
    }

    protected void renderModel(MutantEndermanEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (livingEntity.field_70725_aQ > 80) {
            GlStateManager.depthFunc((int)515);
            GlStateManager.enableAlphaTest();
            GlStateManager.alphaFunc((int)516, (float)((float)(livingEntity.field_70725_aQ - 80) / 200.0f));
            this.func_110776_a(DEATH_TEXTURE);
            this.field_77045_g.func_78088_a((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.depthFunc((int)514);
        }
        super.func_77036_a((LivingEntity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        GlStateManager.depthFunc((int)515);
    }

    public void doRender(MutantEndermanEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean death;
        this.field_76989_e = entity.isClone() ? 0.5f : 0.8f;
        this.field_76987_f = entity.isClone() ? 0.5f : 1.0f;
        this.teleportAttack = false;
        double addX = 0.0;
        double addZ = 0.0;
        this.field_77045_g = entity.isClone() ? this.cloneModel : this.endermanModel;
        this.cloneModel.field_78125_b = entity.func_213398_dR();
        boolean forcedLook = entity.getAttackID() == 6;
        boolean scream = entity.getAttackID() == 8;
        boolean clone = entity.isClone() && entity.func_213398_dR();
        boolean telesmash = entity.getAttackID() == 10 && entity.getAttackTick() < 18;
        boolean bl = death = entity.getAttackID() == 11;
        if (forcedLook || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (entity.getAttackTick() >= 40 && !death) {
                shake *= 0.5;
            }
            if (clone) {
                shake = 0.02;
            }
            if (death) {
                shake = entity.getAttackTick() < 80 ? (double)0.02f : (double)0.05f;
            }
            addX = entity.func_70681_au().nextGaussian() * shake;
            addZ = entity.func_70681_au().nextGaussian() * shake;
        }
        super.func_76986_a((MobEntity)entity, x + addX, y, z + addZ, entityYaw, partialTicks);
        if (entity.getAttackID() == 7) {
            this.teleportAttack = true;
            try {
                double renderPosX = (double)entity.getTeleportPosition().func_177958_n() + 0.5 - RENDER_POS_X.getDouble(this.field_76990_c);
                double renderPosY = (double)entity.getTeleportPosition().func_177956_o() - RENDER_POS_Y.getDouble(this.field_76990_c);
                double renderPosZ = (double)entity.getTeleportPosition().func_177952_p() + 0.5 - RENDER_POS_Z.getDouble(this.field_76990_c);
                super.func_76986_a((MobEntity)entity, renderPosX, renderPosY, renderPosZ, entityYaw, partialTicks);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                MutantBeasts.LOGGER.error("Failed to render mutant enderman teleport position", (Throwable)exception);
            }
        }
    }

    protected float getDeathMaxRotation(MutantEndermanEntity livingEntity) {
        return 0.0f;
    }

    protected ResourceLocation getEntityTexture(MutantEndermanEntity entity) {
        return entity.isClone() ? null : TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class HeldBlocksLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public HeldBlocksLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            GlStateManager.enableRescaleNormal();
            for (int i = 1; i < entityIn.heldBlock.length; ++i) {
                if (entityIn.heldBlock[i] == 0 || entityIn.isClone()) continue;
                GlStateManager.pushMatrix();
                ((MutantEndermanModel)this.func_215332_c()).postRenderArm(0.0625f, i);
                GlStateManager.translatef((float)0.0f, (float)1.2f, (float)0.0f);
                float tick = (float)entityIn.field_70173_aa + (float)i * 2.0f * (float)Math.PI + partialTicks;
                GlStateManager.rotatef((float)(tick * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)(tick * 8.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)(tick * 6.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                float f = 0.75f;
                GlStateManager.scalef((float)(-f), (float)(-f), (float)f);
                int var4 = entityIn.func_70070_b();
                int var5 = var4 % 65536;
                int var6 = var4 / 65536;
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)var5, (float)var6);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_215333_a(AtlasTexture.field_110575_b);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(Block.func_196257_b((int)entityIn.heldBlock[i]), 1.0f);
                GlStateManager.popMatrix();
            }
            GlStateManager.disableRescaleNormal();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class GlowLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public GlowLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            boolean teleport = entityIn.getAttackID() == 7 && entityIn.getAttackTick() < 10;
            boolean scream = entityIn.getAttackID() == 8;
            boolean clone = entityIn.isClone();
            if (teleport || scream || clone) {
                GlStateManager.disableLighting();
                this.func_215333_a(GLOW_TEXTURE);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.loadIdentity();
                float f = ((float)entityIn.field_70173_aa + partialTicks) * 0.008f;
                GlStateManager.translatef((float)f, (float)f, (float)0.0f);
                GlStateManager.matrixMode((int)5888);
                GlStateManager.enableNormalize();
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                int var5 = 61680;
                int var6 = var5 % 65536;
                int var7 = var5 / 65536;
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)var6, (float)var7);
                float red = 0.9f;
                float green = 0.3f;
                float blue = 1.0f;
                float alpha = 1.0f;
                float glowScale = 2.0f;
                if (entityIn.func_96124_cp() != null && entityIn.func_96124_cp().func_178775_l().func_211163_e() != null) {
                    Integer n = entityIn.func_96124_cp().func_178775_l().func_211163_e();
                }
                if (teleport) {
                    if (!MutantEndermanRenderer.this.teleportAttack && entityIn.getAttackTick() >= 8) {
                        alpha -= ((float)(entityIn.getAttackTick() - 8) + partialTicks) / 2.0f;
                    }
                    if (MutantEndermanRenderer.this.teleportAttack && entityIn.getAttackTick() < 2) {
                        alpha = ((float)entityIn.getAttackTick() + partialTicks) / 2.0f;
                    }
                    glowScale = 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        glowScale = 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                    }
                }
                if (scream) {
                    if (entityIn.getAttackTick() < 40) {
                        alpha = ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    } else if (entityIn.getAttackTick() >= 160) {
                        alpha = 1.0f - ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    }
                    glowScale = entityIn.getAttackTick() < 40 ? 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 40.0f : (entityIn.getAttackTick() < 160 ? 2.2f : 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f);
                }
                GlStateManager.enableLighting();
                GlStateManager.color4f((float)0.9f, (float)0.3f, (float)1.0f, (float)alpha);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                if (clone) {
                    this.func_215332_c().func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                } else {
                    GlStateManager.pushMatrix();
                    GlStateManager.scalef((float)glowScale, (float)(glowScale * 0.8f), (float)glowScale);
                    this.func_215332_c().func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    GlStateManager.popMatrix();
                }
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.loadIdentity();
                GlStateManager.matrixMode((int)5888);
                GlStateManager.disableBlend();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class EyesLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public EyesLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!entityIn.isClone()) {
                GlStateManager.disableLighting();
                this.func_215333_a(EYES_TEXTURE);
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)61680.0f, (float)0.0f);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                this.func_215332_c().func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                this.func_215334_a((Entity)entityIn);
                GlStateManager.enableLighting();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

