/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantSnowGolemModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantSnowGolemRenderer
extends MutantRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
    static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final ResourceLocation PUMPKIN_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/pumpkin");
    private static final ResourceLocation GLOW_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/glow");

    public MutantSnowGolemRenderer(EntityRendererManager manager) {
        super(manager, new MutantSnowGolemModel(), 0.7f);
        this.func_177094_a(new GlowLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
        this.func_177094_a(new ThrownBlockLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
    }

    protected void renderModel(MutantSnowGolemEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        super.func_77036_a((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (!entitylivingbaseIn.func_82150_aj() && entitylivingbaseIn.isPumpkinEquipped()) {
            this.func_110776_a(PUMPKIN_TEXTURE);
            ((MutantSnowGolemModel)this.field_77045_g).render(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        }
    }

    protected ResourceLocation getEntityTexture(MutantSnowGolemEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ThrownBlockLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public ThrownBlockLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.isThrowing() && entityIn.getThrowingTick() < 7) {
                GlStateManager.enableRescaleNormal();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.4f, (float)0.0f, (float)0.0f);
                ((MutantSnowGolemModel)this.func_215332_c()).postRenderArm(0.0625f);
                GlStateManager.translatef((float)0.0f, (float)0.9f, (float)0.0f);
                GlStateManager.scalef((float)-0.8f, (float)-0.8f, (float)0.8f);
                int i = entityIn.func_70070_b();
                int j = i % 65536;
                int k = i / 65536;
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_215333_a(AtlasTexture.field_110575_b);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(Blocks.field_150432_aD.func_176223_P(), 1.0f);
                GlStateManager.popMatrix();
                GlStateManager.disableRescaleNormal();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class GlowLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public GlowLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.isPumpkinEquipped()) {
                this.func_215333_a(GLOW_TEXTURE);
                GlStateManager.disableLighting();
                GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)61680.0f, (float)0.0f);
                float f = (float)entityIn.field_70173_aa + partialTicks;
                float blue = MathHelper.func_76134_b((float)(f * 0.1f));
                float green = MathHelper.func_76134_b((float)(f * 0.15f));
                GlStateManager.color4f((float)1.0f, (float)(0.8f + 0.05f * green), (float)(0.15f + 0.2f * blue), (float)1.0f);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                ((MutantSnowGolemModel)this.func_215332_c()).render(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                this.func_215334_a((Entity)entityIn);
                GlStateManager.enableLighting();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

