/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantZombieModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantZombieRenderer
extends MutantRenderer<MutantZombieEntity, MutantZombieModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_zombie");

    public MutantZombieRenderer(EntityRendererManager manager) {
        super(manager, new MutantZombieModel(), 1.0f);
    }

    protected void renderModel(MutantZombieEntity living, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (living.vanishTime > 0) {
            GlStateManager.enableNormalize();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((float)living.vanishTime + ((MutantZombieModel)this.field_77045_g).getPartialTick()) / 140.0f * 0.6f));
        }
        super.func_77036_a((LivingEntity)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (living.vanishTime > 0) {
            GlStateManager.disableBlend();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void preRenderCallback(MutantZombieEntity entitylivingbaseIn, float partialTickTime) {
        GlStateManager.scalef((float)1.3f, (float)1.3f, (float)1.3f);
    }

    protected void applyRotations(MutantZombieEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        GlStateManager.rotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        int pitch = Math.min(20, entityLiving.field_70725_aQ);
        boolean reviving = false;
        if (entityLiving.field_70725_aQ > 100) {
            pitch = 140 - entityLiving.field_70725_aQ;
            reviving = true;
        }
        if (pitch > 0) {
            float f = ((float)pitch + partialTicks - 1.0f) / 20.0f * 1.6f;
            if (reviving) {
                f = ((float)pitch - partialTicks) / 40.0f * 1.6f;
            }
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.rotatef((float)(f * this.getDeathMaxRotation(entityLiving)), (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        if (entityLiving.field_70725_aQ > 0 && entityLiving.func_145818_k_() && (s = TextFormatting.func_110646_a((String)entityLiving.func_200200_C_().getString())) != null && ("Dinnerbone".equals(s) || "Grumm".equals(s))) {
            GlStateManager.translatef((float)0.0f, (float)(entityLiving.func_213302_cg() + 0.1f), (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float getDeathMaxRotation(MutantZombieEntity living) {
        return 80.0f;
    }

    protected ResourceLocation getEntityTexture(MutantZombieEntity entity) {
        return TEXTURE;
    }
}

