/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.SpiderPigModel;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpiderPigRenderer
extends MutantRenderer<SpiderPigEntity, SpiderPigModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("spider_pig/spider_pig");
    private static final ResourceLocation SADDLE_TEXTURE = MutantBeasts.getEntityTexture("spider_pig/saddle");

    public SpiderPigRenderer(EntityRendererManager manager) {
        super(manager, new SpiderPigModel(0.0f), 0.8f);
        this.func_177094_a(new SaddleLayer((IEntityRenderer<SpiderPigEntity, SpiderPigModel>)this));
    }

    protected float getDeathMaxRotation(SpiderPigEntity entityLivingBaseIn) {
        return 180.0f;
    }

    protected void preRenderCallback(SpiderPigEntity entitylivingbaseIn, float partialTickTime) {
        float scale = 1.2f * entitylivingbaseIn.func_213355_cm();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
    }

    protected ResourceLocation getEntityTexture(SpiderPigEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SaddleLayer
    extends LayerRenderer<SpiderPigEntity, SpiderPigModel> {
        private final SpiderPigModel spiderPigModel = new SpiderPigModel(-0.6f);

        public SaddleLayer(IEntityRenderer<SpiderPigEntity, SpiderPigModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(SpiderPigEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entityIn.isSaddled()) {
                this.func_215333_a(SADDLE_TEXTURE);
                ((SpiderPigModel)this.func_215332_c()).func_217111_a(this.spiderPigModel);
                this.spiderPigModel.render(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

