/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.layers;

import chumbanotz.mutantbeasts.client.renderer.entity.CreeperMinionRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperChargeLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.CreeperMinionModel;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperMinionShoulderLayer<T extends PlayerEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    private final CreeperMinionModel creeperMinionModel = new CreeperMinionModel();
    private final CreeperMinionModel chargedModel = new CreeperMinionModel(2.0f);
    private final CreeperMinionModel collarModel = new CreeperMinionModel(0.01f);

    public CreeperMinionShoulderLayer(IEntityRenderer<T, PlayerModel<T>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderOnShoulder(entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, true);
        this.renderOnShoulder(entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, false);
        GlStateManager.disableRescaleNormal();
    }

    private void renderOnShoulder(T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, boolean leftShoulder) {
        CompoundNBT compoundnbt = leftShoulder ? player.func_192023_dk() : player.func_192025_dl();
        EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).filter(MBEntityType.CREEPER_MINION::equals).ifPresent(entityType -> {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)(leftShoulder ? 0.42f : -0.42f), (float)(player.func_213287_bg() ? -0.55f : -0.75f), (float)0.0f);
            this.func_215333_a(CreeperMinionRenderer.TEXTURE);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.creeperMinionModel.render(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (compoundnbt.func_150297_b("CollarColor", 99)) {
                this.func_215333_a(CreeperMinionRenderer.COLLAR_TEXTURE);
                float[] afloat = DyeColor.func_196056_a((int)compoundnbt.func_74771_c("CollarColor")).func_193349_f();
                GlStateManager.color3f((float)afloat[0], (float)afloat[1], (float)afloat[2]);
                this.collarModel.render(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (compoundnbt.func_74767_n("Powered")) {
                this.func_215333_a(CreeperChargeLayer.LIGHTNING_TEXTURE);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.loadIdentity();
                float f = (float)player.field_70173_aa + partialTicks;
                GlStateManager.translatef((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
                GlStateManager.matrixMode((int)5888);
                GlStateManager.enableBlend();
                GlStateManager.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                GlStateManager.disableLighting();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                this.chargedModel.render(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.loadIdentity();
                GlStateManager.matrixMode((int)5888);
                GlStateManager.enableLighting();
                GlStateManager.disableBlend();
                GlStateManager.depthMask((boolean)true);
            }
            GlStateManager.popMatrix();
        });
    }

    public boolean func_177142_b() {
        return false;
    }
}

