/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class EndersoulHandModel
extends Model {
    private final RendererModel hand;
    private final RendererModel[] finger = new RendererModel[3];
    private final RendererModel[] foreFinger = new RendererModel[3];
    private final RendererModel thumb;

    public EndersoulHandModel() {
        int i;
        this.field_78090_t = 32;
        this.hand = new RendererModel((Model)this);
        this.hand.func_78793_a(0.0f, 17.5f, 0.0f);
        float fingerScale = 0.6f;
        for (i = 0; i < this.finger.length; ++i) {
            this.finger[i] = new RendererModel((Model)this, i * 4, 0);
            this.finger[i].func_78790_a(-0.5f, 0.0f, -0.5f, 1, i == 1 ? 6 : 5, 1, fingerScale);
        }
        this.finger[0].func_78793_a(-0.5f, 0.0f, -1.0f);
        this.finger[1].func_78793_a(-0.5f, 0.0f, 0.0f);
        this.finger[2].func_78793_a(-0.5f, 0.0f, 1.0f);
        for (i = 0; i < this.foreFinger.length; ++i) {
            this.foreFinger[i] = new RendererModel((Model)this, 1 + i * 5, 0);
            this.foreFinger[i].func_78790_a(-0.5f, 0.0f, -0.5f, 1, i == 1 ? 6 : 5, 1, fingerScale - 0.01f);
            this.foreFinger[i].func_78793_a(0.0f, 0.5f + (float)(i == 1 ? 6 : 5), 0.0f);
        }
        for (i = 0; i < this.finger.length; ++i) {
            this.hand.func_78792_a(this.finger[i]);
            this.finger[i].func_78792_a(this.foreFinger[i]);
        }
        this.thumb = new RendererModel((Model)this, 14, 0);
        this.thumb.func_78790_a(-0.5f, 0.0f, -0.5f, 1, 5, 1, fingerScale);
        this.thumb.func_78793_a(0.5f, 0.0f, -0.5f);
        this.hand.func_78792_a(this.thumb);
    }

    private void resetAngles(RendererModel model) {
        model.field_78795_f = 0.0f;
        model.field_78796_g = 0.0f;
        model.field_78808_h = 0.0f;
    }

    public void setAngles() {
        this.resetAngles(this.hand);
        for (int i = 0; i < this.finger.length; ++i) {
            this.resetAngles(this.finger[i]);
            this.resetAngles(this.foreFinger[i]);
        }
        this.resetAngles(this.thumb);
        this.hand.field_78796_g = -0.3926991f;
        this.finger[0].field_78795_f = -0.2617994f;
        this.finger[1].field_78808_h = 0.17453294f;
        this.finger[2].field_78795_f = 0.2617994f;
        this.foreFinger[0].field_78808_h = -0.2617994f;
        this.foreFinger[1].field_78808_h = -0.3926991f;
        this.foreFinger[2].field_78808_h = -0.2617994f;
        this.thumb.field_78795_f = -0.62831855f;
        this.thumb.field_78808_h = -0.3926991f;
    }

    public void render() {
        this.setAngles();
        this.hand.func_78785_a(0.0625f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Baked
    extends BakedModelWrapper<IBakedModel> {
        private final IBakedModel bakedModel;

        public Baked(IBakedModel guiModel, IBakedModel bakedModel) {
            super(guiModel);
            this.bakedModel = bakedModel;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            switch (cameraTransformType) {
                case GUI: 
                case FIXED: 
                case GROUND: {
                    return super.handlePerspective(cameraTransformType);
                }
            }
            return this.bakedModel.handlePerspective(cameraTransformType);
        }
    }
}

