/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.client.animationapi.IAnimatedEntity;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MutantSkeletonEntity
extends MonsterEntity
implements IAnimatedEntity {
    public static final byte MELEE_ATTACK = 4;
    public static final byte SHOOT_ATTACK = 5;
    public static final byte MULTI_SHOT_ATTACK = 6;
    public static final byte CONSTRICT_RIBS_ATTACK = 7;
    private int attackID;
    private int attackTick;

    public MutantSkeletonEntity(EntityType<? extends MutantSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new ShootGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new MultiShotGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new ConstrictRibsAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.1).setMaxAttackTick(6));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WolfEntity.class, true, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(5.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.25f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_213623_ec() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0 || id >= 4 && id <= 7) {
            this.attackID = id;
            this.attackTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_184644_a(PathNodeType.WATER, this.func_203005_aq() ? 16.0f : -1.0f);
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (this.func_70089_S() && this.field_70173_aa % 100 == 0 && !this.field_70170_p.func_72935_r() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            if (this.field_70146_Z.nextInt(4) != 0) {
                this.setAttackID(4);
            } else if (this.field_70122_E || this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                this.setAttackID(7);
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return !(source.func_76346_g() instanceof MutantSkeletonEntity) && super.func_70097_a(source, amount);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_70108_f((Entity)this);
        livingEntity.field_70133_I = true;
    }

    @Override
    public int getAnimationID() {
        return this.attackID;
    }

    @Override
    public int getAnimationTick() {
        return this.attackTick;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        return spawnDataIn;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0))) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76348_h(), 7.0f);
            }
            for (int i = 0; i < 18; ++i) {
                int j = i;
                if (i >= 3) {
                    j = i + 1;
                }
                if (j >= 4) {
                    ++j;
                }
                if (j >= 5) {
                    ++j;
                }
                if (j >= 6) {
                    ++j;
                }
                if (j >= 9) {
                    ++j;
                }
                if (j >= 10) {
                    ++j;
                }
                if (j >= 11) {
                    ++j;
                }
                if (j >= 12) {
                    ++j;
                }
                if (j >= 15) {
                    ++j;
                }
                if (j >= 16) {
                    ++j;
                }
                if (j >= 17) {
                    ++j;
                }
                if (j >= 18) {
                    ++j;
                }
                if (j >= 20) {
                    ++j;
                }
                BodyPartEntity part = new BodyPartEntity(this.field_70170_p, (MobEntity)this, j);
                part.func_213317_d(part.func_213322_ci().func_72441_c((double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f), (double)(this.field_70146_Z.nextFloat() * 0.25f + 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.8f * 2.0f - 0.8f)));
                this.field_70170_p.func_217376_c((Entity)part);
            }
        }
        this.field_70725_aQ = 19;
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SKELETON_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_SKELETON_STEP, 0.15f, 1.0f);
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)id);
    }

    class MultiShotGoal
    extends Goal {
        private final List<MutantArrowEntity> shots = new ArrayList<MutantArrowEntity>();
        private LivingEntity attackTarget;

        public MultiShotGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && (MutantSkeletonEntity.this.field_70122_E || MutantSkeletonEntity.this.field_70170_p.func_72953_d(MutantSkeletonEntity.this.func_174813_aQ())) && MutantSkeletonEntity.this.attackID == 0 && MutantSkeletonEntity.this.field_70146_Z.nextInt(26) == 0 && MutantSkeletonEntity.this.func_70685_l((Entity)this.attackTarget);
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 30;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(6);
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantSkeletonEntity.this.attackTick == 10) {
                double x = this.attackTarget.field_70165_t - MutantSkeletonEntity.this.field_70165_t;
                double z = this.attackTarget.field_70161_v - MutantSkeletonEntity.this.field_70161_v;
                float scale = 0.06f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.03f;
                if (MutantSkeletonEntity.this.func_70068_e((Entity)this.attackTarget) < 16.0) {
                    x *= -1.0;
                    z *= -1.0;
                    scale = (float)((double)scale * 5.0);
                }
                MutantSkeletonEntity.this.func_213293_j(x * (double)scale, 1.1f, z * (double)scale);
            }
            if (MutantSkeletonEntity.this.attackTick == 15) {
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219615_bG, 1.0f, 1.0f);
            }
            if (MutantSkeletonEntity.this.attackTick == 20) {
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219610_bB, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
            if (MutantSkeletonEntity.this.attackTick >= 24 && MutantSkeletonEntity.this.attackTick < 28) {
                if (!this.shots.isEmpty()) {
                    Iterator<MutantArrowEntity> iterator = this.shots.iterator();
                    while (iterator.hasNext()) {
                        MutantArrowEntity arrowEntity;
                        MutantArrowEntity shot = arrowEntity = iterator.next();
                        MutantSkeletonEntity.this.field_70170_p.func_217376_c((Entity)arrowEntity);
                    }
                    this.shots.clear();
                }
                for (int i = 0; i < 6; ++i) {
                    MutantArrowEntity shot = new MutantArrowEntity(MutantSkeletonEntity.this.field_70170_p, (LivingEntity)MutantSkeletonEntity.this, this.attackTarget);
                    shot.setSpeed(1.2f - MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.1f);
                    shot.setClones(2);
                    shot.randomize(3.0f);
                    shot.setDamage(5 + MutantSkeletonEntity.this.field_70146_Z.nextInt(5));
                    this.shots.add(shot);
                }
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.shots.clear();
            this.attackTarget = null;
        }
    }

    class ShootGoal
    extends Goal {
        private LivingEntity attackTarget;

        public ShootGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSkeletonEntity.this.func_70685_l((Entity)this.attackTarget) && MutantSkeletonEntity.this.func_70068_e((Entity)this.attackTarget) > 4.0 && MutantSkeletonEntity.this.attackID == 0 && MutantSkeletonEntity.this.field_70146_Z.nextInt(12) == 0;
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 32;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.setAttackID(5);
        }

        public void func_75246_d() {
            MutantSkeletonEntity.this.field_70699_by.func_75499_g();
            MutantSkeletonEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantSkeletonEntity.this.attackTick == 5) {
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219614_bF, 1.0f, 1.0f);
            }
            if (MutantSkeletonEntity.this.attackTick == 20) {
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219610_bB, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
            if (MutantSkeletonEntity.this.attackTick == 26) {
                MutantArrowEntity arrowEntity = new MutantArrowEntity(MutantSkeletonEntity.this.field_70170_p, (LivingEntity)MutantSkeletonEntity.this, this.attackTarget);
                if (MutantSkeletonEntity.this.field_70737_aN > 0 && MutantSkeletonEntity.this.field_110153_bc > 0.0f) {
                    arrowEntity.randomize((float)MutantSkeletonEntity.this.field_70737_aN / 2.0f);
                } else if (!MutantSkeletonEntity.this.func_70685_l((Entity)this.attackTarget)) {
                    arrowEntity.randomize(0.5f + MutantSkeletonEntity.this.field_70146_Z.nextFloat());
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76436_u, 80 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 0));
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76438_s, 120 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 1));
                }
                if (MutantSkeletonEntity.this.field_70146_Z.nextInt(4) == 0) {
                    arrowEntity.setPotionEffect(new EffectInstance(Effects.field_76421_d, 120 + MutantSkeletonEntity.this.field_70146_Z.nextInt(60), 1));
                }
                MutantSkeletonEntity.this.field_70170_p.func_217376_c((Entity)arrowEntity);
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.25f);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class ConstrictRibsAttackGoal
    extends Goal {
        private LivingEntity attackTarget;

        public ConstrictRibsAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSkeletonEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSkeletonEntity.this.attackID == 7;
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 20;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.attackTick = 0;
        }

        public void func_75246_d() {
            if (MutantSkeletonEntity.this.attackTick == 5) {
                this.attackTarget.func_184210_p();
            }
            if (MutantSkeletonEntity.this.attackTick == 6) {
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantSkeletonEntity.this), (float)MutantSkeletonEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + 7.0f);
                this.attackTarget.func_213293_j((double)((1.0f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f) * (float)(MutantSkeletonEntity.this.field_70146_Z.nextBoolean() ? 1 : -1)), (double)(0.4f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.8f), (double)((1.0f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f) * (float)(MutantSkeletonEntity.this.field_70146_Z.nextBoolean() ? 1 : -1)));
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 0.8f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f);
                EntityUtil.disableShield(this.attackTarget, DamageSource.func_76358_a((LivingEntity)MutantSkeletonEntity.this), 100);
                EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class MeleeGoal
    extends Goal {
        public MeleeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return MutantSkeletonEntity.this.func_70638_az() != null && MutantSkeletonEntity.this.attackID == 4;
        }

        public boolean func_75253_b() {
            return MutantSkeletonEntity.this.attackTick < 14;
        }

        public void func_75249_e() {
            MutantSkeletonEntity.this.attackTick = 0;
        }

        public void func_75246_d() {
            if (MutantSkeletonEntity.this.func_70638_az() != null && MutantSkeletonEntity.this.func_70638_az().func_70089_S()) {
                MutantSkeletonEntity.this.field_70749_g.func_75651_a((Entity)MutantSkeletonEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            if (MutantSkeletonEntity.this.attackTick == 3) {
                double reach = 2.3f + MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.3f;
                for (Entity entity : MutantSkeletonEntity.this.field_70170_p.func_175674_a((Entity)MutantSkeletonEntity.this, MutantSkeletonEntity.this.func_174813_aQ().func_72314_b(reach, 0.0, reach), EntityPredicates.field_188444_d)) {
                    double dist = MutantSkeletonEntity.this.func_70032_d(entity);
                    double x = MutantSkeletonEntity.this.field_70165_t - entity.field_70165_t;
                    double z = MutantSkeletonEntity.this.field_70161_v - entity.field_70161_v;
                    if (!EntityUtil.isFacing((LivingEntity)MutantSkeletonEntity.this, x, z, 60.0f) || entity instanceof MutantSkeletonEntity) continue;
                    float power = 1.8f + (float)MutantSkeletonEntity.this.field_70146_Z.nextInt(5) * 0.15f;
                    entity.func_184210_p();
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantSkeletonEntity.this), (float)MutantSkeletonEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + (float)MutantSkeletonEntity.this.field_70146_Z.nextInt(2));
                    entity.func_213293_j(-x / dist * (double)power, Math.max((double)0.28f, entity.func_213322_ci().field_72448_b), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
                MutantSkeletonEntity.this.func_184185_a(SoundEvents.field_187721_dT, 1.0f, 1.0f / (MutantSkeletonEntity.this.field_70146_Z.nextFloat() * 0.4f + 1.2f));
            }
        }

        public void func_75251_c() {
            MutantSkeletonEntity.this.setAttackID(0);
        }
    }
}

