/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.ai.goal.FleeRainGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantSnowGolemEntity
extends GolemEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> PUMPKIN_EQUIPPED = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolemEntity(EntityType<? extends MutantSnowGolemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimJumpGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeRainGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.1, 30, 12.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrowIceGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, entity -> entity instanceof IMob && (!(entity instanceof CreeperEntity) || ((CreeperEntity)entity).func_70638_az() == this)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.26f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUMPKIN_EQUIPPED, (Object)true);
    }

    public boolean isPumpkinEquipped() {
        return (Boolean)this.field_70180_af.func_187225_a(PUMPKIN_EQUIPPED);
    }

    public void setPumpkinEquipped(boolean pumpkinEquipped) {
        this.field_70180_af.func_187227_b(PUMPKIN_EQUIPPED, (Object)pumpkinEquipped);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn).setAvoidRain(true);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.0f;
    }

    public boolean func_213336_c(LivingEntity target) {
        return target instanceof IMob;
    }

    protected void func_184594_b(BlockPos pos) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_184644_a(PathNodeType.WATER, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? 16.0f : -1.0f);
        float biomeTemp = this.field_70170_p.func_180494_b(this.func_180425_c()).func_225486_c(this.func_180425_c());
        if (this.isThrowing) {
            ++this.throwingTick;
        }
        if (this.func_70026_G() && this.field_70173_aa % 20 == 0) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (biomeTemp > 1.2f && !this.func_70644_a(Effects.field_76426_n)) {
            if (this.field_70146_Z.nextFloat() > Math.min(80.0f, this.func_110143_aJ()) * 0.01f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            }
            if (this.field_70173_aa % 60 == 0) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        }
        if (this.func_70089_S() && biomeTemp < 0.5f && this.field_70173_aa % 200 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    boolean placeIce;
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    BlockPos blockpos = new BlockPos(x + i, y, z + j);
                    BlockPos blockpos1 = new BlockPos(x + i, y - 1, z + j);
                    BlockPos blockpos2 = new BlockPos(x + i, y + 1, z + j);
                    boolean placeSnow = biomeTemp < 0.95f && this.field_70170_p.func_175623_d(blockpos) && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, blockpos);
                    boolean bl = placeIce = this.field_70170_p.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150355_j;
                    if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == Blocks.field_150355_j) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (this.field_70170_p.func_180495_p(blockpos2).func_177230_c() == Blocks.field_150355_j) {
                        this.field_70170_p.func_175656_a(blockpos2, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150433_aE.func_176223_P());
                    }
                    if (!placeIce) continue;
                    this.field_70170_p.func_175656_a(blockpos1, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151097_aZ && this.isPumpkinEquipped()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setPumpkinEquipped(false);
            }
            player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isThrowing() {
        return this.isThrowing;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, isThrowing ? (byte)1 : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0 || id == 1) {
            this.isThrowing = id == 1;
            this.throwingTick = 0;
        } else if (id == 4) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.5f) - (double)this.func_213311_cf(), this.field_70163_u - 0.15 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 1.5f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        } else if (id == 5 || id == 6 || id == 7) {
            EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)(id == 5 ? ParticleTypes.field_197633_z : new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150433_aE.func_176223_P())), id == 5 ? 1 : (id == 6 ? 10 : 30));
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof SnowballEntity) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)5);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (flag && amount > 0.0f) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        }
        return flag;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(LivingEntity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolemEntity) || attacker == target) {
            return false;
        }
        if (target instanceof MobEntity) {
            return target instanceof IMob || ((MobEntity)target).func_70638_az() == attacker;
        }
        return ((MutantSnowGolemEntity)attacker).func_70638_az() == target;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Pumpkin", this.isPumpkinEquipped());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin")) {
            this.setPumpkinEquipped(compound.func_74767_n("Pumpkin"));
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187815_fJ, 0.15f, 1.0f);
    }

    class ThrowIceGoal
    extends Goal {
        private LivingEntity attackTarget;

        ThrowIceGoal() {
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSnowGolemEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSnowGolemEntity.this.isThrowing;
        }

        public void func_75249_e() {
            MutantSnowGolemEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75253_b() {
            return MutantSnowGolemEntity.this.isThrowing && MutantSnowGolemEntity.this.throwingTick < 20;
        }

        public void func_75246_d() {
            MutantSnowGolemEntity.this.field_70761_aq = MutantSnowGolemEntity.this.field_70177_z;
            if (MutantSnowGolemEntity.this.throwingTick == 7) {
                ThrowableBlockEntity block = new ThrowableBlockEntity(MutantSnowGolemEntity.this, MutantSnowGolemEntity.this.field_70170_p);
                block.field_70163_u += 1.0;
                double x = this.attackTarget.field_70165_t - block.field_70165_t;
                double y = this.attackTarget.field_70163_u - block.field_70163_u;
                double z = this.attackTarget.field_70161_v - block.field_70161_v;
                double xz = Math.sqrt(x * x + z * z);
                block.func_70186_c(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                MutantSnowGolemEntity.this.field_70170_p.func_217376_c((Entity)block);
            }
        }

        public void func_75251_c() {
            MutantSnowGolemEntity.this.setThrowing(false);
        }
    }

    class SwimJumpGoal
    extends Goal {
        private int jumpTick;
        private boolean waterReplaced;
        private BlockPos prevPos;

        public SwimJumpGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            MutantSnowGolemEntity.this.field_70699_by.func_212239_d(true);
        }

        public boolean func_75250_a() {
            return MutantSnowGolemEntity.this.func_203005_aq();
        }

        public void func_75249_e() {
            this.prevPos = new BlockPos(MutantSnowGolemEntity.this.field_70165_t, MutantSnowGolemEntity.this.func_174813_aQ().field_72338_b - 1.0, MutantSnowGolemEntity.this.field_70161_v);
            MutantSnowGolemEntity.this.func_213293_j((MutantSnowGolemEntity.this.field_70146_Z.nextFloat() - MutantSnowGolemEntity.this.field_70146_Z.nextFloat()) * 0.9f, 1.5, (MutantSnowGolemEntity.this.field_70146_Z.nextFloat() - MutantSnowGolemEntity.this.field_70146_Z.nextFloat()) * 0.9f);
            MutantSnowGolemEntity.this.func_70097_a(DamageSource.field_76369_e, 16.0f);
        }

        public boolean func_75253_b() {
            return this.jumpTick > 0;
        }

        public void func_75246_d() {
            --this.jumpTick;
            if (!this.waterReplaced && !MutantSnowGolemEntity.this.func_203005_aq() && this.jumpTick < 17 && ForgeEventFactory.getMobGriefingEvent((World)MutantSnowGolemEntity.this.field_70170_p, (Entity)MutantSnowGolemEntity.this)) {
                int i = this.prevPos.func_177956_o();
                i = this.getWaterSurfaceHeight(MutantSnowGolemEntity.this.field_70170_p, this.prevPos);
                if ((double)i > MutantSnowGolemEntity.this.field_70163_u) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            int posZ;
                            int posY;
                            int posX;
                            Block block;
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2) || (block = MutantSnowGolemEntity.this.field_70170_p.func_180495_p(new BlockPos(posX = this.prevPos.func_177958_n() + x, posY = this.prevPos.func_177956_o() + y, posZ = this.prevPos.func_177952_p() + z)).func_177230_c()) != Blocks.field_150350_a && block != Blocks.field_150355_j || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && MutantSnowGolemEntity.this.field_70146_Z.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && MutantSnowGolemEntity.this.field_70146_Z.nextInt(3) == 0)) continue;
                            MutantSnowGolemEntity.this.field_70170_p.func_175656_a(new BlockPos(posX, posY, posZ), Blocks.field_150432_aD.func_176223_P());
                        }
                    }
                }
                Block topBlock = MutantSnowGolemEntity.this.field_70170_p.func_180495_p(this.prevPos.func_177981_b(2)).func_177230_c();
                if (topBlock == Blocks.field_150350_a) {
                    MutantSnowGolemEntity.this.field_70170_p.func_175656_a(this.prevPos.func_177981_b(2), Blocks.field_150432_aD.func_176223_P());
                }
                this.waterReplaced = true;
            }
        }

        public void func_75251_c() {
            this.jumpTick = 20;
            this.waterReplaced = false;
        }

        int getWaterSurfaceHeight(World world, BlockPos coord) {
            Block block;
            int y = coord.func_177956_o();
            while ((block = world.func_180495_p(coord.func_177984_a()).func_177230_c()) == Blocks.field_150355_j) {
                ++y;
            }
            return y;
        }
    }
}

