/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.capability.SummonableCapability;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.SeismicWave;
import chumbanotz.mutantbeasts.util.ZombieResurrection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantZombieEntity
extends MonsterEntity {
    private static final DataParameter<Integer> LIVES = EntityDataManager.func_187226_a(MutantZombieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> THROW_ATTACK_STATE = EntityDataManager.func_187226_a(MutantZombieEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_DEATH_TIME = 140;
    public static final int MAX_VANISH_TIME = 100;
    public static final byte MELEE_ATTACK = 4;
    public static final byte THROW_ATTACK = 5;
    public static final byte ROAR_ATTACK = 6;
    private int attackID;
    private int attackTick;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private final List<SeismicWave> seismicWaveList = new ArrayList<SeismicWave>();
    private final List<ZombieResurrection> resurrectionList = new ArrayList<ZombieResurrection>();
    private LivingEntity killer;
    private DamageSource deathCause = DamageSource.field_76377_j;

    public MutantZombieEntity(EntityType<? extends MutantZombieEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 30;
        this.field_70158_ak = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SlamGroundGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new RoarGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new ThrowAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.2).setMaxAttackTick(0));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 1.0, true, 4, () -> false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIVES, (Object)3);
        this.field_70180_af.func_187214_a(THROW_ATTACK_STATE, (Object)0);
    }

    public int getLives() {
        return (Integer)this.field_70180_af.func_187225_a(LIVES);
    }

    private void setLives(int lives) {
        this.field_70180_af.func_187227_b(LIVES, (Object)lives);
    }

    public boolean getThrowAttackHit() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getThrowAttackFinish() {
        return ((Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinish(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(THROW_ATTACK_STATE);
        this.field_70180_af.func_187227_b(THROW_ATTACK_STATE, (Object)(flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public int getAttackID() {
        return this.attackID;
    }

    private void setAttackID(int attackID) {
        this.attackID = attackID;
        this.attackTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, (byte)attackID);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.8f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    protected float func_110146_f(float renderYawOffset, float distance) {
        return this.func_70089_S() ? super.func_110146_f(renderYawOffset, distance) : distance;
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return 16;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151033_d && this.field_70725_aQ > 0 && !this.func_70027_ad() && !this.func_70026_G()) {
            this.func_70015_d(8);
            player.func_184609_a(hand);
            player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, livingEntity -> livingEntity.func_213334_d(hand));
            this.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.attackID == 5) {
            return super.func_70652_k(entityIn);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackID == 0 && this.field_70146_Z.nextInt(5) == 0 && this.func_70685_l(entityIn)) {
                this.setAttackID(5);
            }
            if (this.attackID == 0 && this.field_70122_E) {
                this.setAttackID(4);
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76352_a() && source.func_188404_v() != null) {
            amount *= 0.5f;
        }
        if (this.attackID == 6 && source != DamageSource.field_76380_i) {
            if (this.attackTick <= 10) {
                return false;
            }
            amount *= 0.15f;
        }
        return (entity = source.func_76346_g()) != null && (!this.canHarm(entity) || this.attackID == 5 && entity == this.func_70638_az()) ? false : super.func_70097_a(source, amount);
    }

    protected void func_213623_ec() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            EntityUtil.spawnParticlesAtEntity((Entity)this, (IParticleData)ParticleTypes.field_197631_x, 30);
        } else if (id == 0 || id >= 4 && id <= 6) {
            this.attackID = id;
            this.attackTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70619_bc() {
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) <= 49.0) {
            int chance;
            int n = chance = !this.func_70781_l() || !this.func_70685_l((Entity)this.func_70638_az()) || this.func_189748_bU() != null && this.func_189748_bU().func_76352_a() ? 5 : 20;
            if (this.attackID == 0 && this.field_70122_E && this.field_70146_Z.nextInt(chance) == 0) {
                this.setAttackID(4);
            }
            if (this.attackID == 0 && this.func_70068_e((Entity)this.func_70638_az()) < 1.0 && this.field_70146_Z.nextInt(125) == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
                this.setAttackID(5);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        this.func_184644_a(PathNodeType.LEAVES, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? 0.0f : -1.0f);
        if (this.func_70089_S() && this.field_70173_aa % 100 == 0 && !this.field_70170_p.func_72935_r() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove(zr);
        }
        if (this.func_110143_aJ() > 0.0f) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
        }
        if (this.func_70089_S() && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            AxisAlignedBB bb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)bb.field_72340_a), (int)MathHelper.func_76128_c((double)bb.field_72338_b), (int)MathHelper.func_76128_c((double)bb.field_72339_c), (int)MathHelper.func_76128_c((double)bb.field_72336_d), (int)MathHelper.func_76128_c((double)bb.field_72337_e), (int)MathHelper.func_76128_c((double)bb.field_72334_f))) {
                Block block = this.field_70170_p.func_180495_p(blockpos).func_177230_c();
                if (this.field_70170_p.field_72995_K || !(block instanceof BambooBlock) && !BlockTags.field_206952_E.func_199685_a_((Object)block) && !Tags.Blocks.GLASS.func_199685_a_((Object)block)) continue;
                this.field_70170_p.func_175655_b(blockpos, false);
            }
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.field_70759_as - this.field_70761_aq; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.attackID == 4) {
            offset = 0.2f;
        }
        this.field_70761_aq += yaw * offset;
    }

    protected void updateAnimation() {
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (this.attackID == 5) {
            if (this.getThrowAttackHit()) {
                if (this.throwHitTick == -1) {
                    this.throwHitTick = 0;
                }
                ++this.throwHitTick;
            }
            if (this.getThrowAttackFinish()) {
                if (this.throwFinishTick == -1) {
                    this.throwFinishTick = 0;
                }
                ++this.throwFinishTick;
            }
        } else {
            this.throwHitTick = -1;
            this.throwFinishTick = -1;
        }
    }

    protected void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.field_70170_p, (Entity)this);
            AxisAlignedBB box = new AxisAlignedBB((double)wave.func_177958_n(), (double)(wave.func_177956_o() + 1), (double)wave.func_177952_p(), (double)(wave.func_177958_n() + 3), (double)(wave.func_177956_o() + 2), (double)(wave.func_177952_p() + 3));
            if (wave.isFirst()) {
                double addScale = this.field_70146_Z.nextDouble() * 0.75;
                box.func_72314_b(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, box, EntityPredicates.field_188444_d.and(this::canHarm))) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_151518_m(), wave.isFirst() ? (float)(9 + this.field_70146_Z.nextInt(4)) : (float)(6 + this.field_70146_Z.nextInt(3)));
                double x = entity.field_70165_t - this.field_70165_t;
                double z = entity.field_70161_v - this.field_70161_v;
                double d = Math.sqrt(x * x + z * z);
                entity.func_213293_j(x / d * 0.3, 0.04, z / d * 0.3);
                entity.field_70160_al = true;
                EntityUtil.sendPlayerVelocityPacket(entity);
                if (!(entity instanceof LivingEntity) || this.field_70146_Z.nextInt(5) != 0 || EntityUtil.canBlockDamageSource((LivingEntity)entity, DamageSource.func_76358_a((LivingEntity)this))) continue;
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 160, 1));
            }
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_70108_f((Entity)this);
        livingEntity.field_70133_I = true;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        return spawnDataIn;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            EntityUtil.alertOthers((MobEntity)this, new Class[0]);
            if (cause.func_76346_g() instanceof LivingEntity) {
                this.killer = (LivingEntity)cause.func_76346_g();
            }
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 140;
            }
        }
    }

    protected void func_70609_aI() {
        if (this.func_70027_ad()) {
            ++this.vanishTime;
        } else if (this.vanishTime > 0) {
            --this.vanishTime;
        }
        if (++this.field_70725_aQ >= 140) {
            this.field_70725_aQ = 0;
            this.vanishTime = 0;
            if (!this.field_70170_p.field_72995_K) {
                this.setLives(this.getLives() - 1);
                if (this.killer != null) {
                    this.func_70604_c(this.killer);
                    this.killer.func_70604_c((LivingEntity)this);
                }
            }
            this.func_70606_j(Math.round(this.func_110138_aP() / 3.75f));
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.field_70725_aQ > 25) {
            EntityUtil.dropExperience((MobEntity)this, this.field_70718_bc, arg_0 -> ((MutantZombieEntity)this).func_70693_a(arg_0), this.field_70717_bb);
            super.func_70645_a(this.deathCause);
            this.func_70106_y();
        }
    }

    public void func_174812_G() {
        super.func_174812_G();
        this.setLives(0);
    }

    public void func_213295_a(BlockState blockState, Vec3d motionMultiplier) {
        super.func_213295_a(blockState, motionMultiplier.func_186678_a(5.0));
    }

    private boolean canHarm(Entity entity) {
        return !SummonableCapability.isEntityEligible(entity.func_200600_R()) && !(entity instanceof MutantZombieEntity);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Lives", this.getLives());
        compound.func_74777_a("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (ZombieResurrection resurrect : this.resurrectionList) {
                CompoundNBT compound1 = NBTUtil.func_186859_a((BlockPos)resurrect.getPosition());
                compound1.func_74768_a("Tick", resurrect.getTick());
                listnbt.add((Object)compound1);
            }
            compound.func_218657_a("Resurrections", (INBT)listnbt);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Lives")) {
            this.setLives(compound.func_74762_e("Lives"));
        }
        this.vanishTime = compound.func_74765_d("VanishTime");
        ListNBT listNBT = compound.func_150295_c("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compound1 = listNBT.func_150305_b(i);
            this.resurrectionList.add(i, new ZombieResurrection(this.field_70170_p, NBTUtil.func_186861_c((CompoundNBT)compound1), compound1.func_74762_e("Tick")));
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    class ThrowAttackGoal
    extends Goal {
        private int hit = -1;
        private int finish = -1;
        private LivingEntity attackTarget;

        public ThrowAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantZombieEntity.this.func_70638_az();
            return this.attackTarget != null && MutantZombieEntity.this.attackID == 5;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.attackTick = 0;
            MutantZombieEntity.this.field_70699_by.func_75499_g();
            this.attackTarget.func_184210_p();
            double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
            double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
            double d = Math.sqrt(x * x + z * z);
            this.attackTarget.func_213293_j(x / d * (double)0.8f, (double)1.6f, z / d * (double)0.8f);
            this.attackTarget.field_70133_I = true;
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackID == 5 && this.finish < 10;
        }

        public void func_75246_d() {
            MutantZombieEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (MutantZombieEntity.this.attackTick == 15) {
                double d1 = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                double d2 = this.attackTarget.field_70163_u - MutantZombieEntity.this.field_70163_u;
                double x = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                MutantZombieEntity.this.func_213293_j(d1 / z * (double)3.4f, d2 / z * (double)1.4f, x / z * (double)3.4f);
            } else if (MutantZombieEntity.this.attackTick > 15) {
                double d1 = MutantZombieEntity.this.func_213311_cf() * 2.0f * MutantZombieEntity.this.func_213311_cf() * 2.0f;
                double d2 = MutantZombieEntity.this.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
                if (d2 < d1 && this.hit == -1) {
                    this.hit = 0;
                    MutantZombieEntity.this.setThrowAttackHit(true);
                    MutantZombieEntity.this.func_70652_k((Entity)this.attackTarget);
                    double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                    double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                    double d = Math.sqrt(x * x + z * z);
                    this.attackTarget.func_213293_j(x / d * (double)0.6f, (double)-1.2f, z / d * (double)0.6f);
                    this.attackTarget.field_70133_I = true;
                    this.attackTarget.field_70172_ad = 10;
                    EntityUtil.disableShield(this.attackTarget, DamageSource.func_76358_a((LivingEntity)MutantZombieEntity.this), 150);
                    MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT, 0.3f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (this.hit >= 0) {
                    ++this.hit;
                }
                if ((MutantZombieEntity.this.field_70122_E || MutantZombieEntity.this.field_70170_p.func_72953_d(MutantZombieEntity.this.func_174813_aQ())) && this.finish == -1) {
                    this.finish = 0;
                    MutantZombieEntity.this.setThrowAttackFinish(true);
                }
                if (this.finish >= 0) {
                    ++this.finish;
                }
            }
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
            this.hit = -1;
            this.finish = -1;
            MutantZombieEntity.this.setThrowAttackHit(false);
            MutantZombieEntity.this.setThrowAttackFinish(false);
            this.attackTarget = null;
        }
    }

    class RoarGoal
    extends Goal {
        private LivingEntity attackTarget;

        public RoarGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantZombieEntity.this.func_70638_az();
            return this.attackTarget != null && MutantZombieEntity.this.field_70122_E && MutantZombieEntity.this.func_70068_e((Entity)this.attackTarget) > 16.0 ? MutantZombieEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.35f : false;
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackTick < 120;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.setAttackID(6);
            MutantZombieEntity.this.field_70699_by.func_75499_g();
            MutantZombieEntity.this.field_70708_bq = 0;
            MutantZombieEntity.this.field_70757_a = -MutantZombieEntity.this.func_70627_aG();
        }

        public void func_75246_d() {
            if (MutantZombieEntity.this.attackTick < 75) {
                MutantZombieEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (MutantZombieEntity.this.attackTick == 10) {
                MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR, 3.0f, 0.7f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.2f);
                for (LivingEntity livingEntity : MutantZombieEntity.this.field_70170_p.func_217357_a(LivingEntity.class, MutantZombieEntity.this.func_174813_aQ().func_72314_b(12.0, 8.0, 12.0))) {
                    if (!(MutantZombieEntity.this.func_70068_e((Entity)livingEntity) <= 196.0)) continue;
                    if (SummonableCapability.getLazy((Entity)livingEntity).isPresent() && !SummonableCapability.get((Entity)livingEntity).isSpawnedBySummoner() && SummonableCapability.get((Entity)livingEntity).getSummoner() == null) {
                        SummonableCapability.get((Entity)livingEntity).setSummoner((MobEntity)MutantZombieEntity.this);
                        continue;
                    }
                    if (!MutantZombieEntity.this.canHarm((Entity)livingEntity)) continue;
                    double x = livingEntity.field_70165_t - MutantZombieEntity.this.field_70165_t;
                    double z = livingEntity.field_70161_v - MutantZombieEntity.this.field_70161_v;
                    double d = Math.sqrt(x * x + z * z);
                    livingEntity.func_213293_j(x / d * (double)0.7f, (double)0.3f, z / d * (double)0.7f);
                    livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantZombieEntity.this).func_76348_h().func_151518_m(), (float)(2 + MutantZombieEntity.this.field_70146_Z.nextInt(2)));
                }
            }
            if (MutantZombieEntity.this.field_70170_p.field_73011_w.func_76569_d() && MutantZombieEntity.this.attackTick >= 20 && MutantZombieEntity.this.attackTick < 80 && MutantZombieEntity.this.attackTick % 10 == 0) {
                int x = MathHelper.func_76128_c((double)MutantZombieEntity.this.field_70165_t);
                int y = MathHelper.func_76128_c((double)MutantZombieEntity.this.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)MutantZombieEntity.this.field_70161_v);
                y = ZombieResurrection.getSuitableGround(MutantZombieEntity.this.field_70170_p, x += (1 + MutantZombieEntity.this.field_70146_Z.nextInt(8)) * (MutantZombieEntity.this.field_70146_Z.nextBoolean() ? 1 : -1), y - 1, z += (1 + MutantZombieEntity.this.field_70146_Z.nextInt(8)) * (MutantZombieEntity.this.field_70146_Z.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    MutantZombieEntity.this.resurrectionList.add(new ZombieResurrection(MutantZombieEntity.this.field_70170_p, x, y, z));
                }
            }
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
        }
    }

    class SlamGroundGoal
    extends Goal {
        private double dirX = -1.0;
        private double dirZ = -1.0;
        private LivingEntity attackTarget;

        public SlamGroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantZombieEntity.this.func_70638_az();
            return this.attackTarget != null && MutantZombieEntity.this.attackID == 4;
        }

        public boolean func_75253_b() {
            return MutantZombieEntity.this.attackTick < 25;
        }

        public void func_75249_e() {
            MutantZombieEntity.this.attackTick = 0;
            MutantZombieEntity.this.field_70757_a = -MutantZombieEntity.this.func_70627_aG();
            MutantZombieEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK, 0.3f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
        }

        public void func_75246_d() {
            if (MutantZombieEntity.this.attackTick < 8) {
                MutantZombieEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (MutantZombieEntity.this.attackTick == 8) {
                double x = this.attackTarget.field_70165_t - MutantZombieEntity.this.field_70165_t;
                double z = this.attackTarget.field_70161_v - MutantZombieEntity.this.field_70161_v;
                double d = Math.sqrt(x * x + z * z);
                this.dirX = x / d;
                this.dirZ = z / d;
            }
            if (MutantZombieEntity.this.attackTick == 12) {
                int x = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70165_t + this.dirX * 2.0));
                int y = MathHelper.func_76128_c((double)MutantZombieEntity.this.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70161_v + this.dirZ * 2.0));
                int x1 = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70165_t + this.dirX * 8.0));
                int z1 = MathHelper.func_76128_c((double)(MutantZombieEntity.this.field_70161_v + this.dirZ * 8.0));
                SeismicWave.createWaves(MutantZombieEntity.this.field_70170_p, MutantZombieEntity.this.seismicWaveList, x, z, x1, z1, y);
                MutantZombieEntity.this.field_70170_p.func_184148_a(null, (double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, 0.8f + MutantZombieEntity.this.field_70146_Z.nextFloat() * 0.4f);
            }
            MutantZombieEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75251_c() {
            MutantZombieEntity.this.setAttackID(0);
            this.dirX = -1.0;
            this.dirZ = -1.0;
            this.attackTarget = null;
        }
    }
}

