/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import chumbanotz.mutantbeasts.util.MutatedExplosion;
import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CreeperShardItem
extends Item {
    public CreeperShardItem(Item.Properties properties) {
        super(properties.func_200918_c(32));
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || stack.func_77952_i() == 0;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int damage;
        PlayerEntity player = (PlayerEntity)attacker;
        double x = target.field_70165_t - player.field_70165_t;
        double y = target.field_70163_u - player.field_70163_u;
        double z = target.field_70161_v - player.field_70161_v;
        double d = Math.sqrt(x * x + y * y + z * z);
        if (target.field_70172_ad > 10) {
            target.func_213293_j(x / d * (double)0.9f, y / d * (double)0.2f + (double)0.3f, z / d * (double)0.9f);
            player.field_70170_p.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 0.3f, 0.8f + player.func_70681_au().nextFloat() * 0.4f);
        }
        if (!player.func_184812_l_() && player.func_70681_au().nextInt(4) == 0) {
            player.func_195064_c(new EffectInstance(Effects.field_76436_u, 80 + player.func_70681_au().nextInt(40)));
        }
        if ((damage = stack.func_77952_i()) > 0) {
            stack.func_196085_b(damage - 1);
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int maxDmg = stack.func_77958_k();
        int dmg = stack.func_77952_i();
        if (!worldIn.field_72995_K) {
            float damage = 5.0f * (float)(maxDmg - dmg) / 32.0f;
            if (dmg == 0) {
                damage += 2.0f;
            }
            MutatedExplosion.create(worldIn, (Entity)playerIn, playerIn.field_70165_t, playerIn.field_70163_u + 1.0, playerIn.field_70161_v, damage, false, playerIn.func_175142_cm() ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_196085_b(maxDmg);
        }
        playerIn.func_184609_a(handIn);
        playerIn.func_184811_cZ().func_185145_a((Item)this, maxDmg - dmg);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

