/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class HeldBlockPacket {
    private int entityId;
    private short blockId;
    private byte blockIndex;

    public HeldBlockPacket(MutantEndermanEntity enderman, int bId, int index) {
        this.entityId = enderman.func_145782_y();
        this.blockId = (short)bId;
        this.blockIndex = (byte)index;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeShort((int)this.blockId);
        buffer.writeByte((int)this.blockIndex);
    }

    HeldBlockPacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.blockId = buffer.readShort();
        this.blockIndex = buffer.readByte();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> {
                MutantEndermanEntity enderman = (MutantEndermanEntity)world.func_73045_a(this.entityId);
                if (enderman != null && this.blockIndex > 0 && this.blockId != -1) {
                    enderman.heldBlock[this.blockIndex] = this.blockId;
                    enderman.heldBlockTick[this.blockIndex] = 0;
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

