/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.pathfinding;

import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.EndPortalBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SoulSandBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WebBlock;
import net.minecraft.block.WitherRoseBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MBWalkNodeProcessor
extends WalkNodeProcessor {
    protected PathNodeType func_215744_a(IBlockReader blockaccessIn, boolean canOpenDoorsIn, boolean canEnterDoorsIn, BlockPos pos, PathNodeType nodeType) {
        if (nodeType == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoorsIn && canEnterDoorsIn) {
            nodeType = PathNodeType.WALKABLE;
        }
        if (nodeType == PathNodeType.DOOR_OPEN && (!canEnterDoorsIn || this.currentEntity.func_213311_cf() > 0.85f)) {
            nodeType = PathNodeType.BLOCKED;
        }
        if (nodeType == PathNodeType.RAIL && !(blockaccessIn.func_180495_p(pos).func_177230_c() instanceof AbstractRailBlock) && !(blockaccessIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof AbstractRailBlock)) {
            nodeType = PathNodeType.FENCE;
        }
        if (nodeType == PathNodeType.LEAVES) {
            nodeType = PathNodeType.BLOCKED;
        }
        return nodeType;
    }

    public PathNodeType func_193578_a(IBlockReader blockaccessIn, int x, int y, int z, PathNodeType nodeType) {
        if (nodeType == PathNodeType.WALKABLE) {
            try (BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) continue;
                        BlockPos.PooledMutableBlockPos newPos = pos.func_181079_c(i + x, y, j + z);
                        PathNodeType pathNodeType = this.func_189553_b(blockaccessIn, newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                        if (pathNodeType == PathNodeType.DAMAGE_CACTUS) {
                            nodeType = PathNodeType.DANGER_CACTUS;
                            continue;
                        }
                        if (pathNodeType == PathNodeType.DAMAGE_FIRE) {
                            nodeType = PathNodeType.DANGER_FIRE;
                            continue;
                        }
                        if (pathNodeType == PathNodeType.LAVA) {
                            nodeType = PathNodeType.LAVA;
                            continue;
                        }
                        if (pathNodeType != PathNodeType.DANGER_OTHER) continue;
                        nodeType = PathNodeType.DANGER_OTHER;
                    }
                }
            }
        }
        return nodeType;
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        PathNodeType pathNode = this.func_189553_b(blockaccessIn, x, y, z);
        if (pathNode == PathNodeType.OPEN && y >= 1) {
            BlockState blockStateBelow = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z));
            Block blockBelow = blockStateBelow.func_177230_c();
            PathNodeType pathNodeBelow = this.func_189553_b(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathNode = pathNodeBelow != PathNodeType.WALKABLE && pathNodeBelow != PathNodeType.OPEN && pathNodeBelow != PathNodeType.WATER && pathNodeBelow != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathNodeBelow == PathNodeType.DAMAGE_FIRE) {
                pathNode = PathNodeType.DAMAGE_FIRE;
            }
            if (pathNodeBelow == PathNodeType.DAMAGE_CACTUS) {
                pathNode = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathNodeBelow == PathNodeType.DAMAGE_OTHER) {
                pathNode = PathNodeType.DAMAGE_OTHER;
            }
            if (pathNodeBelow == PathNodeType.DANGER_OTHER) {
                pathNode = PathNodeType.DANGER_OTHER;
            }
            if (blockBelow instanceof TrapDoorBlock && ((Boolean)blockStateBelow.func_177229_b((IProperty)TrapDoorBlock.field_176283_b)).booleanValue() || blockBelow instanceof FenceGateBlock && ((Boolean)blockStateBelow.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue()) {
                pathNode = PathNodeType.BLOCKED;
            }
        }
        pathNode = this.func_193578_a(blockaccessIn, x, y, z, pathNode);
        return pathNode;
    }

    protected PathNodeType func_189553_b(IBlockReader blockaccessIn, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockState blockState = blockaccessIn.func_180495_p(blockPos);
        PathNodeType forgeType = blockState.getAiPathNodeType(blockaccessIn, blockPos, this.currentEntity);
        if (forgeType != null) {
            return forgeType;
        }
        Block block = blockState.func_177230_c();
        Material material = blockState.func_185904_a();
        if (blockState.isAir(blockaccessIn, blockPos)) {
            return PathNodeType.OPEN;
        }
        if (!(block instanceof TrapDoorBlock) && !(block instanceof LilyPadBlock)) {
            if (block instanceof FireBlock || block instanceof MagmaBlock || block instanceof CampfireBlock && ((Boolean)blockState.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue()) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block instanceof CactusBlock) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof SweetBerryBushBlock || block instanceof WitherRoseBlock || block instanceof EndPortalBlock || block instanceof NetherPortalBlock) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block instanceof WebBlock || block instanceof AbstractPressurePlateBlock || block instanceof SoulSandBlock) {
                return PathNodeType.DANGER_OTHER;
            }
            if (block instanceof DoorBlock && material == Material.field_151575_d && !((Boolean)blockState.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.field_151573_f && !((Boolean)blockState.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockState.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock || block instanceof AbstractGlassBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(BlockTags.field_219757_z) || block.func_203417_a(BlockTags.field_200032_i) || block instanceof FenceGateBlock && !((Boolean)blockState.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue() || block instanceof EndRodBlock || block instanceof AbstractSkullBlock)) {
                IFluidState ifluidstate = blockaccessIn.func_204610_c(blockPos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return blockState.func_196957_g(blockaccessIn, blockPos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

