/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public final class EntityUtil {
    public static boolean canBlockDamageSource(LivingEntity livingEntity, DamageSource damageSource) {
        Vec3d vec3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSource.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSource.func_76363_c() && livingEntity.func_184585_cz() && !flag && (vec3d2 = damageSource.func_188404_v()) != null) {
            Vec3d vec3d = livingEntity.func_70676_i(1.0f);
            Vec3d vec3d1 = vec3d2.func_72444_a(new Vec3d(livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v)).func_72432_b();
            vec3d1 = new Vec3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            if (vec3d1.func_72430_b(vec3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(livingEntity.field_70170_p, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v);
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            livingEntity.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public static boolean isHolding(LivingEntity livingEntity, Item item) {
        return livingEntity.func_184614_ca().func_77973_b() == item || livingEntity.func_184592_cb().func_77973_b() == item;
    }

    public static void disableShield(LivingEntity livingEntity, DamageSource damageSource, int ticks) {
        if (livingEntity instanceof PlayerEntity && EntityUtil.canBlockDamageSource(livingEntity, damageSource)) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184607_cu().func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
        }
    }

    public static boolean requireDarknessAndSky(EntityType<? extends MonsterEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return spawnReason != SpawnReason.SPAWNER && random.nextInt(50 / Math.min(20, Math.max(1, MBConfig.globalSpawnRate))) == 0 && MonsterEntity.func_223325_c(entityType, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random) && world.func_217337_f(pos);
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof OcelotEntity || livingEntity instanceof CatEntity;
    }

    public static boolean shouldAttackEntity(LivingEntity target, LivingEntity owner, boolean canTargetCreepers) {
        if (owner instanceof PlayerEntity) {
            if (target instanceof CreeperEntity) {
                return canTargetCreepers;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof GolemEntity && !(target instanceof IMob)) {
                return false;
            }
            if (target instanceof TameableEntity && ((TameableEntity)target).func_70902_q() == owner) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return true;
    }

    public static boolean isFacing(LivingEntity livingEntity, double x, double z, float maxDifference) {
        float rot;
        for (rot = (float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f; rot > livingEntity.field_70759_as + 180.0f; rot -= 360.0f) {
        }
        while (rot <= livingEntity.field_70759_as - 180.0f) {
            rot += 360.0f;
        }
        return Math.abs(livingEntity.field_70759_as - rot) < maxDifference;
    }

    public static boolean dropExperience(MobEntity mob, int recentlyHit, Function<PlayerEntity, Integer> experiencePoints, PlayerEntity attackingPlayer) {
        if (!mob.field_70170_p.field_72995_K && recentlyHit > 0 && mob.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            int j;
            for (int i = ForgeEventFactory.getExperienceDrop((LivingEntity)mob, (PlayerEntity)attackingPlayer, (int)experiencePoints.apply(attackingPlayer)); i > 0; i -= j) {
                j = ExperienceOrbEntity.func_70527_a((int)i);
                mob.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, j));
            }
            return true;
        }
        return false;
    }

    public static void onDeath(MobEntity mobEntity, DamageSource damageSource) {
        if (ForgeHooks.onLivingDeath((LivingEntity)mobEntity, (DamageSource)damageSource)) {
            return;
        }
        Entity entity = damageSource.func_76346_g();
        LivingEntity livingentity = mobEntity.func_94060_bK();
        if (livingentity != null) {
            livingentity.func_191956_a((Entity)mobEntity, 0, damageSource);
        }
        if (entity != null) {
            entity.func_70074_a((LivingEntity)mobEntity);
        }
        if (mobEntity.func_70608_bn()) {
            mobEntity.func_213366_dy();
        }
        mobEntity.func_110142_aN().func_94549_h();
        if (!mobEntity.field_70170_p.field_72995_K) {
            boolean flag = false;
            if (livingentity instanceof WitherEntity) {
                if (ForgeEventFactory.getMobGriefingEvent((World)mobEntity.field_70170_p, (Entity)mobEntity)) {
                    BlockPos blockpos = new BlockPos(mobEntity.field_70165_t, mobEntity.field_70163_u, mobEntity.field_70161_v);
                    BlockState blockstate = Blocks.field_222388_bz.func_176223_P();
                    if (mobEntity.field_70170_p.func_180495_p(blockpos).isAir((IBlockReader)mobEntity.field_70170_p, blockpos) && blockstate.func_196955_c((IWorldReader)mobEntity.field_70170_p, blockpos)) {
                        mobEntity.field_70170_p.func_180501_a(blockpos, blockstate, 3);
                        flag = true;
                    }
                }
                if (!flag) {
                    ItemEntity itementity = new ItemEntity(mobEntity.field_70170_p, mobEntity.field_70165_t, mobEntity.field_70163_u, mobEntity.field_70161_v, new ItemStack((IItemProvider)Items.field_221690_bg));
                    mobEntity.field_70170_p.func_217376_c((Entity)itementity);
                }
            }
        }
        mobEntity.field_70170_p.func_72960_a((Entity)mobEntity, (byte)3);
    }

    public static void alertOthers(MobEntity alertingMob, Class<?> ... excludedReinforcementTypes) {
        if (alertingMob.func_175446_cd() || alertingMob.func_70643_av() == null) {
            return;
        }
        double d0 = alertingMob.func_70661_as().func_111269_d();
        for (MobEntity otherMob : alertingMob.field_70170_p.func_217357_a(alertingMob.getClass(), new AxisAlignedBB(alertingMob.field_70165_t, alertingMob.field_70163_u, alertingMob.field_70161_v, alertingMob.field_70165_t + 1.0, alertingMob.field_70163_u + 1.0, alertingMob.field_70161_v + 1.0).func_72314_b(d0, 10.0, d0))) {
            if (otherMob == null || alertingMob == otherMob || alertingMob instanceof TameableEntity && ((TameableEntity)alertingMob).func_70902_q() != ((TameableEntity)otherMob).func_70902_q() || otherMob.func_184191_r((Entity)alertingMob.func_70643_av())) continue;
            boolean flag = false;
            for (Class<?> oclass : excludedReinforcementTypes) {
                if (otherMob.getClass() != oclass) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            otherMob.func_70604_c(alertingMob.func_70643_av());
        }
    }

    public static void copyNBT(Entity oldEntity, Entity newEntity, boolean resetHealth) {
        if (oldEntity == newEntity) {
            throw new IllegalArgumentException("Old entity is the same as the new entity");
        }
        CompoundNBT copiedNBT = oldEntity.func_189511_e(new CompoundNBT());
        copiedNBT.func_186854_a("UUID", newEntity.func_110124_au());
        if (oldEntity instanceof LivingEntity && newEntity instanceof LivingEntity) {
            LivingEntity newLiving = (LivingEntity)newEntity;
            if (resetHealth) {
                copiedNBT.func_218657_a("Attributes", (INBT)SharedMonsterAttributes.func_111257_a((AbstractAttributeMap)newLiving.func_110140_aT()));
                copiedNBT.func_74776_a("Health", newLiving.func_110143_aJ());
            }
            if (copiedNBT.func_150297_b("ActiveEffects", 9)) {
                ListNBT listnbt = copiedNBT.func_150295_c("ActiveEffects", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                    EffectInstance effectinstance = EffectInstance.func_82722_b((CompoundNBT)compoundnbt);
                    if (newLiving.func_70687_e(effectinstance)) continue;
                    listnbt.remove(i);
                }
            }
        }
        copiedNBT.func_74778_a("id", newEntity.func_70022_Q());
        newEntity.deserializeNBT(copiedNBT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticlesAtEntity(Entity entity, IParticleData particleData, int amount) {
        for (int i = 0; i < amount; ++i) {
            double posX = entity.field_70165_t + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            double posY = entity.field_70163_u + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213302_cg());
            double posZ = entity.field_70161_v + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            double x = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double y = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double z = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            entity.field_70170_p.func_195594_a(particleData, posX, posY, posZ, x, y, z);
        }
    }

    public static void spawnLargePortalParticles(Entity entity, int amount, float speed, boolean serverSide) {
        if (!serverSide || entity.field_70170_p instanceof ServerWorld) {
            for (int i = 0; i < amount; ++i) {
                float f = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
                float f1 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
                float f2 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
                double tempX = entity.field_70165_t + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
                double tempY = entity.field_70163_u + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213302_cg()) + 0.5;
                double tempZ = entity.field_70161_v + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
                if (serverSide) {
                    ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)MBParticleTypes.LARGE_PORTAL, tempX, tempY, tempZ, 0, (double)f, (double)f1, (double)f2, 1.0);
                    continue;
                }
                entity.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.LARGE_PORTAL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
            }
        }
    }

    public static Vec3d getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vec3d((double)(-MathHelper.func_76126_a((float)rad) * scale), 0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(MobEntity mob, double x, double y, double z) {
        double oldX = mob.field_70165_t;
        double oldY = mob.field_70163_u;
        double oldZ = mob.field_70161_v;
        int teleX = MathHelper.func_76128_c((double)x);
        int teleY = MathHelper.func_76128_c((double)y);
        int teleZ = MathHelper.func_76128_c((double)z);
        boolean success = false;
        if (mob.field_70170_p.func_195588_v(new BlockPos(teleX, teleY, teleZ))) {
            boolean temp = false;
            while (!temp && teleY > 0) {
                Block block = mob.field_70170_p.func_180495_p(new BlockPos(teleX, teleY - 1, teleZ)).func_177230_c();
                if (block != Blocks.field_150350_a && mob.field_70170_p.func_180495_p(new BlockPos(teleX, teleY - 1, teleZ)).func_185904_a().func_76230_c()) {
                    temp = true;
                    continue;
                }
                --teleY;
            }
            if (temp) {
                mob.func_70107_b(x, (double)teleY, z);
                if (mob.field_70170_p.func_195586_b((Entity)mob, mob.func_174813_aQ()) && !mob.field_70170_p.func_72953_d(mob.func_174813_aQ())) {
                    success = true;
                }
            }
        }
        if (!success) {
            mob.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        mob.func_70661_as().func_75499_g();
        return true;
    }

    public static void divertAttackers(MobEntity targetedMob, LivingEntity newTarget) {
        if (targetedMob == newTarget) {
            return;
        }
        for (LivingEntity attacker : targetedMob.field_70170_p.func_175647_a(LivingEntity.class, targetedMob.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0), e -> e != targetedMob && e.func_190631_cK())) {
            if (attacker.func_70643_av() == targetedMob) {
                attacker.func_70604_c(newTarget);
            }
            if (attacker.func_110144_aD() == targetedMob) {
                attacker.func_130011_c((Entity)newTarget);
            }
            if (!(attacker instanceof MobEntity) || ((MobEntity)attacker).func_70638_az() != targetedMob) continue;
            ((MobEntity)attacker).func_70624_b(newTarget);
        }
    }
}

