/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts;

import chumbanotz.mutantbeasts.MBConfig;
import chumbanotz.mutantbeasts.capability.ISummonable;
import chumbanotz.mutantbeasts.capability.SummonableCapability;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.item.ChemicalXItem;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.packet.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mutantbeasts")
public class MutantBeasts {
    public static final String MOD_ID = "mutantbeasts";
    public static final Logger LOGGER = LogManager.getLogger((String)"mutantbeasts");
    public static final Tag<Block> THROWABLE_BLOCKS = new BlockTags.Wrapper(MutantBeasts.prefix("throwable_blocks"));
    public static final ItemGroup ITEM_GROUP = new ItemGroup("mutantbeasts"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)MBItems.CHEMICAL_X);
        }
    };

    public MutantBeasts() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onFingerprintViolation);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MBConfig.COMMON_SPEC);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ChemicalXItem.BrewingRecipe());
        CapabilityManager.INSTANCE.register(ISummonable.class, (Capability.IStorage)new SummonableCapability.Storage(), SummonableCapability::new);
        DeferredWorkQueue.runLater(MBEntityType::addSpawns);
        DeferredWorkQueue.runLater(MBEntityType::registerDispenseBehavior);
    }

    private void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    public static String namespace(String path) {
        return "mutantbeasts:" + path;
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static ResourceLocation getEntityTexture(String name) {
        return MutantBeasts.prefix("textures/entity/" + name + ".png");
    }
}

