/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.capability;

import chumbanotz.mutantbeasts.capability.ISummonable;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SummonableCapability
implements ISummonable {
    private UUID summonerUUID;
    private boolean spawnedBySummoner;

    @Override
    @Nullable
    public UUID getSummonerUUID() {
        return this.summonerUUID;
    }

    @Override
    public void setSummonerUUID(@Nullable UUID summonerUUID) {
        this.summonerUUID = summonerUUID;
    }

    @Override
    public boolean isSpawnedBySummoner() {
        return this.spawnedBySummoner;
    }

    @Override
    public void setSpawnedBySummoner(boolean spawnedBySummoner) {
        this.spawnedBySummoner = spawnedBySummoner;
    }

    public static LazyOptional<ISummonable> getLazy(Entity entity) {
        return entity.getCapability(Provider.SUMMONABLE);
    }

    public static ISummonable get(Entity entity) {
        return (ISummonable)SummonableCapability.getLazy(entity).orElseThrow(() -> new IllegalStateException("Invalid LazyOptional for capability, must not be empty"));
    }

    public static boolean isEntityEligible(EntityType<?> type) {
        return type == EntityType.field_200725_aD || type == EntityType.field_200763_C || type == EntityType.field_200727_aF || type == EntityType.field_204724_o;
    }

    public static class Storage
    implements Capability.IStorage<ISummonable> {
        public INBT writeNBT(Capability<ISummonable> capability, ISummonable instance, Direction side) {
            CompoundNBT tag = new CompoundNBT();
            UUID uuid = instance.getSummonerUUID();
            if (uuid != null) {
                tag.func_186854_a("SummonerUUID", uuid);
            }
            tag.func_74757_a("SpawnedBySummoner", instance.isSpawnedBySummoner());
            return tag;
        }

        public void readNBT(Capability<ISummonable> capability, ISummonable instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                CompoundNBT tag = (CompoundNBT)nbt;
                instance.setSummonerUUID(tag.func_186857_a("SummonerUUID"));
                instance.setSpawnedBySummoner(tag.func_74767_n("SpawnedBySummoner"));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        @CapabilityInject(value=ISummonable.class)
        public static final Capability<ISummonable> SUMMONABLE = null;
        private final LazyOptional<ISummonable> holder = LazyOptional.of(() -> SUMMONABLE.getDefaultInstance());

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return SUMMONABLE.orEmpty(cap, this.holder);
        }

        public INBT serializeNBT() {
            return SUMMONABLE.getStorage().writeNBT(SUMMONABLE, this.holder.orElseThrow(() -> new IllegalStateException("Invalid LazyOptional for capability, must not be empty")), null);
        }

        public void deserializeNBT(INBT nbt) {
            SUMMONABLE.getStorage().readNBT(SUMMONABLE, this.holder.orElseThrow(() -> new IllegalStateException("Invalid LazyOptional for capability, must not be empty")), null, nbt);
        }
    }
}

