/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkullSpiritParticle
extends SpriteTexturedParticle {
    private float particleScale;
    private float skullScale;

    private SkullSpiritParticle(World world, double x, double y, double z, double xx, double yy, double zz) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.particleScale = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.field_187129_i *= (double)0.1f;
        this.field_187130_j *= (double)0.1f;
        this.field_187131_k *= (double)0.1f;
        this.field_187129_i += xx;
        this.field_187130_j += yy;
        this.field_187131_k += zz;
        this.field_70553_i = this.field_70551_j = 1.0f - (float)(Math.random() * 0.2);
        this.field_70552_h = this.field_70551_j;
        this.particleScale *= 1.0f;
        float scale = 0.4f + this.field_187136_p.nextFloat() * 0.6f;
        this.particleScale *= scale;
        this.skullScale = this.particleScale;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.field_70547_e = (int)((float)this.field_70547_e * scale);
        this.field_190017_n = false;
    }

    public float func_217561_b(float partialTicks) {
        return 0.1f * this.particleScale;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        float timeScale = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e * 32.0f;
        if (timeScale < 0.0f) {
            timeScale = 0.0f;
        }
        if (timeScale > 1.0f) {
            timeScale = 1.0f;
        }
        this.particleScale = this.skullScale * timeScale;
        super.func_225606_a_(buffer, renderInfo, partialTicks);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j += 0.002;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SkullSpiritParticle skullSpiritParticle = new SkullSpiritParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            skullSpiritParticle.func_217568_a(this.spriteSet);
            return skullSpiritParticle;
        }
    }
}

