/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.layers.CreeperChargeLayer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.CreeperMinionModel;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperMinionRenderer
extends MobRenderer<CreeperMinionEntity, CreeperMinionModel> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/creeper/creeper.png");
    public static final ResourceLocation COLLAR_TEXTURE = MutantBeasts.getEntityTexture("creeper_minion_collar");

    public CreeperMinionRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new CreeperMinionModel(), 0.5f);
        this.func_177094_a(new CreeperChargeLayer<CreeperMinionEntity, CreeperMinionModel>((IEntityRenderer<CreeperMinionEntity, CreeperMinionModel>)this, new CreeperMinionModel(2.0f), CreeperMinionEntity::isCharged));
        this.func_177094_a(new CollarLayer((IEntityRenderer<CreeperMinionEntity, CreeperMinionModel>)this));
    }

    protected void preRenderCallback(CreeperMinionEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1 * 0.5f;
        float f3 = (1.0f + f * 0.1f) / f1 * 0.5f;
        matrixStackIn.func_227862_a_(f2, f3, f2);
        matrixStackIn.func_227861_a_(0.0, entitylivingbaseIn.func_70906_o() ? -0.02 : 0.1, 0.0);
    }

    protected float getOverlayProgress(CreeperMinionEntity livingEntityIn, float partialTicks) {
        float f = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(CreeperMinionEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CollarLayer
    extends LayerRenderer<CreeperMinionEntity, CreeperMinionModel> {
        private final CreeperMinionModel creeperMinionModel = new CreeperMinionModel(0.01f);

        public CollarLayer(IEntityRenderer<CreeperMinionEntity, CreeperMinionModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, CreeperMinionEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.getCollarColor() != null) {
                float[] afloat = livingEntity.getCollarColor().func_193349_f();
                CollarLayer.func_229140_a_((EntityModel)this.func_215332_c(), (EntityModel)this.creeperMinionModel, (ResourceLocation)COLLAR_TEXTURE, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)livingEntity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)afloat[0], (float)afloat[1], (float)afloat[2]);
            }
        }
    }
}

