/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.MBRenderType;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantEndermanModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EndermanModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class MutantEndermanRenderer
extends MutantRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/mutant_enderman");
    private static final ResourceLocation GLOW_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/glow");
    private static final ResourceLocation DEATH_TEXTURE = MutantBeasts.getEntityTexture("mutant_enderman/death");
    private static final RenderType EYES_RENDER_TYPE = MBRenderType.getEyes(MutantBeasts.getEntityTexture("mutant_enderman/eyes"));
    private static final RenderType DEATH_RENDER_TYPE = RenderType.func_228648_g_((ResourceLocation)TEXTURE);
    private final MutantEndermanModel endermanModel;
    private final EndermanModel<MutantEndermanEntity> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(EntityRendererManager manager) {
        super(manager, new MutantEndermanModel(), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_77045_g;
        this.cloneModel = new EndermanModel(0.0f);
        this.func_177094_a((LayerRenderer)new EyesLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new GlowLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
        this.func_177094_a(new HeldBlocksLayer((IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>>)this));
    }

    public void render(MutantEndermanEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_76989_e = entityIn.isClone() ? 0.5f : 0.8f;
        this.field_76987_f = entityIn.isClone() ? 0.5f : 1.0f - ((float)entityIn.field_70725_aQ + partialTicks) / 280.0f * 0.95f;
        this.teleportAttack = false;
        this.field_77045_g = entityIn.isClone() ? this.cloneModel : this.endermanModel;
        this.cloneModel.field_78125_b = entityIn.func_213398_dR();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.getAttackID() == 7) {
            this.teleportAttack = true;
            matrixStackIn.func_227860_a_();
            BlockPos pos = entityIn.getTeleportPosition();
            matrixStackIn.func_227861_a_((double)pos.func_177958_n() + 0.5 - entityIn.field_70169_q, (double)pos.func_177956_o() - entityIn.field_70167_r, (double)pos.func_177952_p() + 0.5 - entityIn.field_70166_s);
            super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    @Override
    protected void renderModel(MutantEndermanEntity mutant, float partialTicks, RenderType renderType, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean visibleToSpectator) {
        if (mutant.field_70725_aQ > 80) {
            float alpha = (float)(mutant.field_70725_aQ - 80) / 200.0f;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228635_a_((ResourceLocation)DEATH_TEXTURE, (float)alpha));
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(DEATH_RENDER_TYPE);
            this.field_77045_g.func_225598_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            super.renderModel(mutant, partialTicks, renderType, matrixStackIn, bufferIn, packedLightIn, visibleToSpectator);
        }
    }

    public Vec3d getRenderOffset(MutantEndermanEntity entityIn, float partialTicks) {
        boolean death;
        boolean stare = entityIn.getAttackID() == 6;
        boolean scream = entityIn.getAttackID() == 8;
        boolean clone = entityIn.isClone() && entityIn.func_213398_dR();
        boolean telesmash = entityIn.getAttackID() == 10 && entityIn.getAttackTick() < 18;
        boolean bl = death = entityIn.getAttackID() == 11;
        if (stare || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (clone) {
                shake = 0.02;
            } else if (death) {
                shake = entityIn.getAttackTick() < 80 ? (double)0.02f : (double)0.05f;
            } else if (entityIn.getAttackTick() >= 40) {
                shake *= 0.5;
            }
            return new Vec3d(entityIn.func_70681_au().nextGaussian() * shake, 0.0, entityIn.func_70681_au().nextGaussian() * shake);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    protected float getDeathMaxRotation(MutantEndermanEntity livingEntity) {
        return 0.0f;
    }

    protected RenderType func_230042_a_(MutantEndermanEntity livingEntity, boolean visible, boolean visibleToSpectator) {
        return livingEntity.isClone() ? null : super.func_230042_a_((LivingEntity)livingEntity, visible, visibleToSpectator);
    }

    public ResourceLocation getEntityTexture(MutantEndermanEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class HeldBlocksLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public HeldBlocksLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.isClone()) {
                return;
            }
            for (int i = 1; i < livingEntity.heldBlock.length; ++i) {
                if (livingEntity.heldBlock[i] == 0) continue;
                matrixStackIn.func_227860_a_();
                ((MutantEndermanModel)this.func_215332_c()).translateRotate(matrixStackIn, i);
                matrixStackIn.func_227861_a_(0.0, 1.2, 0.0);
                float tick = (float)livingEntity.field_70173_aa + (float)i * 2.0f * (float)Math.PI + partialTicks;
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(tick * 10.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tick * 8.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(tick * 6.0f));
                matrixStackIn.func_227862_a_(-0.75f, -0.75f, 0.75f);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                matrixStackIn.func_227861_a_(-0.5, -0.5, 0.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(Block.func_196257_b((int)livingEntity.heldBlock[i]), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class GlowLayer
    extends LayerRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public GlowLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = entityIn.getAttackID() == 7 && entityIn.getAttackTick() < 10;
            boolean scream = entityIn.getAttackID() == 8;
            boolean clone = entityIn.isClone();
            if (teleport || scream || clone) {
                float f = (float)entityIn.field_70173_aa + partialTicks;
                this.func_215332_c().func_212843_a_((Entity)entityIn, limbSwing, limbSwingAmount, partialTicks);
                this.func_215332_c().func_225597_a_((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(MBRenderType.getEnergySwirl(GLOW_TEXTURE, f * 0.008f, f * 0.01f));
                float red = 0.9f;
                float green = 0.3f;
                float blue = 1.0f;
                float alpha = 1.0f;
                float scale = 2.0f;
                if (entityIn.func_96124_cp() != null && entityIn.func_96124_cp().func_178775_l().func_211163_e() != null) {
                    Integer integer = entityIn.func_96124_cp().func_178775_l().func_211163_e();
                    red = (float)(integer >> 16 & 0xFF) / 255.0f;
                    green = (float)(integer >> 8 & 0xFF) / 255.0f;
                    blue = (float)(integer & 0xFF) / 255.0f;
                }
                if (teleport) {
                    if (!MutantEndermanRenderer.this.teleportAttack && entityIn.getAttackTick() >= 8) {
                        alpha -= ((float)(entityIn.getAttackTick() - 8) + partialTicks) / 2.0f;
                    }
                    if (MutantEndermanRenderer.this.teleportAttack && entityIn.getAttackTick() < 2) {
                        alpha = ((float)entityIn.getAttackTick() + partialTicks) / 2.0f;
                    }
                    scale = 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f;
                    }
                }
                if (scream) {
                    if (entityIn.getAttackTick() < 40) {
                        alpha = ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    } else if (entityIn.getAttackTick() >= 160) {
                        alpha = 1.0f - ((float)entityIn.getAttackTick() + partialTicks) / 40.0f;
                    }
                    scale = entityIn.getAttackTick() < 40 ? 1.2f + ((float)entityIn.getAttackTick() + partialTicks) / 40.0f : (entityIn.getAttackTick() < 160 ? 2.2f : 2.2f - ((float)entityIn.getAttackTick() + partialTicks) / 10.0f);
                }
                if (clone) {
                    this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                } else {
                    matrixStackIn.func_227860_a_();
                    matrixStackIn.func_227862_a_(scale, scale * 0.8f, scale);
                    this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                    matrixStackIn.func_227865_b_();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class EyesLayer
    extends AbstractEyesLayer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> {
        public EyesLayer(IEntityRenderer<MutantEndermanEntity, EntityModel<MutantEndermanEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantEndermanEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.isClone()) {
                super.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }

        public RenderType func_225636_a_() {
            return EYES_RENDER_TYPE;
        }
    }
}

