/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.MutantRenderer;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantZombieModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantZombieRenderer
extends MutantRenderer<MutantZombieEntity, MutantZombieModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_zombie");

    public MutantZombieRenderer(EntityRendererManager manager) {
        super(manager, new MutantZombieModel(), 1.0f);
    }

    protected void preRenderCallback(MutantZombieEntity livingEntity, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
    }

    protected void applyRotations(MutantZombieEntity livingEntity, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (livingEntity.field_70725_aQ > 0) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
            int pitch = Math.min(20, livingEntity.field_70725_aQ);
            boolean reviving = false;
            if (livingEntity.field_70725_aQ > 100) {
                pitch = 140 - livingEntity.field_70725_aQ;
                reviving = true;
            }
            if (pitch > 0) {
                float f = ((float)pitch + partialTicks - 1.0f) / 20.0f * 1.6f;
                if (reviving) {
                    f = ((float)pitch - partialTicks) / 40.0f * 1.6f;
                }
                if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                matrixStackIn.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(f * this.getDeathMaxRotation(livingEntity)));
            }
        } else {
            super.func_225621_a_((LivingEntity)livingEntity, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        }
    }

    protected float getDeathMaxRotation(MutantZombieEntity livingEntity) {
        return 80.0f;
    }

    @Override
    protected float getTransparency(MutantZombieEntity mutant, float partialTicks) {
        return 1.0f - ((float)mutant.vanishTime + partialTicks) / 140.0f * 0.6f;
    }

    protected RenderType func_230042_a_(MutantZombieEntity livingEntity, boolean visible, boolean visibleToSpectator) {
        return super.func_230042_a_((LivingEntity)livingEntity, visible, visibleToSpectator |= livingEntity.vanishTime > 0);
    }

    public ResourceLocation getEntityTexture(MutantZombieEntity entity) {
        return TEXTURE;
    }
}

