/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.entity.model.SpiderPigModel;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpiderPigRenderer
extends MobRenderer<SpiderPigEntity, SpiderPigModel> {
    private static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("spider_pig/spider_pig");
    private static final ResourceLocation SADDLE_TEXTURE = MutantBeasts.getEntityTexture("spider_pig/saddle");

    public SpiderPigRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new SpiderPigModel(0.0f), 0.8f);
        this.func_177094_a(new SaddleLayer((IEntityRenderer<SpiderPigEntity, SpiderPigModel>)this));
    }

    protected float getDeathMaxRotation(SpiderPigEntity entityLivingBaseIn) {
        return 180.0f;
    }

    protected void preRenderCallback(SpiderPigEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(1.2f, 1.2f, 1.2f);
    }

    public ResourceLocation getEntityTexture(SpiderPigEntity entity) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SaddleLayer
    extends LayerRenderer<SpiderPigEntity, SpiderPigModel> {
        private final SpiderPigModel saddleModel = new SpiderPigModel(-0.6f);

        public SaddleLayer(IEntityRenderer<SpiderPigEntity, SpiderPigModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, SpiderPigEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.isSaddled()) {
                ((SpiderPigModel)this.func_215332_c()).func_217111_a((EntityModel)this.saddleModel);
                this.saddleModel.func_212843_a_((Entity)livingEntity, limbSwing, limbSwingAmount, partialTicks);
                this.saddleModel.setRotationAngles(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)SADDLE_TEXTURE));
                this.saddleModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

