/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreeperMinionModel
extends SegmentedModel<CreeperMinionEntity> {
    private final ModelRenderer head = new ModelRenderer((Model)this, 0, 0);
    private final ModelRenderer body;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer leg3;
    private final ModelRenderer leg4;

    public CreeperMinionModel() {
        this(0.0f);
    }

    public CreeperMinionModel(float scale) {
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, scale);
        this.head.func_78793_a(0.0f, 6.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 16, 16);
        this.body.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, scale);
        this.body.func_78793_a(0.0f, 6.0f, 0.0f);
        this.leg1 = new ModelRenderer((Model)this, 0, 16);
        this.leg1.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, scale);
        this.leg1.func_78793_a(-2.0f, 18.0f, 4.0f);
        this.leg2 = new ModelRenderer((Model)this, 0, 16);
        this.leg2.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, scale);
        this.leg2.func_78793_a(2.0f, 18.0f, 4.0f);
        this.leg3 = new ModelRenderer((Model)this, 0, 16);
        this.leg3.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, scale);
        this.leg3.func_78793_a(-2.0f, 18.0f, -4.0f);
        this.leg4 = new ModelRenderer((Model)this, 0, 16);
        this.leg4.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, scale);
        this.leg4.func_78793_a(2.0f, 18.0f, -4.0f);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.leg4);
    }

    public void setRotationAngles(CreeperMinionEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.head.field_78797_d = 4.0f;
        this.body.field_78797_d = 4.0f;
        this.leg1.func_78793_a(-2.0f, 16.0f, 4.0f);
        this.leg2.func_78793_a(2.0f, 16.0f, 4.0f);
        this.leg3.func_78793_a(-2.0f, 16.0f, -4.0f);
        this.leg4.func_78793_a(2.0f, 16.0f, -4.0f);
        if (entity == null || entity.func_70906_o()) {
            this.head.field_78797_d += 8.0f;
            this.body.field_78797_d += 8.0f;
            this.leg1.field_78797_d += 6.0f;
            this.leg1.field_78798_e -= 2.0f;
            this.leg2.field_78797_d += 6.0f;
            this.leg2.field_78798_e -= 2.0f;
            this.leg3.field_78797_d += 6.0f;
            this.leg3.field_78798_e += 2.0f;
            this.leg4.field_78797_d += 6.0f;
            this.leg4.field_78798_e += 2.0f;
            this.leg1.field_78795_f = 1.5707964f;
            this.leg2.field_78795_f = 1.5707964f;
            this.leg3.field_78795_f = -1.5707964f;
            this.leg4.field_78795_f = -1.5707964f;
        }
    }
}

