/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import chumbanotz.mutantbeasts.client.animationapi.Animator;
import chumbanotz.mutantbeasts.client.renderer.entity.model.CrossbowModel;
import chumbanotz.mutantbeasts.client.renderer.model.JointModelRenderer;
import chumbanotz.mutantbeasts.client.renderer.model.ModelUtil;
import chumbanotz.mutantbeasts.client.renderer.model.ScalableModelRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantSkeletonModel
extends SegmentedModel<MutantSkeletonEntity> {
    private final List<ModelRenderer> modelRenderers = new ArrayList<ModelRenderer>();
    protected final ModelRenderer skeleBase;
    protected final ModelRenderer pelvis;
    protected final ModelRenderer waist;
    protected final Spine[] spine;
    protected final ModelRenderer neck;
    protected final JointModelRenderer head;
    protected final ModelRenderer jaw;
    protected final ModelRenderer shoulder1;
    protected final ModelRenderer shoulder2;
    protected final JointModelRenderer arm1;
    protected final JointModelRenderer arm2;
    protected final JointModelRenderer forearm1;
    protected final JointModelRenderer forearm2;
    protected final JointModelRenderer leg1;
    protected final JointModelRenderer leg2;
    protected final JointModelRenderer foreleg1;
    protected final JointModelRenderer foreleg2;
    protected final CrossbowModel crossbow;
    protected final Animator animator = new Animator();
    protected float partialTick;

    public MutantSkeletonModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.skeleBase = new ModelRenderer((Model)this);
        this.skeleBase.func_78793_a(0.0f, 3.0f, 0.0f);
        this.pelvis = new ModelRenderer((Model)this, 0, 16);
        this.pelvis.func_228300_a_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f);
        this.skeleBase.func_78792_a(this.pelvis);
        this.waist = new ModelRenderer((Model)this, 32, 0);
        this.waist.func_228300_a_(-2.5f, -8.0f, -2.0f, 5.0f, 8.0f, 4.0f);
        this.waist.func_78793_a(0.0f, -5.0f, 0.0f);
        this.pelvis.func_78792_a(this.waist);
        this.spine = new Spine[3];
        this.spine[0] = new Spine((Model)this);
        this.spine[0].middle.func_78793_a(0.0f, -7.0f, 0.0f);
        this.waist.func_78792_a(this.spine[0].middle);
        for (int i = 1; i < this.spine.length; ++i) {
            this.spine[i] = new Spine((Model)this);
            this.spine[i].middle.func_78793_a(0.0f, -5.0f, 0.0f);
            this.spine[i - 1].middle.func_78792_a(this.spine[i].middle);
        }
        this.neck = new ModelRenderer((Model)this, 64, 0);
        this.neck.func_228300_a_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f);
        this.neck.func_78793_a(0.0f, -4.0f, 0.0f);
        this.spine[2].middle.func_78792_a(this.neck);
        this.head = new JointModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.4f);
        this.head.func_78793_a(0.0f, -4.0f, -1.0f);
        this.neck.func_78792_a((ModelRenderer)this.head);
        this.jaw = new ModelRenderer((Model)this, 72, 0);
        this.jaw.func_228301_a_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.7f);
        this.jaw.func_78793_a(0.0f, -0.2f, 3.5f);
        this.head.func_78792_a(this.jaw);
        this.shoulder1 = new ModelRenderer((Model)this, 28, 16);
        this.shoulder1.func_228300_a_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f);
        this.shoulder1.func_78793_a(-7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder1);
        this.shoulder2 = new ModelRenderer((Model)this, 28, 16);
        this.shoulder2.field_78809_i = true;
        this.shoulder2.func_228300_a_(-4.0f, -3.0f, -3.0f, 8.0f, 3.0f, 6.0f);
        this.shoulder2.func_78793_a(7.0f, -3.0f, -1.0f);
        this.spine[2].middle.func_78792_a(this.shoulder2);
        this.arm1 = new JointModelRenderer((Model)this, 0, 28);
        this.arm1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.arm1.func_78793_a(-1.0f, -1.0f, 0.0f);
        this.shoulder1.func_78792_a((ModelRenderer)this.arm1);
        this.arm2 = new JointModelRenderer((Model)this, 0, 28);
        this.arm2.field_78809_i = true;
        this.arm2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.arm2.func_78793_a(1.0f, -1.0f, 0.0f);
        this.shoulder2.func_78792_a((ModelRenderer)this.arm2);
        this.forearm1 = new JointModelRenderer((Model)this, 16, 28);
        this.forearm1.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, -0.01f);
        this.forearm1.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm1.func_78792_a(this.forearm1);
        this.forearm2 = new JointModelRenderer((Model)this, 16, 28);
        this.forearm2.field_78809_i = true;
        this.forearm2.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, -0.01f);
        this.forearm2.func_78793_a(0.0f, 11.0f, 0.0f);
        this.arm2.func_78792_a(this.forearm2);
        this.leg1 = new JointModelRenderer((Model)this, 0, 28);
        this.leg1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.leg1.func_78793_a(-2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg1);
        this.leg2 = new JointModelRenderer((Model)this, 0, 28);
        this.leg2.field_78809_i = true;
        this.leg2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.leg2.func_78793_a(2.5f, -2.5f, 0.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg2);
        this.foreleg1 = new JointModelRenderer((Model)this, 32, 28);
        this.foreleg1.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.foreleg1.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.foreleg2 = new JointModelRenderer((Model)this, 32, 28);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        this.foreleg2.func_78793_a(0.0f, 12.0f, 0.0f);
        this.leg2.func_78792_a(this.foreleg2);
        this.crossbow = new CrossbowModel((Model)this);
        this.crossbow.armwear.func_78793_a(0.0f, 8.0f, 0.0f);
        this.forearm1.func_78792_a(this.crossbow.armwear);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.skeleBase);
    }

    public void setRotationAngles(MutantSkeletonEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animator.update(entityIn);
        for (ModelRenderer modelRenderer : this.modelRenderers) {
            modelRenderer.field_78795_f = 0.0f;
            modelRenderer.field_78796_g = 0.0f;
            modelRenderer.field_78808_h = 0.0f;
        }
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void accept(ModelRenderer modelRenderer) {
        this.modelRenderers.add(modelRenderer);
    }

    protected void setAngles() {
        this.skeleBase.field_78797_d = 3.0f;
        this.pelvis.field_78795_f = -0.31415927f;
        this.waist.field_78795_f = 0.22439948f;
        for (int i = 0; i < this.spine.length; ++i) {
            this.spine[i].setAngles((float)Math.PI, i == 1);
        }
        this.neck.field_78795_f = -0.1308997f;
        this.head.field_78795_f = -0.1308997f;
        this.jaw.field_78795_f = 0.09817477f;
        this.shoulder1.field_78795_f = -0.7853982f;
        this.shoulder2.field_78795_f = -0.7853982f;
        this.arm1.getJoint().field_78795_f = 0.5235988f;
        this.arm1.getJoint().field_78808_h = 0.31415927f;
        this.arm2.getJoint().field_78795_f = 0.5235988f;
        this.arm2.getJoint().field_78808_h = -0.31415927f;
        this.forearm1.getJoint().field_78795_f = -0.5235988f;
        this.forearm2.getJoint().field_78795_f = -0.5235988f;
        this.leg1.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg1.field_78808_h = 0.19634955f;
        this.leg2.field_78795_f = -0.2617994f - this.pelvis.field_78795_f;
        this.leg2.field_78808_h = -0.19634955f;
        this.foreleg1.field_78808_h = -0.1308997f;
        this.foreleg1.getJoint().field_78795_f = 0.31415927f;
        this.foreleg2.field_78808_h = 0.1308997f;
        this.foreleg2.getJoint().field_78795_f = 0.31415927f;
        this.crossbow.setAngles((float)Math.PI);
    }

    protected void animate(MutantSkeletonEntity skele, float f, float f1, float f2, float f3, float f4) {
        float scale;
        float walkAnim1 = MathHelper.func_76126_a((float)(f * 0.5f));
        float walkAnim2 = MathHelper.func_76126_a((float)(f * 0.5f - 1.1f));
        float breatheAnim = MathHelper.func_76126_a((float)(f2 * 0.1f));
        float faceYaw = f3 * (float)Math.PI / 180.0f;
        float facePitch = f4 * (float)Math.PI / 180.0f;
        if (skele.getAnimationID() == 4) {
            this.animateMelee(skele.getAnimationTick());
            this.crossbow.rotateRope();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
        } else if (skele.getAnimationID() == 5) {
            this.animateShoot(skele.getAnimationTick(), facePitch, faceYaw);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (skele.getAnimationID() == 6) {
            this.animateMultiShoot(skele.getAnimationTick(), facePitch, faceYaw);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnimation(7)) {
            this.animateConstrict();
            this.crossbow.rotateRope();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)skele.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else {
            this.crossbow.rotateRope();
        }
        this.skeleBase.field_78797_d -= (-0.5f + Math.abs(walkAnim1)) * f1;
        this.spine[0].middle.field_78796_g -= walkAnim1 * 0.06f * f1;
        this.arm1.field_78795_f -= walkAnim1 * 0.9f * f1;
        this.arm2.field_78795_f += walkAnim1 * 0.9f * f1;
        this.leg1.field_78795_f += (0.2f + walkAnim1) * 1.0f * f1;
        this.leg2.field_78795_f -= (-0.2f + walkAnim1) * 1.0f * f1;
        this.foreleg1.getJoint().field_78795_f += (0.6f + walkAnim2) * 0.6f * f1;
        this.foreleg2.getJoint().field_78795_f -= (-0.6f + walkAnim2) * 0.6f * f1;
        for (Spine spine : this.spine) {
            spine.animate(breatheAnim);
        }
        this.head.field_78795_f -= breatheAnim * 0.02f;
        this.jaw.field_78795_f += breatheAnim * 0.04f + 0.04f;
        this.arm1.field_78808_h += breatheAnim * 0.025f;
        this.arm2.field_78808_h -= breatheAnim * 0.025f;
        this.head.getJoint().field_78795_f += facePitch;
        this.head.getJoint().field_78796_g += faceYaw;
    }

    protected void animateMelee(int fullTick) {
        if (fullTick < 3) {
            float tick = ((float)fullTick + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += f * (float)Math.PI / 16.0f;
            }
            this.arm1.field_78796_g += f * (float)Math.PI / 10.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 4.0f;
            this.arm2.field_78808_h += f * (float)(-Math.PI) / 16.0f;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 3) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += f * 0.5890486f - 0.3926991f;
            }
            this.arm1.field_78796_g += f * 2.7307692f - 2.41661f;
            this.arm1.field_78808_h += f * 1.1780972f - 0.3926991f;
            this.arm2.field_78808_h += -0.19634955f;
        } else if (fullTick < 8) {
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -0.3926991f;
            }
            this.arm1.field_78796_g += -2.41661f;
            this.arm1.field_78808_h += -0.3926991f;
            this.arm2.field_78808_h += -0.19634955f;
        } else if (fullTick < 14) {
            float tick = ((float)(fullTick - 8) + this.partialTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += f * (float)(-Math.PI) / 8.0f;
            }
            this.arm1.field_78796_g += f * (float)(-Math.PI) / 1.3f;
            this.arm1.field_78808_h += f * (float)(-Math.PI) / 8.0f;
            this.arm2.field_78808_h += f * (float)(-Math.PI) / 16.0f;
        }
    }

    protected void animateShoot(int fullTick, float facePitch, float faceYaw) {
        if (fullTick < 5) {
            float tick = ((float)fullTick + this.partialTick) / 5.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.arm1.getJoint().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 2.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getJoint().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm2.field_78796_g += f * (float)Math.PI / 2.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.arm2.getJoint().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 6.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 5) + this.partialTick) / 7.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.head.getJoint().field_78796_g += f1 * (float)Math.PI / 4.0f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f1 * (float)Math.PI / 12.0f;
                spine.middle.field_78795_f += f1 * facePitch / 3.0f;
                spine.middle.field_78796_g += f1 * faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += f * 0.2617994f - 1.0471976f;
            this.arm1.field_78796_g += f * -0.9424778f - 0.62831855f;
            this.arm1.field_78808_h += f * -0.850848f + 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getJoint().field_78795_f += f * 1.8325956f - 2.6179938f;
            this.arm2.field_78796_g += f * 0.9424778f + 0.62831855f;
            this.arm2.field_78808_h += f * 0.850848f - 1.0471976f;
            this.arm2.getJoint().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += f * 0.10471976f - 0.62831855f;
            this.crossbow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 26) {
            this.head.getJoint().field_78796_g += 0.7853982f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -0.2617994f;
                spine.middle.field_78795_f += facePitch / 3.0f;
                spine.middle.field_78796_g += faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += -1.0471976f;
            this.arm1.field_78796_g += -0.62831855f;
            this.arm1.field_78808_h += 1.0f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getJoint().field_78795_f += -2.6179938f;
            this.arm2.field_78796_g += 0.62831855f;
            this.arm2.field_78808_h += -1.0471976f;
            this.forearm2.field_78795_f += -0.62831855f;
            float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.crossbow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 26) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.head.getJoint().field_78796_g += f * (float)Math.PI / 4.0f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f * (float)Math.PI / 12.0f;
                spine.middle.field_78795_f += f * facePitch / 3.0f;
                spine.middle.field_78796_g += f * faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += -f * (float)Math.PI / 3.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 5.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 3.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getJoint().field_78795_f += -f * (float)Math.PI / 1.2f;
            this.arm2.field_78796_g += f * (float)Math.PI / 5.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 3.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 5.0f;
            this.crossbow.rotateRope();
        }
    }

    protected void animateMultiShoot(int fullTick, float facePitch, float faceYaw) {
        if (fullTick < 10) {
            float tick = ((float)fullTick + this.partialTick) / 10.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_78797_d += f * 3.5f;
            this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
            this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.arm2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.foreleg1.getJoint().field_78795_f += f * (float)Math.PI / 4.0f;
            this.foreleg2.getJoint().field_78795_f += f * (float)Math.PI / 4.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 12) {
            float tick = ((float)(fullTick - 10) + this.partialTick) / 2.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.skeleBase.field_78797_d += f * 3.5f;
            this.spine[0].middle.field_78795_f += f * (float)Math.PI / 6.0f;
            this.head.field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.arm2.field_78795_f += f * (float)Math.PI / 6.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.leg1.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.leg2.field_78795_f += -f * (float)Math.PI / 8.0f;
            this.foreleg1.getJoint().field_78795_f += f * (float)Math.PI / 4.0f;
            this.foreleg2.getJoint().field_78795_f += f * (float)Math.PI / 4.0f;
            this.arm1.field_78808_h += -f1 * (float)Math.PI / 14.0f;
            this.arm2.field_78808_h += f1 * (float)Math.PI / 14.0f;
            this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
            this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
            this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
            this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 14) {
            this.arm1.field_78808_h += -0.22439948f;
            this.arm2.field_78808_h += 0.22439948f;
            this.leg1.field_78808_h += -0.1308997f;
            this.leg2.field_78808_h += 0.1308997f;
            this.foreleg1.field_78808_h += 0.049087387f;
            this.foreleg2.field_78808_h += -0.049087387f;
            this.crossbow.rotateRope();
        } else if (fullTick < 17) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.arm1.field_78808_h += -f1 * (float)Math.PI / 14.0f;
            this.arm2.field_78808_h += f1 * (float)Math.PI / 14.0f;
            this.leg1.field_78808_h += -f1 * (float)Math.PI / 24.0f;
            this.leg2.field_78808_h += f1 * (float)Math.PI / 24.0f;
            this.foreleg1.field_78808_h += f1 * (float)Math.PI / 64.0f;
            this.foreleg2.field_78808_h += -f1 * (float)Math.PI / 64.0f;
            this.arm1.getJoint().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 2.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 16.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getJoint().field_78795_f += -f * (float)Math.PI / 4.0f;
            this.arm2.field_78796_g += f * (float)Math.PI / 2.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 16.0f;
            this.arm2.getJoint().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 6.0f;
            this.crossbow.rotateRope();
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 17) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            float f1s = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f * 0.4f));
            this.head.getJoint().field_78796_g += f1 * (float)Math.PI / 4.0f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f1 * (float)Math.PI / 12.0f;
                spine.middle.field_78795_f += f1 * facePitch / 3.0f;
                spine.middle.field_78796_g += f1 * faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += f * 0.2617994f - 1.0471976f;
            this.arm1.field_78796_g += f * -0.9424778f - 0.62831855f;
            this.arm1.field_78808_h += f * -0.850848f + 1.0471976f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getJoint().field_78795_f += f * 1.8325956f - 2.6179938f;
            this.arm2.field_78796_g += f * 0.9424778f + 0.62831855f;
            this.arm2.field_78808_h += f * 0.850848f - 1.0471976f;
            this.arm2.getJoint().field_78808_h += -f * (float)Math.PI / 8.0f;
            this.forearm2.field_78795_f += f * 0.10471976f - 0.62831855f;
            this.crossbow.middle1.field_78795_f += -f1s * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f1s * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f1s * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f1s * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f1s * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f1s * (float)Math.PI / 6.0f;
        } else if (fullTick < 24) {
            this.head.getJoint().field_78796_g += 0.7853982f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -0.2617994f;
                spine.middle.field_78795_f += facePitch / 3.0f;
                spine.middle.field_78796_g += faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += -1.0471976f;
            this.arm1.field_78796_g += -0.62831855f;
            this.arm1.field_78808_h += 1.0f;
            this.forearm1.field_78795_f += 0.44879895f;
            this.arm2.getJoint().field_78795_f += -2.6179938f;
            this.arm2.field_78796_g += 0.62831855f;
            this.arm2.field_78808_h += -1.0471976f;
            this.forearm2.field_78795_f += -0.62831855f;
            float tick = MathHelper.func_76131_a((float)((float)(fullTick - 25) + this.partialTick), (float)0.0f, (float)1.0f);
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.crossbow.middle1.field_78795_f += -f * (float)Math.PI / 16.0f;
            this.crossbow.side1.field_78795_f += -f * (float)Math.PI / 24.0f;
            this.crossbow.middle2.field_78795_f += f * (float)Math.PI / 16.0f;
            this.crossbow.side2.field_78795_f += f * (float)Math.PI / 24.0f;
            this.crossbow.rotateRope();
            this.crossbow.rope1.field_78795_f += f * (float)Math.PI / 6.0f;
            this.crossbow.rope2.field_78795_f += -f * (float)Math.PI / 6.0f;
        } else if (fullTick < 28) {
            float tick = ((float)(fullTick - 24) + this.partialTick) / 4.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.head.getJoint().field_78796_g += f * (float)Math.PI / 4.0f;
            for (Spine spine : this.spine) {
                spine.middle.field_78796_g += -f * (float)Math.PI / 12.0f;
                spine.middle.field_78795_f += f * facePitch / 3.0f;
                spine.middle.field_78796_g += f * faceYaw / 3.0f;
            }
            this.arm1.getJoint().field_78795_f += -f * (float)Math.PI / 3.0f;
            this.arm1.field_78796_g += -f * (float)Math.PI / 5.0f;
            this.arm1.field_78808_h += f * (float)Math.PI / 3.0f;
            this.forearm1.field_78795_f += f * (float)Math.PI / 7.0f;
            this.arm2.getJoint().field_78795_f += -f * (float)Math.PI / 1.2f;
            this.arm2.field_78796_g += f * (float)Math.PI / 5.0f;
            this.arm2.field_78808_h += -f * (float)Math.PI / 3.0f;
            this.forearm2.field_78795_f += -f * (float)Math.PI / 5.0f;
            this.crossbow.rotateRope();
        }
    }

    protected void animateConstrict() {
        block6: {
            float f;
            float tick;
            int animTick;
            block7: {
                block5: {
                    this.animator.startKeyframe(5);
                    this.animator.rotate(this.waist, 0.1308997f, 0.0f, 0.0f);
                    for (animTick = 0; animTick < this.spine.length; ++animTick) {
                        tick = animTick == 0 ? 0.3926991f : (animTick == 2 ? -0.3926991f : 0.0f);
                        f = animTick == 1 ? 0.3926991f : 0.31415927f;
                        this.animator.rotate(this.spine[animTick].side1[0], tick, f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[0], tick, -f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.rotate(this.arm1, 0.0f, 0.0f, 0.8975979f);
                    this.animator.rotate(this.arm2, 0.0f, 0.0f, -0.8975979f);
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getJoint(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getJoint(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endKeyframe();
                    this.animator.setStaticKeyframe(2);
                    this.animator.startKeyframe(1);
                    this.animator.rotate(this.neck, 0.19634955f, 0.0f, 0.0f);
                    this.animator.rotate(this.head, 0.15707964f, 0.0f, 0.0f);
                    this.animator.rotate(this.waist, 0.31415927f, 0.0f, 0.0f);
                    this.animator.rotate(this.spine[0].middle, 0.2617994f, 0.0f, 0.0f);
                    for (animTick = 0; animTick < this.spine.length; ++animTick) {
                        tick = animTick == 0 ? 0.1308997f : (animTick == 2 ? -0.1308997f : 0.0f);
                        f = animTick == 1 ? -0.17453294f : -0.22439948f;
                        this.animator.rotate(this.spine[animTick].side1[0], tick - 0.08f, f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[1], 0.0f, 0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side1[2], 0.0f, 0.2617994f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[0], tick + 0.08f, -f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[1], 0.0f, -0.15707964f, 0.0f);
                        this.animator.rotate(this.spine[animTick].side2[2], 0.0f, -0.2617994f, 0.0f);
                    }
                    this.animator.move(this.skeleBase, 0.0f, 1.0f, 0.0f);
                    this.animator.rotate(this.leg1, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.leg2, -0.44879895f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg1.getJoint(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.rotate(this.foreleg2.getJoint(), 0.5235988f, 0.0f, 0.0f);
                    this.animator.endKeyframe();
                    this.animator.setStaticKeyframe(4);
                    this.animator.resetKeyframe(8);
                    animTick = this.animator.getEntity().getAnimationTick();
                    if (animTick >= 5) break block5;
                    tick = ((float)animTick + this.partialTick) / 5.0f;
                    f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    for (Spine spine : this.spine) {
                        spine.side1[0].setScale(1.0f + f * 0.6f);
                        spine.side2[0].setScale(1.0f + f * 0.6f);
                    }
                    break block6;
                }
                if (animTick >= 12) break block7;
                for (Spine spine : this.spine) {
                    spine.side1[0].setScale(1.6f);
                    spine.side2[0].setScale(1.6f);
                }
                break block6;
            }
            if (animTick >= 20) break block6;
            tick = ((float)(animTick - 12) + this.partialTick) / 8.0f;
            f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            for (Spine spine : this.spine) {
                spine.side1[0].setScale(1.0f + f * 0.6f);
                spine.side2[0].setScale(1.0f + f * 0.6f);
            }
        }
    }

    public void setLivingAnimations(MutantSkeletonEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SkullModel
    extends GenericHeadModel {
        private final ModelRenderer head;
        private final ModelRenderer jaw;

        public SkullModel() {
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.head = new ModelRenderer((Model)this, 0, 0);
            this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.4f);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.jaw = new ModelRenderer((Model)this, 72, 0);
            this.jaw.func_228301_a_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.7f);
            this.jaw.func_78793_a(0.0f, -0.2f, 3.5f);
            this.head.func_78792_a(this.jaw);
        }

        public void func_225603_a_(float animationProgress, float netHeadYaw, float headPitch) {
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.jaw.field_78795_f = 0.09817477f;
        }

        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.head.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Spine {
        public final ModelRenderer middle;
        public final ScalableModelRenderer[] side1;
        public final ScalableModelRenderer[] side2;

        public Spine(Model model) {
            this(model, false);
        }

        public Spine(Model model, boolean skeletonPart) {
            this.middle = new ModelRenderer(model, 50, 0);
            this.middle.func_228301_a_(-2.5f, -4.0f, -2.0f, 5.0f, 4.0f, 4.0f, 0.5f);
            this.side1 = new ScalableModelRenderer[3];
            this.side2 = new ScalableModelRenderer[3];
            this.side1[0] = new ScalableModelRenderer(model, 32, 12);
            this.side1[0].func_228301_a_(skeletonPart ? 0.0f : -6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.25f);
            if (!skeletonPart) {
                this.side1[0].func_78793_a(-3.0f, -1.0f, 1.75f);
            }
            this.middle.func_78792_a((ModelRenderer)this.side1[0]);
            this.side2[0] = new ScalableModelRenderer(model, 32, 12);
            this.side2[0].field_78809_i = true;
            this.side2[0].func_228301_a_(skeletonPart ? -6.0f : 0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.25f);
            if (!skeletonPart) {
                this.side2[0].func_78793_a(3.0f, -1.0f, 1.75f);
            }
            this.middle.func_78792_a((ModelRenderer)this.side2[0]);
            this.side1[1] = new ScalableModelRenderer(model, 32, 12);
            this.side1[1].field_78809_i = true;
            this.side1[1].func_228301_a_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.2f);
            this.side1[1].func_78793_a(skeletonPart ? -0.5f : -6.5f, 0.0f, 0.0f);
            this.side1[0].func_78792_a(this.side1[1]);
            this.side2[1] = new ScalableModelRenderer(model, 32, 12);
            this.side2[1].func_228301_a_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.2f);
            this.side2[1].func_78793_a(skeletonPart ? 0.5f : 6.5f, 0.0f, 0.0f);
            this.side2[0].func_78792_a(this.side2[1]);
            this.side1[2] = new ScalableModelRenderer(model, 32, 12);
            this.side1[2].func_228301_a_(-6.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.15f);
            this.side1[2].func_78793_a(-6.4f, 0.0f, 0.0f);
            this.side1[1].func_78792_a(this.side1[2]);
            this.side2[2] = new ScalableModelRenderer(model, 32, 12);
            this.side2[2].field_78809_i = true;
            this.side2[2].func_228301_a_(0.0f, -2.0f, -2.0f, 6.0f, 2.0f, 2.0f, 0.15f);
            this.side2[2].func_78793_a(6.4f, 0.0f, 0.0f);
            this.side2[1].func_78792_a(this.side2[2]);
        }

        public void setAngles(float PI, boolean middleSpine) {
            ModelUtil.resetAngles(this.middle);
            ModelUtil.resetAngles(this.side1);
            ModelUtil.resetAngles(this.side2);
            this.middle.field_78795_f = PI / 18.0f;
            this.side1[0].field_78796_g = -PI / 4.5f;
            this.side2[0].field_78796_g = PI / 4.5f;
            this.side1[1].field_78796_g = -PI / 3.0f;
            this.side2[1].field_78796_g = PI / 3.0f;
            this.side1[2].field_78796_g = -PI / 3.5f;
            this.side2[2].field_78796_g = PI / 3.5f;
            if (middleSpine) {
                for (int i = 0; i < this.side1.length; ++i) {
                    this.side1[i].field_78796_g *= 0.98f;
                    this.side2[i].field_78796_g *= 0.98f;
                }
            }
            this.side1[0].setScale(1.0f);
            this.side2[0].setScale(1.0f);
        }

        public void animate(float breatheAnim) {
            this.side1[1].field_78796_g += breatheAnim * 0.02f;
            this.side2[1].field_78796_g -= breatheAnim * 0.02f;
        }
    }
}

