/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity.model;

import chumbanotz.mutantbeasts.client.renderer.model.JointModelRenderer;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MutantSnowGolemModel
extends SegmentedModel<MutantSnowGolemEntity> {
    private final ModelRenderer pelvis;
    private final ModelRenderer abdomen;
    private final ModelRenderer chest;
    private final JointModelRenderer head;
    private final ModelRenderer headCore;
    private final JointModelRenderer arm1;
    private final JointModelRenderer arm2;
    private final JointModelRenderer forearm1;
    private final JointModelRenderer forearm2;
    private final JointModelRenderer leg1;
    private final JointModelRenderer leg2;
    private final JointModelRenderer foreleg1;
    private final JointModelRenderer foreleg2;
    private float partialTick;

    public MutantSnowGolemModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.pelvis = new ModelRenderer((Model)this);
        this.pelvis.func_78793_a(0.0f, 13.5f, 5.0f);
        this.abdomen = new ModelRenderer((Model)this, 0, 32);
        this.abdomen.func_228300_a_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f);
        this.pelvis.func_78792_a(this.abdomen);
        this.chest = new ModelRenderer((Model)this, 24, 36);
        this.chest.func_228300_a_(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 12.0f);
        this.chest.func_78793_a(0.0f, -6.0f, 0.0f);
        this.head = new JointModelRenderer((Model)this, 0, 0);
        this.head.setTextureSize(64, 32);
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.5f);
        this.head.func_78793_a(0.0f, -12.0f, -2.0f);
        this.chest.func_78792_a((ModelRenderer)this.head);
        this.headCore = new ModelRenderer((Model)this, 64, 0);
        this.headCore.func_228300_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.headCore.func_78784_a(80, 46).func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, -0.5f);
        this.headCore.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.headCore);
        this.abdomen.func_78792_a(this.chest);
        this.arm1 = new JointModelRenderer((Model)this, 68, 16);
        this.arm1.func_228300_a_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f);
        this.arm1.func_78793_a(-9.0f, -11.0f, 0.0f);
        this.chest.func_78792_a((ModelRenderer)this.arm1);
        this.forearm1 = new JointModelRenderer((Model)this, 96, 0);
        this.forearm1.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f);
        this.forearm1.func_78793_a(0.0f, 10.0f, 0.0f);
        this.arm1.func_78792_a(this.forearm1);
        this.arm2 = new JointModelRenderer((Model)this, 68, 16);
        this.arm2.field_78809_i = true;
        this.arm2.func_228300_a_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f);
        this.arm2.func_78793_a(9.0f, -11.0f, 0.0f);
        this.chest.func_78792_a((ModelRenderer)this.arm2);
        this.forearm2 = new JointModelRenderer((Model)this, 96, 0);
        this.forearm2.field_78809_i = true;
        this.forearm2.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f);
        this.forearm2.func_78793_a(0.0f, 10.0f, 0.0f);
        this.arm2.func_78792_a(this.forearm2);
        this.leg1 = new JointModelRenderer((Model)this, 88, 18);
        this.leg1.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f);
        this.leg1.func_78793_a(-4.0f, -1.0f, -3.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg1);
        this.foreleg1 = new JointModelRenderer((Model)this, 88, 32);
        this.foreleg1.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f);
        this.foreleg1.func_78793_a(-1.0f, 6.0f, -0.0f);
        this.leg1.func_78792_a(this.foreleg1);
        this.leg2 = new JointModelRenderer((Model)this, 88, 18);
        this.leg2.field_78809_i = true;
        this.leg2.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f);
        this.leg2.func_78793_a(4.0f, -1.0f, -3.0f);
        this.pelvis.func_78792_a((ModelRenderer)this.leg2);
        this.foreleg2 = new JointModelRenderer((Model)this, 88, 32);
        this.foreleg2.field_78809_i = true;
        this.foreleg2.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f);
        this.foreleg2.func_78793_a(1.0f, 6.0f, -0.0f);
        this.leg2.func_78792_a(this.foreleg2);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.pelvis);
    }

    public void setRotationAngles(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.field_78797_d = 13.5f;
        this.abdomen.field_78795_f = 0.1308997f;
        this.chest.field_78795_f = 0.1308997f;
        this.chest.field_78796_g = 0.0f;
        this.head.field_78795_f = -0.2617994f;
        this.head.getJoint().field_78795_f = 0.0f;
        this.head.getJoint().field_78796_g = 0.0f;
        this.arm1.field_78795_f = -0.31415927f;
        this.arm1.field_78808_h = 0.0f;
        this.arm1.getJoint().field_78795_f = 0.0f;
        this.arm1.getJoint().field_78796_g = 0.5235988f;
        this.arm1.getJoint().field_78808_h = 0.5235988f;
        this.forearm1.field_78796_g = -0.5235988f;
        this.forearm1.field_78808_h = -0.2617994f;
        this.forearm1.getJoint().field_78795_f = -0.5235988f;
        this.arm2.field_78795_f = -0.31415927f;
        this.arm2.field_78808_h = 0.0f;
        this.arm2.getJoint().field_78795_f = 0.0f;
        this.arm2.getJoint().field_78796_g = -0.5235988f;
        this.arm2.getJoint().field_78808_h = -0.5235988f;
        this.forearm2.field_78796_g = 0.5235988f;
        this.forearm2.field_78808_h = 0.2617994f;
        this.forearm2.getJoint().field_78795_f = -0.5235988f;
        this.leg1.field_78795_f = -0.62831855f;
        this.leg1.getJoint().field_78808_h = 0.5235988f;
        this.foreleg1.field_78808_h = -0.5235988f;
        this.foreleg1.getJoint().field_78795_f = 0.69813174f;
        this.leg2.field_78795_f = -0.62831855f;
        this.leg2.getJoint().field_78808_h = -0.5235988f;
        this.foreleg2.field_78808_h = 0.5235988f;
        this.foreleg2.getJoint().field_78795_f = 0.69813174f;
    }

    private void animate(MutantSnowGolemEntity golem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float temp = 0.5f;
        float walkAnim = MathHelper.func_76126_a((float)(limbSwing * 0.45f)) * limbSwingAmount;
        float walkAnim1 = (MathHelper.func_76134_b((float)((limbSwing - temp) * 0.45f)) + temp) * limbSwingAmount;
        float walkAnim2 = (MathHelper.func_76134_b((float)((limbSwing - temp + (float)Math.PI * 2) * 0.45f)) + temp) * limbSwingAmount;
        float breatheAnim = MathHelper.func_76126_a((float)(ageInTicks * 0.11f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (golem.isThrowing()) {
            this.animateThrow(golem.getThrowingTick());
            float scale = 1.0f - MathHelper.func_76131_a((float)((float)golem.getThrowingTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim *= scale;
        }
        this.head.getJoint().field_78795_f -= breatheAnim * 0.01f;
        this.chest.field_78795_f -= breatheAnim * 0.01f;
        this.arm1.field_78808_h += breatheAnim * 0.03f;
        this.arm2.field_78808_h -= breatheAnim * 0.03f;
        this.head.getJoint().field_78795_f += facePitch;
        this.head.getJoint().field_78796_g += faceYaw;
        this.pelvis.field_78797_d += Math.abs(walkAnim) * 1.5f;
        this.abdomen.field_78795_f += limbSwingAmount * 0.2f;
        this.chest.field_78796_g -= walkAnim * 0.1f;
        this.head.field_78795_f -= limbSwingAmount * 0.2f;
        this.arm1.field_78795_f -= walkAnim * 0.6f;
        this.arm2.field_78795_f += walkAnim * 0.6f;
        this.forearm1.getJoint().field_78795_f -= walkAnim * 0.2f;
        this.forearm2.getJoint().field_78795_f += walkAnim * 0.2f;
        this.leg1.field_78795_f += walkAnim1 * 1.1f;
        this.leg2.field_78795_f += walkAnim2 * 1.1f;
        this.foreleg1.getJoint().field_78795_f += walkAnim * 0.2f;
        this.foreleg2.getJoint().field_78795_f -= walkAnim * 0.2f;
    }

    private void animateThrow(int fullTick) {
        if (fullTick < 7) {
            float tick = ((float)fullTick + this.partialTick) / 7.0f;
            float f = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += -f * 0.2f;
            this.chest.field_78795_f += -f * 0.4f;
            this.arm1.field_78795_f += -f * 1.6f;
            this.arm1.field_78808_h += f * 0.8f;
            this.arm2.field_78795_f += -f * 1.6f;
            this.arm2.field_78808_h += -f * 0.8f;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 7) + this.partialTick) / 3.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += -f * 0.4f + 0.2f;
            this.chest.field_78795_f += -f * 0.6f + 0.2f;
            this.arm1.field_78795_f += -f * 0.8f - 0.8f;
            this.arm1.field_78808_h += 0.8f;
            this.arm2.field_78795_f += -f * 0.8f - 0.8f;
            this.arm2.field_78808_h += -0.8f;
        } else if (fullTick < 14) {
            this.abdomen.field_78795_f += 0.2f;
            this.chest.field_78795_f += 0.2f;
            this.arm1.field_78795_f += -0.8f;
            this.arm1.field_78808_h += 0.8f;
            this.arm2.field_78795_f += -0.8f;
            this.arm2.field_78808_h += -0.8f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 6.0f;
            float f = MathHelper.func_76134_b((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.field_78795_f += f * 0.2f;
            this.chest.field_78795_f += f * 0.2f;
            this.arm1.field_78795_f += -f * 0.8f;
            this.arm1.field_78808_h += f * 0.8f;
            this.arm2.field_78795_f += -f * 0.8f;
            this.arm2.field_78808_h += -f * 0.8f;
        }
    }

    public void translateRotateArms(MatrixStack matrixStackIn) {
        this.pelvis.func_228307_a_(matrixStackIn);
        this.abdomen.func_228307_a_(matrixStackIn);
        this.chest.func_228307_a_(matrixStackIn);
        this.arm1.func_228307_a_(matrixStackIn);
        this.arm1.getJoint().func_228307_a_(matrixStackIn);
        this.forearm1.func_228307_a_(matrixStackIn);
        this.forearm1.getJoint().func_228307_a_(matrixStackIn);
    }

    public void setLivingAnimations(MutantSnowGolemEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }
}

