/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.client.gui.screen.CreeperMinionTrackerScreen;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.CopyAttackTargetGoal;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ShoulderRidingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class CreeperMinionEntity
extends ShoulderRidingEntity {
    private static final DataParameter<Byte> CREEPER_MINION_FLAGS = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> EXPLODE_STATE = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> EXPLOSION_RADIUS = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(CreeperMinionEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;

    public CreeperMinionEntity(EntityType<? extends CreeperMinionEntity> type, World worldIn) {
        super(type, worldIn);
        this.setDestroyBlocks(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (Goal)new SwellGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal<AnimalEntity>((CreatureEntity)this, AnimalEntity.class, 6.0f, 1.0, 1.2, EntityUtil::isFeline){

            public boolean func_75250_a() {
                return !CreeperMinionEntity.this.func_70909_n() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LandOnOwnersShoulderGoal(this){

            public boolean func_75250_a() {
                return CreeperMinionEntity.this.func_70909_n() && CreeperMinionEntity.this.func_70902_q() instanceof PlayerEntity && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new CopyAttackTargetGoal((CreatureEntity)this, true, this::func_70902_q));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, true, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EXPLODE_STATE, (Object)-1);
        this.field_70180_af.func_187214_a(CREEPER_MINION_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(EXPLOSION_RADIUS, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)-1);
    }

    @Nullable
    public LivingEntity func_70902_q() {
        UUID uuid = this.func_184753_b();
        if (uuid == null) {
            return null;
        }
        PlayerEntity entity = this.field_70170_p.func_217371_b(uuid);
        if (entity == null && this.field_70170_p instanceof ServerWorld) {
            entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
        }
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public int getExplodeState() {
        return (Integer)this.field_70180_af.func_187225_a(EXPLODE_STATE);
    }

    private void setExplodeState(int state) {
        this.field_70180_af.func_187227_b(EXPLODE_STATE, (Object)state);
    }

    public boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setPowered(boolean powered) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(powered ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CREEPER_MINION_FLAGS);
        this.field_70180_af.func_187227_b(CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.field_70180_af.func_187225_a(EXPLOSION_RADIUS)).floatValue() / 10.0f;
    }

    public void setExplosionRadius(float radius) {
        this.field_70180_af.func_187227_b(EXPLOSION_RADIUS, (Object)Float.valueOf(radius * 10.0f));
    }

    @Nullable
    public DyeColor getCollarColor() {
        int i = (Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR);
        return i == -1 ? null : DyeColor.func_196056_a((int)i);
    }

    public void setCollarColor(DyeColor collarcolor) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)collarcolor.func_196059_a());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (field_184755_bv.equals(key)) {
            this.func_213323_x_();
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_70906_o() ? super.func_213305_a(poseIn).func_220312_a(1.0f, 0.75f) : super.func_213305_a(poseIn);
    }

    public boolean func_70631_g_() {
        return true;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public float func_213355_cm() {
        return 1.0f;
    }

    public boolean func_191995_du() {
        return super.func_191995_du() && this.canRideOnShoulder() && this.func_70638_az() == null && this.getExplodeState() <= 0;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.setPowered(true);
    }

    protected boolean func_225511_J_() {
        return !this.func_70909_n();
    }

    public void func_70071_h_() {
        if (this.func_70089_S() || this.func_213322_ci().func_189985_c() > 0.8) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(MBSoundEvents.ENTITY_CREEPER_MINION_PRIMED, 1.0f, this.func_70647_i());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = 0;
                if (!this.field_70170_p.field_72995_K) {
                    MutatedExplosion.create((Entity)this, this.getExplosionRadius() + (this.isCharged() ? 2.0f : 0.0f), false, this.canDestroyBlocks() ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
                    if (!this.canExplodeContinuously()) {
                        this.field_70729_aU = true;
                        this.func_70106_y();
                        EntityUtil.spawnLingeringCloud((LivingEntity)this);
                    }
                }
                this.setExplodeState(-30);
            }
            if (!this.field_70122_E && this.func_213322_ci().func_189985_c() > (double)0.8f && (this.field_70132_H || this.func_70638_az() != null && this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(0.5).func_72326_a(this.func_70638_az().func_174813_aQ()))) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.func_70071_h_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        if (this.func_70909_n()) {
            if (itemstack.func_77973_b() == MBItems.CREEPER_MINION_TRACKER) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::openGui);
                return true;
            }
            if (!this.func_152114_e((LivingEntity)player)) return false;
            if (itemstack.func_77973_b() instanceof DyeItem) {
                DyeColor dyecolor = ((DyeItem)itemstack.func_77973_b()).func_195962_g();
                if (dyecolor == this.getCollarColor()) return false;
                this.setCollarColor(dyecolor);
                itemstack.func_190918_g(1);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151016_H) {
                boolean spawnParticles = false;
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(1.0f);
                    itemstack.func_190918_g(1);
                    return true;
                }
                if (this.func_110138_aP() < 20.0f) {
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.func_110138_aP() + 1.0f));
                    itemstack.func_190918_g(1);
                    return true;
                }
                if (!spawnParticles) return false;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
                return false;
            } else {
                if (itemstack.func_77973_b() == Items.field_221649_bM) {
                    if (this.canExplodeContinuously()) {
                        float explosionRadius = this.getExplosionRadius();
                        if (!(explosionRadius < 4.0f)) return false;
                        this.field_175503_c += 10;
                        this.setExplosionRadius(explosionRadius + 0.11f);
                        itemstack.func_190918_g(1);
                        return true;
                    }
                    this.field_175503_c += 15;
                    this.setCanExplodeContinuously(true);
                    itemstack.func_190918_g(1);
                    return true;
                }
                if (this.field_70170_p.field_72995_K) return true;
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.func_70604_c(null);
                this.func_70624_b(null);
                return true;
            }
        }
        if (itemstack.func_77973_b() == Items.field_151033_d && !this.hasIgnited()) {
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (this.field_70170_p.field_72995_K) return true;
            this.ignite();
            itemstack.func_222118_a(1, (LivingEntity)player, livingEntity -> livingEntity.func_213334_d(hand));
            return true;
        }
        if (!player.func_184812_l_() || itemstack.func_77973_b() != MBItems.CREEPER_MINION_TRACKER || this.func_70902_q() != null) return false;
        if (this.field_70170_p.field_72995_K) return true;
        this.func_193101_c(player);
        player.func_145747_a((ITextComponent)new TranslationTextComponent(MBItems.CREEPER_MINION_TRACKER.func_77658_a() + ".tame_success", new Object[]{this.func_145748_c_(), player.func_145748_c_()}));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui() {
        if (this.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((Screen)new CreeperMinionTrackerScreen(this));
        }
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity((TameableEntity)this, target, owner, true);
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_94541_c()) {
            if (this.func_70909_n()) {
                return false;
            }
            if (amount >= 2.0f) {
                amount = 2.0f;
            }
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_180427_aV() {
        return this.func_70909_n();
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.func_70909_n();
    }

    public boolean func_213336_c(LivingEntity target) {
        return super.func_213336_c(target) && !target.func_180427_aV() && target.func_200600_R() != MBEntityType.MUTANT_CREEPER;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null && !this.hasIgnited()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_CREEPER_MINION_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_CREEPER_MINION_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_CREEPER_MINION_DEATH;
    }

    public SoundCategory func_184176_by() {
        return !this.func_70909_n() ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Tamed", this.func_70909_n());
        compound.func_74757_a("ExplodesContinuously", this.canExplodeContinuously());
        compound.func_74757_a("DestroysBlocks", this.canDestroyBlocks());
        compound.func_74757_a("CanRideOnShoulder", this.canRideOnShoulder());
        compound.func_74757_a("Ignited", this.hasIgnited());
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74776_a("ExplosionRadius", this.getExplosionRadius());
        if (this.getCollarColor() != null) {
            compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
        }
        if (this.isCharged()) {
            compound.func_74757_a("Powered", true);
        }
        for (String s : new String[]{"Age", "ForcedAge", "InLove", "LoveCause"}) {
            compound.func_82580_o(s);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70903_f(compound.func_74767_n("Tamed"));
        this.setCanExplodeContinuously(compound.func_74767_n("ExplodesContinuously"));
        this.setDestroyBlocks(compound.func_74767_n("DestroysBlocks"));
        this.setCanRideOnShoulder(compound.func_74767_n("CanRideOnShoulder"));
        this.setPowered(compound.func_74767_n("Powered"));
        this.setExplosionRadius(compound.func_74760_g("ExplosionRadius"));
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)compound.func_74762_e("CollarColor")));
        }
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_74767_n("Ignited")) {
            this.ignite();
        }
    }

    class FollowOwnerGoal
    extends net.minecraft.entity.ai.goal.FollowOwnerGoal {
        public FollowOwnerGoal() {
            super((TameableEntity)CreeperMinionEntity.this, 1.2, 10.0f, 5.0f, false);
        }

        public boolean func_75250_a() {
            return CreeperMinionEntity.this.func_70638_az() == null && super.func_75250_a();
        }

        public void func_75246_d() {
            if (!CreeperMinionEntity.this.func_70909_n()) {
                if (CreeperMinionEntity.this.func_70902_q() != null) {
                    CreeperMinionEntity.this.func_70661_as().func_75497_a((Entity)CreeperMinionEntity.this.func_70902_q(), 1.2);
                }
            } else {
                super.func_75246_d();
            }
        }
    }

    class SwellGoal
    extends Goal {
        public SwellGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = CreeperMinionEntity.this.func_70638_az();
            return !CreeperMinionEntity.this.func_70906_o() && (CreeperMinionEntity.this.getExplodeState() > 0 || livingentity != null && CreeperMinionEntity.this.func_70068_e((Entity)livingentity) < 9.0);
        }

        public void func_75249_e() {
            CreeperMinionEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75246_d() {
            LivingEntity livingentity = CreeperMinionEntity.this.func_70638_az();
            CreeperMinionEntity.this.setExplodeState(CreeperMinionEntity.this.func_70906_o() || livingentity == null || CreeperMinionEntity.this.func_70068_e((Entity)livingentity) > 36.0 || !CreeperMinionEntity.this.func_70635_at().func_75522_a((Entity)livingentity) ? -1 : 1);
        }
    }
}

