/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EndersoulFragmentEntity
extends Entity {
    public static final Predicate<Entity> IS_VALID_TARGET = entity -> EntityPredicates.field_188444_d.test(entity) && entity.func_70067_L() && !(entity instanceof EndersoulFragmentEntity) && !(entity instanceof MutantEndermanEntity) && !(entity instanceof EndermanEntity);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EndersoulFragmentEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EndersoulFragmentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.field_70146_Z.nextInt(20);
    private WeakReference<LivingEntity> owner;
    private UUID ownerUUID;

    public EndersoulFragmentEntity(EntityType<? extends EndersoulFragmentEntity> type, World world) {
        super(type, world);
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragmentEntity(World world, MutantEndermanEntity owner) {
        this(MBEntityType.ENDERSOUL_FRAGMENT, world);
        this.owner = new WeakReference<MutantEndermanEntity>(owner);
        this.setOwnerUniqueId(owner.func_110124_au());
    }

    public EndersoulFragmentEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(MBEntityType.ENDERSOUL_FRAGMENT, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUniqueId();
        if (uuid == null) {
            return null;
        }
        PlayerEntity entity = this.field_70170_p.func_217371_b(uuid);
        if (entity == null && this.field_70170_p instanceof ServerWorld) {
            entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
        }
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean func_70075_an() {
        return !this.isTamed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            EntityUtil.spawnLargePortalParticles(this, 64, 0.8f, false);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d vec3d = this.func_213322_ci();
        LivingEntity owner = this.getOwner();
        if (!(owner instanceof PlayerEntity) && vec3d.field_72448_b > (double)-0.05f && !this.func_189652_ae()) {
            this.func_213293_j(vec3d.field_72450_a, Math.max((double)-0.05f, vec3d.field_72448_b - (double)0.1f), vec3d.field_72449_c);
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        if (owner != null) {
            if (!owner.func_70089_S() || !owner.isAddedToWorld() || owner.func_175149_v()) {
                this.setOwnerUniqueId(null);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70068_e((Entity)owner) > 9.0) {
                float scale = 0.05f;
                this.func_70024_g((owner.func_226277_ct_() - this.func_226277_ct_()) * (double)scale, (owner.func_226278_cu_() + (double)(owner.func_213302_cg() / 3.0f) - this.func_226278_cu_()) * (double)scale, (owner.func_226281_cx_() - this.func_226281_cx_()) * (double)scale);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.isTamed() && --this.explodeTick == 0) {
            this.explode();
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (this.isTamed()) {
            LivingEntity owner = this.getOwner();
            if (owner == null && !player.func_213453_ef()) {
                this.setOwnerUniqueId(player.func_110124_au());
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                return true;
            }
            if (owner == player && player.func_213453_ef()) {
                this.setOwnerUniqueId(null);
                this.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.5f);
                return true;
            }
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setTamed(true);
        }
        this.setOwnerUniqueId(player.func_110124_au());
        this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.5f);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        this.func_184185_a(MBSoundEvents.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(5.0), IS_VALID_TARGET)) {
            boolean hitChance;
            if (!(this.func_70068_e(entity) <= 25.0)) continue;
            boolean bl = hitChance = this.field_70146_Z.nextInt(3) != 0;
            if (EndersoulFragmentEntity.isProtected(entity)) {
                hitChance = this.field_70146_Z.nextInt(3) == 0;
            } else {
                double x = entity.func_226277_ct_() - this.func_226277_ct_();
                double z = entity.func_226281_cx_() - this.func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                entity.func_213293_j((double)0.8f * x / d, (double)(this.field_70146_Z.nextFloat() * 0.6f - 0.1f), (double)0.8f * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getOwner()).func_76348_h(), 1.0f);
        }
        this.func_70106_y();
    }

    public static boolean isProtected(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return EntityUtil.isHolding((LivingEntity)entity, MBItems.ENDERSOUL_HAND);
    }

    @Nullable
    public Team func_96124_cp() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null ? livingentity.func_96124_cp() : super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        LivingEntity livingentity = this.getOwner();
        if (entityIn == livingentity) {
            return true;
        }
        if (livingentity != null) {
            return livingentity.func_184191_r(entityIn);
        }
        return super.func_184191_r(entityIn);
    }

    public SoundCategory func_184176_by() {
        return this.isTamed() ? SoundCategory.NEUTRAL : SoundCategory.HOSTILE;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("Tamed", this.isTamed());
        compound.func_74768_a("ExplodeTick", this.explodeTick);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setTamed(compound.func_74767_n("Collected") || compound.func_74767_n("Tamed"));
        if (compound.func_74764_b("ExplodeTick")) {
            this.explodeTick = compound.func_74762_e("ExplodeTick");
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

