/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.RegistryHandler;
import chumbanotz.mutantbeasts.entity.BodyPartEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import chumbanotz.mutantbeasts.entity.mutant.SpiderPigEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.entity.projectile.MutantArrowEntity;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="mutantbeasts")
public class MBEntityType {
    private static final Set<EntityType<?>> ENTITY_TYPES = new HashSet();
    private static final Set<Item> SPAWN_EGGS = new HashSet<Item>();
    public static final EntityType<BodyPartEntity> BODY_PART = null;
    public static final EntityType<ChemicalXEntity> CHEMICAL_X = null;
    public static final EntityType<CreeperMinionEntity> CREEPER_MINION = null;
    public static final EntityType<CreeperMinionEggEntity> CREEPER_MINION_EGG = null;
    public static final EntityType<EndersoulFragmentEntity> ENDERSOUL_FRAGMENT = null;
    public static final EntityType<MutantArrowEntity> MUTANT_ARROW = null;
    public static final EntityType<MutantCreeperEntity> MUTANT_CREEPER = null;
    public static final EntityType<MutantEndermanEntity> MUTANT_ENDERMAN = null;
    public static final EntityType<MutantSnowGolemEntity> MUTANT_SNOW_GOLEM = null;
    public static final EntityType<MutantSkeletonEntity> MUTANT_SKELETON = null;
    public static final EntityType<MutantZombieEntity> MUTANT_ZOMBIE = null;
    public static final EntityType<SkullSpiritEntity> SKULL_SPIRIT = null;
    public static final EntityType<SpiderPigEntity> SPIDER_PIG = null;
    public static final EntityType<ThrowableBlockEntity> THROWABLE_BLOCK = null;

    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        SPAWN_EGGS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    public static void registerDispenseBehavior() {
        DefaultDispenseItemBehavior defaultdispenseitembehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, (PlayerEntity)null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        SPAWN_EGGS.forEach(item -> DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)defaultdispenseitembehavior));
        SPAWN_EGGS.clear();
    }

    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        ENTITY_TYPES.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        ENTITY_TYPES.clear();
    }

    public static void initialize() {
        MBEntityType.build("body_part", EntityType.Builder.func_220322_a(BodyPartEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(BodyPartEntity::new).setTrackingRange(64).setUpdateInterval(10).func_220321_a(0.7f, 0.7f));
        MBEntityType.build("chemical_x", EntityType.Builder.func_220322_a(ChemicalXEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ChemicalXEntity::new).setTrackingRange(160).setUpdateInterval(10).func_220321_a(0.25f, 0.25f));
        MBEntityType.build("creeper_minion", EntityType.Builder.func_220322_a(CreeperMinionEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3f, 0.84f), 894731, 0xB7B7B7);
        MBEntityType.build("creeper_minion_egg", EntityType.Builder.func_220322_a(CreeperMinionEggEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(CreeperMinionEggEntity::new).func_220321_a(0.5625f, 0.75f));
        MBEntityType.build("endersoul_fragment", EntityType.Builder.func_220322_a(EndersoulFragmentEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(EndersoulFragmentEntity::new).setTrackingRange(64).setUpdateInterval(10).func_220321_a(0.75f, 0.75f));
        MBEntityType.build("mutant_arrow", EntityType.Builder.func_220322_a(MutantArrowEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(MutantArrowEntity::new).setTrackingRange(80).setUpdateInterval(3));
        MBEntityType.build("mutant_creeper", EntityType.Builder.func_220322_a(MutantCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.6f, 2.8f), 5349438, 11013646);
        MBEntityType.build("mutant_enderman", EntityType.Builder.func_220322_a(MutantEndermanEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 4.2f), 0x161616, 8860812);
        MBEntityType.build("mutant_skeleton", EntityType.Builder.func_220322_a(MutantSkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 3.6f), 0xC1C1C1, 6310217);
        MBEntityType.build("mutant_snow_golem", EntityType.Builder.func_220322_a(MutantSnowGolemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.9f, 2.2f), 0xE5FFFF, 16753434);
        MBEntityType.build("mutant_zombie", EntityType.Builder.func_220322_a(MutantZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.8f, 3.2f), 7969893, 44975);
        MBEntityType.build("skull_spirit", EntityType.Builder.func_220322_a(SkullSpiritEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(SkullSpiritEntity::new).setTrackingRange(160).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).func_220321_a(0.1f, 0.1f));
        MBEntityType.build("spider_pig", EntityType.Builder.func_220322_a(SpiderPigEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 0.9f), 3419431, 15771042);
        MBEntityType.build("throwable_block", EntityType.Builder.func_220322_a(ThrowableBlockEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ThrowableBlockEntity::new).setTrackingRange(64).setUpdateInterval(100).func_220321_a(1.0f, 1.0f));
    }

    public static void addSpawns() {
        MBEntityType.copySpawn(MUTANT_CREEPER, (EntityType<? extends MobEntity>)EntityType.field_200797_k, 1, 1, 1);
        MBEntityType.copySpawn(MUTANT_ENDERMAN, (EntityType<? extends MobEntity>)EntityType.field_200803_q, 1, 1, 1);
        MBEntityType.copySpawn(MUTANT_SKELETON, (EntityType<? extends MobEntity>)EntityType.field_200741_ag, 1, 1, 1);
        MBEntityType.copySpawn(MUTANT_ZOMBIE, (EntityType<? extends MobEntity>)EntityType.field_200725_aD, 1, 1, 1);
        EntitySpawnPlacementRegistry.func_209343_a(CREEPER_MINION, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(MUTANT_CREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityUtil::requireDarknessAndSky);
        EntitySpawnPlacementRegistry.func_209343_a(MUTANT_ENDERMAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityUtil::requireDarknessAndSky);
        EntitySpawnPlacementRegistry.func_209343_a(MUTANT_SKELETON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityUtil::requireDarknessAndSky);
        EntitySpawnPlacementRegistry.func_209343_a(MUTANT_SNOW_GOLEM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(MUTANT_ZOMBIE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityUtil::requireDarknessAndSky);
        EntitySpawnPlacementRegistry.func_209343_a(SPIDER_PIG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
    }

    private static <T extends Entity> EntityType<T> build(String name, EntityType.Builder<T> builder) {
        ResourceLocation registryName = MutantBeasts.prefix(name);
        EntityType entityType = builder.func_206830_a(registryName.toString());
        entityType.setRegistryName(registryName);
        ENTITY_TYPES.add(entityType);
        return entityType;
    }

    private static <T extends MobEntity> EntityType<T> build(String name, EntityType.Builder<T> builder, int eggPrimaryColor, int eggSecondaryColor) {
        EntityType<T> entityType = MBEntityType.build(name, builder);
        Item item = (Item)RegistryHandler.setRegistryName(name + "_spawn_egg", new SpawnEggItem(entityType, eggPrimaryColor, eggSecondaryColor, RegistryHandler.defaultProperty()));
        SPAWN_EGGS.add(item);
        return entityType;
    }

    private static void copySpawn(EntityType<? extends MobEntity> typeToSpawn, EntityType<? extends MobEntity> typeToCopy, int weight, int min, int max) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            biome.func_76747_a(typeToCopy.func_220339_d()).stream().filter(entry -> entry.field_200702_b == typeToCopy).findFirst().ifPresent(spawnListEntry -> biome.func_76747_a(typeToSpawn.func_220339_d()).add(new Biome.SpawnListEntry(typeToSpawn, weight, min, max)));
        }
    }
}

