/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.OptionalInt;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class SkullSpiritEntity
extends Entity {
    private static final DataParameter<OptionalInt> TARGET_ENTITY_ID = EntityDataManager.func_187226_a(SkullSpiritEntity.class, (IDataSerializer)DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> ATTACHED = EntityDataManager.func_187226_a(SkullSpiritEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private LivingEntity target;
    private int startTick = 15;
    private int attachedTick = 80 + this.field_70146_Z.nextInt(40);

    public SkullSpiritEntity(EntityType<? extends SkullSpiritEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70145_X = true;
    }

    public SkullSpiritEntity(World worldIn, LivingEntity target) {
        this(MBEntityType.SKULL_SPIRIT, worldIn);
        this.setTarget(target);
    }

    public SkullSpiritEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        this(MBEntityType.SKULL_SPIRIT, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(ATTACHED, (Object)false);
    }

    private boolean isAttached() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACHED);
    }

    private void attach(boolean flag) {
        this.field_70180_af.func_187227_b(ATTACHED, (Object)flag);
    }

    public LivingEntity getTarget() {
        OptionalInt optionalInt = (OptionalInt)this.field_70180_af.func_187225_a(TARGET_ENTITY_ID);
        if (!optionalInt.isPresent()) {
            return null;
        }
        Entity entity = this.field_70170_p.func_73045_a(optionalInt.getAsInt());
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    private void setTarget(LivingEntity target) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY_ID, (Object)OptionalInt.of(target.func_145782_y()));
    }

    public boolean func_145773_az() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target == null) {
            this.target = this.getTarget();
        }
        if (this.target != null && this.target.func_70089_S()) {
            if (this.isAttached()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.target.func_213293_j((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), this.target.func_213322_ci().field_72448_b, (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f));
                    if (--this.attachedTick <= 0) {
                        MobEntity mutant = ChemicalXEntity.getMutantOf(this.target);
                        if (mutant != null && this.field_70146_Z.nextFloat() < 0.75f) {
                            this.target.func_70107_b(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
                            this.target.func_70106_y();
                            MutatedExplosion.create(this, 2.0f, false, Explosion.Mode.NONE);
                            mutant.func_110163_bv();
                            mutant.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                            this.field_70170_p.func_217376_c((Entity)mutant);
                            AxisAlignedBB bb = mutant.func_174813_aQ().func_186662_g(1.0);
                            for (BlockPos pos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)bb.field_72340_a), (int)MathHelper.func_76128_c((double)mutant.func_226278_cu_()), (int)MathHelper.func_76128_c((double)bb.field_72339_c), (int)MathHelper.func_76128_c((double)bb.field_72336_d), (int)MathHelper.func_76128_c((double)bb.field_72337_e), (int)MathHelper.func_76128_c((double)bb.field_72334_f))) {
                                BlockState blockState = this.field_70170_p.func_180495_p(pos);
                                if (!blockState.func_185904_a().func_76220_a() || BlockTags.field_219755_X.func_199685_a_((Object)blockState.func_177230_c())) continue;
                                this.field_70170_p.func_217377_a(pos, false);
                            }
                            for (ServerPlayerEntity serverplayerentity : this.field_70170_p.func_217357_a(ServerPlayerEntity.class, bb.func_186662_g(5.0))) {
                                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)mutant);
                            }
                        } else {
                            MutatedExplosion.create(this, 2.0f, false, Explosion.Mode.NONE);
                            this.target.func_70097_a(DamageSource.func_188405_b((LivingEntity)null), Float.MAX_VALUE);
                        }
                        this.func_70106_y();
                    }
                }
                this.func_70107_b(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
                if (this.field_70146_Z.nextInt(8) == 0) {
                    this.target.func_70097_a(DamageSource.field_76376_m, 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = this.target.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.target.func_213311_cf() * 2.0f) - (double)this.target.func_213311_cf();
                    double posY = this.target.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.target.func_213302_cg());
                    double posZ = this.target.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.target.func_213311_cf() * 2.0f) - (double)this.target.func_213311_cf();
                    double x = this.field_70146_Z.nextGaussian() * 0.02;
                    double y = this.field_70146_Z.nextGaussian() * 0.02;
                    double z = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.SKULL_SPIRIT, posX, posY, posZ, x, y, z);
                }
            } else {
                this.field_70169_q = this.func_226277_ct_();
                this.field_70167_r = this.func_226278_cu_();
                this.field_70166_s = this.func_226281_cx_();
                this.func_213293_j(0.0, 0.0, 0.0);
                if (this.startTick-- >= 0) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(0.3f * (float)this.startTick / 15.0f), 0.0));
                }
                double x = this.target.func_226277_ct_() - this.func_226277_ct_();
                double y = this.target.func_226278_cu_() - this.func_226278_cu_();
                double z = this.target.func_226281_cx_() - this.func_226281_cx_();
                double d = Math.sqrt(x * x + y * y + z * z);
                this.func_213317_d(this.func_213322_ci().func_72441_c(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (!this.field_70170_p.field_72995_K && this.func_70068_e((Entity)this.target) < 1.0) {
                    this.attach(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    float yy = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    float zz = (this.field_70146_Z.nextFloat() - 0.5f) * 1.2f;
                    this.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.SKULL_SPIRIT, this.func_226277_ct_() + (double)xx, this.func_226278_cu_() + (double)yy, this.func_226281_cx_() + (double)zz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_82150_aj() {
        return true;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("Attached", this.isAttached());
        compound.func_74768_a("AttachedTick", this.attachedTick);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.attach(compound.func_74767_n("Attached"));
        this.attachedTick = compound.func_74762_e("AttachedTick");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

