/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEggEntity;
import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import chumbanotz.mutantbeasts.util.MutatedExplosion;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MutantCreeperEntity
extends CreeperEntity {
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MutantCreeperEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_CHARGE_TIME = 100;
    public static final int MAX_DEATH_TIME = 100;
    private int chargeTime;
    private int chargeHits;
    private boolean canSummonLightning;
    private DamageSource deathCause;

    public MutantCreeperEntity(EntityType<? extends MutantCreeperEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new JumpAttackGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SpawnMinionsGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.3));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 100, true, true, EntityUtil::isFeline));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(120.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(4.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATUS, (Object)0);
    }

    public boolean func_225509_J__() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    private void setCharged(boolean charged) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isJumpAttacking() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 2) != 0;
    }

    private void setJumpAttacking(boolean jumping) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(jumping ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    public boolean isCharging() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 4) != 0;
    }

    private void setCharging(boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.6f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        double x = entityIn.func_226277_ct_() - this.func_226277_ct_();
        double y = entityIn.func_226278_cu_() - this.func_226278_cu_();
        double z = entityIn.func_226281_cx_() - this.func_226281_cx_();
        double d = Math.sqrt(x * x + y * y + z * z);
        entityIn.func_70024_g(x / d * 0.5, y / d * 0.2, z / d * 0.5);
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_225509_J__() && source.func_76347_k()) {
            this.func_70066_B();
            return false;
        }
        if (source.func_94541_c()) {
            float healAmount = amount / 2.0f;
            if (!(source.func_76346_g() instanceof MutantCreeperEntity) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(healAmount);
                if (this.field_70170_p instanceof ServerWorld) {
                    for (int i = 0; i < (int)(healAmount / 2.0f); ++i) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0, d0, d1, d2, 1.0);
                    }
                }
            }
            return true;
        }
        if (this.isCharging()) {
            if (!source.func_82725_o() && source.func_76364_f() instanceof LivingEntity) {
                source.func_76364_f().func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76348_h(), 2.0f);
            }
            if (!this.field_70170_p.field_72995_K && amount > 0.0f && source.func_76364_f() != null && super.func_70097_a(source, amount)) {
                --this.chargeHits;
            }
        }
        return !(source.func_76346_g() instanceof CreeperEntity) && super.func_70097_a(source, amount);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        this.setCharged(true);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_213623_ec() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            this.field_70737_aN = 0;
        } else if (id == 6) {
            for (int i = 0; i < 15; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isJumpAttacking() && (this.field_70122_E || this.field_213328_B.func_189985_c() > 0.0 || this.field_70170_p.func_72953_d(this.func_174813_aQ()))) {
            this.setJumpAttacking(false);
            MutatedExplosion.create((Entity)this, this.func_225509_J__() ? 6.0f : 4.0f, false, Explosion.Mode.DESTROY);
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        livingEntity.func_70108_f((Entity)this);
        livingEntity.field_70133_I = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70831_j(float partialTicks) {
        float f = (float)this.field_70725_aQ / 100.0f;
        if (this.isCharging()) {
            f = this.field_70173_aa % 20 < 10 ? 0.6f : 0.0f;
        }
        return f;
    }

    public void func_70645_a(DamageSource cause) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)0);
        if (!this.field_70170_p.field_72995_K) {
            this.deathCause = cause;
            this.setCharging(false);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_217384_a(null, (Entity)this, MBSoundEvents.ENTITY_MUTANT_CREEPER_DEATH, this.func_184176_by(), 2.0f, 1.0f);
            }
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 100;
            }
        }
    }

    protected void func_70609_aI() {
        float power = this.func_225509_J__() ? 12.0f : 8.0f;
        float radius = power * 1.5f;
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g((double)radius), EntityPredicates.field_188444_d)) {
            double x = this.func_226277_ct_() - entity.func_226277_ct_();
            double y = this.func_226278_cu_() - entity.func_226278_cu_();
            double z = this.func_226281_cx_() - entity.func_226281_cx_();
            double d = Math.sqrt(x * x + y * y + z * z);
            float scale = (float)this.field_70725_aQ / 100.0f;
            entity.func_70024_g(x / d * (double)scale * 0.09, y / d * (double)scale * 0.09, z / d * (double)scale * 0.09);
        }
        this.func_70107_b(this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f, this.func_226278_cu_(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 0.2f) - (double)0.1f);
        if (!this.field_70170_p.func_226664_a_(this.func_174813_aQ())) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        if (++this.field_70725_aQ >= 100) {
            if (!this.field_70170_p.field_72995_K) {
                MutatedExplosion.create((Entity)this, power, this.func_70027_ad(), Explosion.Mode.DESTROY);
                EntityUtil.spawnLingeringCloud((LivingEntity)this);
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e) && this.field_70717_bb != null) {
                    CreeperMinionEggEntity egg = new CreeperMinionEggEntity(this.field_70170_p, (Entity)this.field_70717_bb);
                    egg.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                    this.field_70170_p.func_217376_c((Entity)egg);
                }
            }
            super.func_70645_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j);
            this.func_70106_y();
        }
    }

    public boolean func_70650_aV() {
        return this.func_225509_J__();
    }

    @Deprecated
    public int func_70832_p() {
        return -1;
    }

    protected void func_180466_bG(Tag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.04, 0.0));
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, IFluidState fluidState, float resistance) {
        return this.func_225509_J__() && !BlockTags.field_219755_X.func_199685_a_((Object)blockStateIn.func_177230_c()) ? Math.min(0.8f, resistance) : resistance;
    }

    public void func_70642_aH() {
        if (this.func_70638_az() == null) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_CREEPER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("JumpAttacking", this.isJumpAttacking());
        compound.func_74757_a("Charging", this.isCharging());
        compound.func_74768_a("ChargeTime", this.chargeTime);
        compound.func_74768_a("ChargeHits", this.chargeHits);
        compound.func_74757_a("SummonLightning", this.canSummonLightning);
        if (this.func_225509_J__()) {
            compound.func_74757_a("Powered", true);
        }
        for (String s : new String[]{"powered", "Fuse", "ExplosionRadius", "ignited"}) {
            compound.func_82580_o(s);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCharged(compound.func_74767_n("powered") || compound.func_74767_n("Powered"));
        this.setJumpAttacking(compound.func_74767_n("JumpAttacking"));
        this.setCharging(compound.func_74767_n("Charging"));
        this.chargeTime = compound.func_74762_e("ChargeTime");
        this.chargeHits = compound.func_74762_e("ChargeHits");
        this.canSummonLightning = compound.func_74767_n("SummonLightning");
    }

    class JumpAttackGoal
    extends Goal {
        JumpAttackGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity target = MutantCreeperEntity.this.func_70638_az();
            return target != null && MutantCreeperEntity.this.func_70068_e((Entity)target) <= 1024.0 && (MutantCreeperEntity.this.field_70122_E || MutantCreeperEntity.this.field_213328_B.func_189985_c() > 0.0) && !MutantCreeperEntity.this.isCharging() ? MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.9f : MutantCreeperEntity.this.func_70094_T() && MutantCreeperEntity.this.field_70173_aa % 30 == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.field_213328_B = Vec3d.field_186680_a;
            MutantCreeperEntity.this.setJumpAttacking(true);
            MutantCreeperEntity.this.func_213293_j((MutantCreeperEntity.this.func_70638_az().func_226277_ct_() - MutantCreeperEntity.this.func_226277_ct_()) * 0.2, 1.4, (MutantCreeperEntity.this.func_70638_az().func_226281_cx_() - MutantCreeperEntity.this.func_226281_cx_()) * 0.2);
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            boolean attemptHeal;
            LivingEntity target = MutantCreeperEntity.this.func_70638_az();
            boolean bl = attemptHeal = !(MutantCreeperEntity.this.func_110138_aP() - MutantCreeperEntity.this.func_110143_aJ() < MutantCreeperEntity.this.func_110138_aP() / 6.0f);
            return target != null && MutantCreeperEntity.this.field_70122_E && attemptHeal && MutantCreeperEntity.this.func_70068_e((Entity)target) >= 25.0 && MutantCreeperEntity.this.func_70068_e((Entity)target) <= 1024.0 ? MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < 0.7f : MutantCreeperEntity.this.isCharging();
        }

        public boolean func_75253_b() {
            if (MutantCreeperEntity.this.canSummonLightning && MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) < 25.0) {
                return false;
            }
            return MutantCreeperEntity.this.chargeTime < 100 && MutantCreeperEntity.this.chargeHits > 0;
        }

        public void func_75249_e() {
            MutantCreeperEntity.this.setCharging(true);
            MutantCreeperEntity.this.field_70699_by.func_75499_g();
            if (MutantCreeperEntity.this.chargeHits == 0) {
                MutantCreeperEntity.this.chargeHits = 3 + MutantCreeperEntity.this.field_70146_Z.nextInt(3);
            }
            if (MutantCreeperEntity.this.field_70146_Z.nextInt(MutantCreeperEntity.this.field_70170_p.func_72911_I() ? 2 : 6) == 0 && !MutantCreeperEntity.this.func_225509_J__()) {
                MutantCreeperEntity.this.canSummonLightning = true;
            }
        }

        public void func_75246_d() {
            int i = MutantCreeperEntity.this.chargeTime % 20;
            if (i == 0 || i == 20) {
                MutantCreeperEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_CREEPER_CHARGE, 0.6f, 0.7f + MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.6f);
            }
            ++MutantCreeperEntity.this.chargeTime;
        }

        public void func_75251_c() {
            if (MutantCreeperEntity.this.canSummonLightning && MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) < 25.0 && MutantCreeperEntity.this.field_70170_p.func_226660_f_(MutantCreeperEntity.this.func_180425_c())) {
                ((ServerWorld)MutantCreeperEntity.this.field_70170_p).func_217468_a(new LightningBoltEntity(MutantCreeperEntity.this.field_70170_p, MutantCreeperEntity.this.func_226277_ct_(), MutantCreeperEntity.this.func_226278_cu_(), MutantCreeperEntity.this.func_226281_cx_(), false));
            } else if (MutantCreeperEntity.this.chargeTime >= 100) {
                MutantCreeperEntity.this.func_70691_i(30.0f);
                MutantCreeperEntity.this.field_70170_p.func_72960_a((Entity)MutantCreeperEntity.this, (byte)6);
            }
            MutantCreeperEntity.this.chargeTime = 0;
            MutantCreeperEntity.this.chargeHits = 4 + MutantCreeperEntity.this.field_70146_Z.nextInt(3);
            MutantCreeperEntity.this.setCharging(false);
            MutantCreeperEntity.this.canSummonLightning = false;
        }
    }

    class SpawnMinionsGoal
    extends Goal {
        SpawnMinionsGoal() {
        }

        public boolean func_75250_a() {
            float chance = !MutantCreeperEntity.this.func_70781_l() || MutantCreeperEntity.this.func_189748_bU() != null && MutantCreeperEntity.this.func_189748_bU().func_76352_a() ? 2.5f : 0.6f;
            return MutantCreeperEntity.this.func_70638_az() != null && MutantCreeperEntity.this.func_70068_e((Entity)MutantCreeperEntity.this.func_70638_az()) <= 1024.0 && !MutantCreeperEntity.this.isCharging() && !MutantCreeperEntity.this.isJumpAttacking() && MutantCreeperEntity.this.field_70146_Z.nextFloat() * 100.0f < chance;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            int maxSpawn = MutantCreeperEntity.this.field_70170_p.func_175659_aa().func_151525_a() * 2;
            for (int i = (int)Math.ceil((double)MutantCreeperEntity.this.func_110143_aJ() / (double)MutantCreeperEntity.this.func_110138_aP() * (double)maxSpawn); i > 0; --i) {
                CreeperMinionEntity creeper = (CreeperMinionEntity)MBEntityType.CREEPER_MINION.func_200721_a(MutantCreeperEntity.this.field_70170_p);
                double x = MutantCreeperEntity.this.func_226277_ct_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double y = MutantCreeperEntity.this.func_226278_cu_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.5f);
                double z = MutantCreeperEntity.this.func_226281_cx_() + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() - MutantCreeperEntity.this.field_70146_Z.nextFloat());
                double xx = MutantCreeperEntity.this.func_70638_az().func_226277_ct_() - MutantCreeperEntity.this.func_226277_ct_();
                double yy = MutantCreeperEntity.this.func_70638_az().func_226278_cu_() - MutantCreeperEntity.this.func_226278_cu_();
                double zz = MutantCreeperEntity.this.func_70638_az().func_226281_cx_() - MutantCreeperEntity.this.func_226281_cx_();
                creeper.func_213293_j(xx * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f), yy * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f), zz * 0.15 + (double)(MutantCreeperEntity.this.field_70146_Z.nextFloat() * 0.05f));
                creeper.func_70012_b(x, y, z, MutantCreeperEntity.this.field_70177_z, MutantCreeperEntity.this.field_70125_A);
                creeper.func_184754_b(MutantCreeperEntity.this.field_96093_i);
                creeper.func_70624_b(MutantCreeperEntity.this.func_70638_az());
                creeper.setPowered(MutantCreeperEntity.this.func_225509_J__());
                MutantCreeperEntity.this.field_70170_p.func_217376_c((Entity)creeper);
            }
        }
    }
}

