/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.entity.EndersoulFragmentEntity;
import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBHurtByTargetGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.MBMeleeAttackGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.packet.HeldBlockPacket;
import chumbanotz.mutantbeasts.packet.PacketHandler;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.EntityUtil;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantEndermanEntity
extends MonsterEntity {
    private static final DataParameter<Optional<BlockPos>> TELEPORT_POSITION = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> CLONER_ENTITY_ID = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> ACTIVE_ARM = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> CLONE_STATE = EntityDataManager.func_187226_a(MutantEndermanEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final int MAX_DEATH_TIME = 280;
    public static final byte MELEE_ATTACK = 4;
    public static final byte THROW_ATTACK = 5;
    public static final byte STARE_ATTACK = 6;
    public static final byte TELEPORT_ATTACK = 7;
    public static final byte SCREAM_ATTACK = 8;
    public static final byte CLONE_ATTACK = 9;
    public static final byte TELESMASH_ATTACK = 10;
    public static final byte DEATH_ATTACK = 11;
    private int attackID;
    private int attackTick;
    private int prevArmScale;
    private int armScale;
    public int hasTarget;
    private int screamDelayTick;
    public final int[] heldBlock = new int[5];
    public final int[] heldBlockTick = new int[5];
    private boolean triggerThrowBlock;
    private int blockSearchTick;
    private List<MutantEndermanEntity> cloneList;
    private List<Entity> deathEntities;
    private int dirty = -1;
    private DamageSource deathCause;

    public MutantEndermanEntity(EntityType<? extends MutantEndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 40;
        this.field_70138_W = 2.5f;
        this.cloneList = new ArrayList<MutantEndermanEntity>();
        this.field_70158_ak = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowHeldBlockGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ForcedLookGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ScreamGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new CloneGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleSmashGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MBMeleeAttackGoal((CreatureEntity)this, 1.2).setMaxAttackTick(15));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MBHurtByTargetGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new TargetLookerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, e -> ((EndermiteEntity)e).func_175495_n()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(96.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORT_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(CLONER_ENTITY_ID, (Object)-1);
        this.field_70180_af.func_187214_a(ACTIVE_ARM, (Object)0);
        this.field_70180_af.func_187214_a(CLONE_STATE, (Object)0);
    }

    @Nullable
    public BlockPos getTeleportPosition() {
        return ((Optional)this.field_70180_af.func_187225_a(TELEPORT_POSITION)).orElse(null);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public int getActiveArm() {
        return ((Byte)this.field_70180_af.func_187225_a(ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.field_70180_af.func_187227_b(ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Byte)this.field_70180_af.func_187225_a(CLONE_STATE) > 0;
    }

    public boolean isDecoyClone() {
        return (Byte)this.field_70180_af.func_187225_a(CLONE_STATE) > 1;
    }

    private void setCloneState(int newState) {
        byte currentState = (Byte)this.field_70180_af.func_187225_a(CLONE_STATE);
        if (currentState == newState) {
            return;
        }
        if (currentState == 1 && newState == 0) {
            for (MutantEndermanEntity clone : this.cloneList) {
                if (clone == null || !clone.func_70089_S() && !clone.isAddedToWorld()) continue;
                clone.func_70609_aI();
            }
            this.cloneList.clear();
            this.spawnTeleportParticles(true);
            this.field_70699_by.func_75499_g();
        }
        this.field_70180_af.func_187227_b(CLONE_STATE, (Object)((byte)newState));
        this.setAttackID(newState > 0 ? 9 : 0);
    }

    public int getAttackID() {
        return this.attackID;
    }

    private void setAttackID(int attackID) {
        this.attackID = attackID;
        this.field_70170_p.func_72960_a((Entity)this, (byte)attackID);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.isClone() ? 2.55f : 3.9f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isClone() ? EntitySize.func_220314_b((float)0.6f, (float)2.9f) : super.func_213305_a(poseIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public int func_82143_as() {
        return this.isClone() ? 3 : super.func_82143_as();
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && this.attackID != 7;
    }

    protected void func_213623_ec() {
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (CLONE_STATE.equals(key)) {
            this.func_213323_x_();
        }
        if (TELEPORT_POSITION.equals(key) && this.getTeleportPosition() != null && this.field_70170_p.field_72995_K) {
            this.attackID = 7;
            this.attackTick = 0;
            this.spawnBigParticles();
        }
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.func_213395_q(entitylivingbaseIn != null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getArmScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        int i;
        this.prevArmScale = this.armScale;
        if (this.func_213398_dR()) {
            this.hasTarget = 20;
        }
        boolean emptyHanded = true;
        for (i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] > 0) {
                emptyHanded = false;
            }
            if (this.hasTarget > 0) {
                if (this.heldBlock[i] <= 0) continue;
                this.heldBlockTick[i] = Math.min(10, this.heldBlockTick[i] + 1);
                continue;
            }
            this.heldBlockTick[i] = Math.max(0, this.heldBlockTick[i] - 1);
        }
        if (this.hasTarget > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else if (!this.field_70170_p.field_72995_K) {
            for (i = 1; i < this.heldBlock.length; ++i) {
                int z;
                int y;
                if (this.heldBlock[i] == 0 || this.heldBlockTick[i] != 0) continue;
                int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0));
                BlockPos blockPos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 2.5)), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() - 1.5 + this.field_70146_Z.nextDouble() * 4.0)));
                if (this.field_70170_p.func_175623_d(blockPos) && !this.field_70170_p.func_175623_d(blockPos.func_177977_b()) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                    this.field_70170_p.func_175656_a(blockPos, Block.func_196257_b((int)this.heldBlock[i]));
                    this.sendHoldBlock(i, 0);
                    continue;
                }
                this.triggerThrowBlock = true;
            }
        }
        this.hasTarget = Math.max(0, this.hasTarget - 1);
    }

    private void updateScreamEntities() {
        this.screamDelayTick = Math.max(0, this.screamDelayTick - 1);
        if (this.attackID == 8 && this.attackTick >= 40 && this.attackTick <= 160) {
            for (LivingEntity livingEntity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET)) {
                if (!(this.func_70068_e((Entity)livingEntity) < 400.0)) continue;
                livingEntity.field_70125_A += (this.field_70146_Z.nextFloat() - 0.3f) * 6.0f;
            }
        }
    }

    private void spawnTeleportParticles(boolean clone) {
        if (clone && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 2.0, this.func_226281_cx_(), MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, this.func_184176_by(), 1.0f, 1.0f);
        }
        this.field_70170_p.func_72960_a((Entity)this, clone ? (byte)12 : 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.spawnBigParticles();
        } else if (id == 12) {
            EntityUtil.spawnLargePortalParticles((Entity)this, 256, 1.8f, false);
        } else if (id == 0 || id >= 4 && id <= 11) {
            this.attackID = id;
            this.attackTick = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        boolean targetBlind;
        super.func_70636_d();
        if (this.attackID != 0) {
            ++this.attackTick;
        }
        if (this.func_70089_S() && this.field_70173_aa % 100 == 0 && this.field_71093_bK == DimensionType.field_223229_c_ && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        double h = this.attackID != 11 ? (double)this.func_213302_cg() : (double)(this.func_213302_cg() + 1.0f);
        double w = this.attackID != 11 ? (double)this.func_213311_cf() : (double)(this.func_213311_cf() * 1.5f);
        boolean bl = targetBlind = this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76440_q);
        if (!targetBlind && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * w;
                double y = this.func_226278_cu_() + this.field_70146_Z.nextDouble() * h - 0.25;
                double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * w;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateDirtyHands() {
        if (this.dirty >= 0) {
            ++this.dirty;
        }
        if (this.dirty >= 8) {
            this.dirty = -1;
            for (int i = 1; i < this.heldBlock.length; ++i) {
                if (this.heldBlock[i] <= 0) continue;
                this.sendHoldBlock(i, this.heldBlock[i]);
            }
        }
    }

    private void updateBlockFrenzy() {
        this.blockSearchTick = Math.max(0, this.blockSearchTick - 1);
        if (this.func_70638_az() != null && this.attackID == 0) {
            if (this.blockSearchTick == 0 && this.field_70146_Z.nextInt(!this.func_70781_l() ? 300 : 600) == 0) {
                this.blockSearchTick = 200 + this.field_70146_Z.nextInt(80);
            }
            if (this.blockSearchTick > 0 && this.field_70146_Z.nextInt(8) == 0) {
                int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0));
                int y = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 0.5 + this.field_70146_Z.nextDouble() * 3.0));
                int z = MathHelper.func_76128_c((double)(this.func_226281_cx_() - 2.5 + this.field_70146_Z.nextDouble() * 5.0));
                int index = this.getFavorableHand();
                BlockPos pos = new BlockPos(x, y, z);
                if (index != -1 && this.field_70170_p.func_180495_p(pos).func_203425_a(MutantBeasts.THROWABLE_BLOCKS)) {
                    this.sendHoldBlock(index, Block.func_196246_j((BlockState)this.field_70170_p.func_180495_p(pos)));
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        this.field_70170_p.func_217377_a(pos, false);
                    }
                }
            }
        }
    }

    private void updateTeleport() {
        LivingEntity entity = this.func_70638_az();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (entity != null && this.func_70068_e((Entity)entity) > 1024.0) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void func_70619_bc() {
        if (this.func_203008_ap() && this.field_70173_aa % 100 == 0 && !this.isClone()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        this.updateDirtyHands();
        this.updateBlockFrenzy();
        this.updateTeleport();
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.field_70146_Z.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] != 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 1; i < this.heldBlock.length; ++i) {
            if (this.heldBlock[i] == 0) continue;
            if (i <= 2) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.field_70146_Z.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.field_70146_Z.nextInt(outer.size()));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.attackID == 0) {
            int i = this.getAvailableHand();
            if (!this.teleportByChance(6, entityIn)) {
                if (i != -1) {
                    boolean allHandsFree;
                    boolean bl = allHandsFree = this.heldBlock[1] == 0 && this.heldBlock[2] == 0;
                    if (allHandsFree && this.field_70146_Z.nextInt(10) == 0) {
                        this.setCloneState(1);
                    } else if (allHandsFree && this.field_70146_Z.nextInt(7) == 0) {
                        this.setAttackID(10);
                    } else {
                        this.setActiveArm(i);
                        this.setAttackID(4);
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            boolean flag = super.func_70652_k(entityIn);
            if (!this.field_70170_p.field_72995_K && this.isDecoyClone() ? this.field_70146_Z.nextInt(3) != 0 : this.field_70146_Z.nextInt(2) == 0) {
                double x = entityIn.func_226277_ct_() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                double z = entityIn.func_226281_cx_() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                double y = entityIn.func_226278_cu_() + (double)this.field_70146_Z.nextInt(5) + 4.0;
                this.teleportTo(x, y, z);
            }
            if (flag) {
                this.func_70691_i(2.0f);
            }
            return flag;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!(source.func_76346_g() instanceof EnderDragonEntity) && !(source.func_76346_g() instanceof MutantEndermanEntity)) {
            if ((this.attackID == 7 || this.attackID == 8) && source != DamageSource.field_76380_i) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.isClone()) {
                    if (this.isDecoyClone()) {
                        amount = 1.0f;
                        this.func_70609_aI();
                    } else {
                        this.setCloneState(0);
                    }
                } else {
                    boolean betterDodge;
                    Entity entity = source.func_76346_g();
                    if (this.attackID == 6) {
                        this.attackTick = 100;
                    }
                    boolean bl = betterDodge = entity == null;
                    if (source.func_76352_a() || source == DamageSource.field_76379_h) {
                        betterDodge = true;
                    }
                    if (this.teleportByChance(betterDodge ? 3 : 6, entity) && source != DamageSource.field_76380_i) {
                        if (entity != null && entity instanceof LivingEntity) {
                            this.func_70604_c((LivingEntity)entity);
                        }
                        return false;
                    }
                    boolean betterTeleport = source == DamageSource.field_76369_e || source == DamageSource.field_180137_b;
                    this.teleportByChance(betterTeleport ? 3 : 5, entity);
                }
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return !this.isClone() && super.func_195064_c(effectInstanceIn);
    }

    private boolean teleportByChance(int chance, Entity entity) {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        if (this.field_70146_Z.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt((int)radius * 2) - radius;
        double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportTo(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.attackID != 0 && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.func_70068_e(entity) < 100.0) {
            x = entity.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.func_226278_cu_() + this.field_70146_Z.nextDouble() * radius;
            z = entity.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vec3d vec = new Vec3d(this.func_226277_ct_() - entity.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)this.func_213302_cg() / 2.0 - entity.func_226278_cu_() + (double)entity.func_70047_e(), this.func_226281_cx_() - entity.func_226281_cx_());
            vec = vec.func_72432_b();
            x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * radius;
            y = this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(8) - vec.field_72448_b * radius;
            z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * radius;
        }
        return this.teleportTo(x, y, z);
    }

    private boolean teleportTo(double targetX, double targetY, double targetZ) {
        if (this.func_175446_cd() || !this.func_70089_S()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((MobEntity)this, targetX, targetY, targetZ);
            if (flag) {
                this.func_184210_p();
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184134_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, this.func_184176_by(), 1.0f, 1.0f, false);
                    this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.attackID == 0) {
            this.attackID = 7;
            double oldX = this.func_226277_ct_();
            double oldY = this.func_226278_cu_();
            double oldZ = this.func_226281_cx_();
            double newY = targetY;
            BlockPos pos = new BlockPos(targetX, targetY, targetZ);
            boolean success = false;
            if (this.field_70170_p.func_195588_v(pos)) {
                boolean temp = false;
                while (!temp && pos.func_177956_o() > 0) {
                    BlockPos posDown = pos.func_177977_b();
                    if (this.field_70170_p.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                        temp = true;
                        continue;
                    }
                    newY -= 1.0;
                    pos = posDown;
                }
                if (temp) {
                    this.func_70107_b(targetX, newY, targetZ);
                    if (this.field_70170_p.func_226669_j_((Entity)this) && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                        success = true;
                    }
                }
            }
            this.func_70107_b(oldX, oldY, oldZ);
            if (!success) {
                this.attackID = 0;
                return false;
            }
            this.func_184210_p();
            this.setTeleportPosition(pos);
            return true;
        }
        return false;
    }

    public static void teleportAttack(LivingEntity attacker) {
        double r = 3.0;
        int duration = 140 + attacker.func_70681_au().nextInt(60);
        DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)attacker);
        if (attacker instanceof PlayerEntity) {
            r = 2.0;
            duration = 100;
            damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
        }
        for (Entity entity : attacker.field_70170_p.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_186662_g(r), EndersoulFragmentEntity.IS_VALID_TARGET)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.func_70097_a(damageSource, 4.0f);
            if (attacker.func_70681_au().nextInt(3) == 0) {
                living.func_195064_c(new EffectInstance(Effects.field_76440_q, duration));
            }
            double x = entity.func_226277_ct_() - attacker.func_226277_ct_();
            double z = entity.func_226281_cx_() - attacker.func_226281_cx_();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            living.func_213293_j((r * signX * 2.0 - x) * (double)0.2f, (double)0.2f, (r * signZ * 2.0 - z) * (double)0.2f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnBigParticles() {
        int temp = 256;
        if (this.attackID == 7) {
            temp *= 2;
        }
        for (int i = 0; i < temp; ++i) {
            boolean flag;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.8f;
            boolean bl = flag = i < temp / 2;
            if (this.attackID != 7) {
                flag = true;
            }
            boolean death = this.attackID != 11;
            double h = death ? (double)this.func_213302_cg() : (double)(this.func_213302_cg() + 1.0f);
            double w = death ? (double)this.func_213311_cf() : (double)(this.func_213311_cf() * 1.5f);
            double tempX = (flag ? this.func_226277_ct_() : (double)this.getTeleportPosition().func_177958_n()) + (this.field_70146_Z.nextDouble() - 0.5) * w;
            double tempY = (flag ? this.func_226278_cu_() : (double)this.getTeleportPosition().func_177956_o()) + (this.field_70146_Z.nextDouble() - 0.5) * h + (double)(death ? 1.5f : 0.5f);
            double tempZ = (flag ? this.func_226281_cx_() : (double)this.getTeleportPosition().func_177952_p()) + (this.field_70146_Z.nextDouble() - 0.5) * w;
            this.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.LARGE_PORTAL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public MutantEndermanEntity getCloner() {
        return (MutantEndermanEntity)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(CLONER_ENTITY_ID)).intValue());
    }

    private void createClone(double x, double y, double z) {
        MutantEndermanEntity clone = (MutantEndermanEntity)MBEntityType.MUTANT_ENDERMAN.func_200721_a(this.field_70170_p);
        clone.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        clone.field_70180_af.func_187227_b(CLONER_ENTITY_ID, (Object)this.func_145782_y());
        clone.func_70624_b(clone.getCloner().func_70638_az());
        clone.field_70728_aV = this.field_70146_Z.nextInt(2);
        clone.field_70138_W = 1.0f;
        EntityUtil.copyNBT((Entity)this, (Entity)clone, false);
        clone.setCloneState(2);
        clone.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        if (clone.teleportTo(x, y, z)) {
            this.field_70170_p.func_217376_c((Entity)clone);
            this.cloneList.add(clone);
        }
    }

    private MutantEndermanEntity getRandomClone() {
        if (this.cloneList.isEmpty()) {
            return this;
        }
        return this.cloneList.get(this.field_70146_Z.nextInt(this.cloneList.size()));
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_213371_e(LivingEntity livingEntity) {
        if (!this.isClone()) {
            livingEntity.func_70108_f((Entity)this);
            livingEntity.field_70133_I = true;
        }
    }

    @Nullable
    public Team func_96124_cp() {
        MutantEndermanEntity cloner = this.getCloner();
        return cloner != null ? cloner.func_96124_cp() : super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        MutantEndermanEntity cloner = this.getCloner();
        return cloner == entityIn || cloner != null && cloner.func_184191_r(entityIn) || super.func_184191_r(entityIn);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && !this.isDecoyClone()) {
            this.deathCause = cause;
            if (this.field_70718_bc > 0) {
                this.field_70718_bc += 280;
            }
        }
    }

    protected void func_70609_aI() {
        if (this.isDecoyClone()) {
            this.spawnTeleportParticles(true);
            super.func_226294_cV_();
            this.func_70106_y();
        } else {
            ++this.field_70725_aQ;
            this.func_213293_j(0.0, Math.min(this.func_213322_ci().field_72448_b, 0.0), 0.0);
            if (this.attackID != 11) {
                this.setAttackID(11);
            }
            if (this.field_70725_aQ == 80) {
                this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH, 5.0f, this.func_70647_i());
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70725_aQ >= 60 && this.field_70725_aQ < 80 && this.deathEntities == null) {
                    this.deathEntities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(10.0, 8.0, 10.0), EndersoulFragmentEntity.IS_VALID_TARGET);
                }
                if (this.field_70725_aQ >= 60 && this.field_70146_Z.nextInt(3) != 0) {
                    EndersoulFragmentEntity orb = new EndersoulFragmentEntity(this.field_70170_p, this);
                    orb.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 3.8, this.func_226281_cx_());
                    orb.func_213293_j((this.field_70146_Z.nextFloat() - 0.5f) * 1.5f, (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f, (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f);
                    this.field_70170_p.func_217376_c((Entity)orb);
                }
                if (this.field_70725_aQ >= 80 && this.field_70725_aQ < 260 && this.deathEntities != null) {
                    for (int i = 0; i < this.deathEntities.size(); ++i) {
                        Entity entity = this.deathEntities.get(i);
                        if (entity.field_70143_R > 4.5f) {
                            entity.field_70143_R = 4.5f;
                        }
                        if (!(this.func_70068_e(entity) > 64.0)) continue;
                        if (EndersoulFragmentEntity.isProtected(entity) || !entity.func_70089_S()) {
                            this.deathEntities.remove(entity);
                            continue;
                        }
                        double x = this.func_226277_ct_() - entity.func_226277_ct_();
                        double y = entity.func_213322_ci().field_72448_b;
                        double z = this.func_226281_cx_() - entity.func_226281_cx_();
                        double d = Math.sqrt(x * x + z * z);
                        if (this.func_226278_cu_() + 4.0 > entity.func_226278_cu_()) {
                            y = Math.max(entity.func_213322_ci().field_72448_b, (double)0.4f);
                        }
                        entity.func_213293_j((double)0.8f * x / d, y, (double)0.8f * z / d);
                        EntityUtil.sendPlayerVelocityPacket(entity);
                    }
                }
                if (this.field_70725_aQ >= 100 && this.field_70725_aQ < 150 && this.field_70725_aQ % 6 == 0) {
                    this.func_213345_d(this.deathCause == null ? DamageSource.field_76377_j : this.deathCause);
                }
            }
            if (this.field_70725_aQ >= 280) {
                super.func_70645_a(this.deathCause == null ? DamageSource.field_76377_j : this.deathCause);
                this.func_226294_cV_();
                this.func_70106_y();
            }
        }
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        if (this.field_70725_aQ < 280) {
            super.func_213345_d(damageSourceIn);
        }
    }

    protected void func_226294_cV_() {
        if (this.field_70725_aQ >= 280) {
            super.func_226294_cV_();
        }
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        return this.func_70099_a(stack, this.field_70725_aQ > 0 ? 3.84f : 0.0f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            return false;
        }
        if (worldIn.func_201675_m().func_186058_p() == DimensionType.field_223229_c_ && this.field_70146_Z.nextInt(2600) != 0) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("CloneState", ((Byte)this.field_70180_af.func_187225_a(CLONE_STATE)).byteValue());
        compound.func_74777_a("ScreamDelay", (short)this.screamDelayTick);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        byte b0 = compound.func_74771_c("CloneState");
        if (b0 < 2) {
            this.setCloneState(0);
        } else {
            this.func_70106_y();
        }
        this.screamDelayTick = compound.func_74765_d("ScreamDelay");
    }

    public int func_70627_aG() {
        return 200;
    }

    public void func_70642_aH() {
        if (this.attackID != 8 && !this.isClone()) {
            this.func_184185_a(this.func_184639_G(), 1.5f, this.func_70647_i());
        }
    }

    protected SoundEvent func_184639_G() {
        return MBSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isDecoyClone() ? null : MBSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void sendHoldBlock(int blockIndex, int blockId) {
        if (!this.field_70170_p.field_72995_K) {
            this.heldBlock[blockIndex] = blockId;
            this.heldBlockTick[blockIndex] = 0;
            PacketHandler.sendToAllTracking(new HeldBlockPacket(this, blockId, blockIndex), (Entity)this);
        }
    }

    private boolean isBeingLookedAt(LivingEntity target) {
        if (target instanceof MobEntity) {
            return ((MobEntity)target).func_70638_az() == this;
        }
        Vec3d playerVec = target.func_70676_i(1.0f).func_72432_b();
        Vec3d targetVec = new Vec3d(this.func_226277_ct_() - target.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (target.func_226278_cu_() + (double)target.func_70047_e()), this.func_226281_cx_() - target.func_226281_cx_());
        double length = targetVec.func_72433_c();
        double d = playerVec.func_72430_b(targetVec = targetVec.func_72432_b());
        return d > 1.0 - 0.08 / length ? target.func_70685_l((Entity)this) : false;
    }

    class ThrowHeldBlockGoal
    extends Goal {
        ThrowHeldBlockGoal() {
        }

        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.attackID != 0) {
                return false;
            }
            if (!MutantEndermanEntity.this.triggerThrowBlock && MutantEndermanEntity.this.func_70681_au().nextInt(28) != 0) {
                return false;
            }
            if (MutantEndermanEntity.this.func_70638_az() != null && !MutantEndermanEntity.this.func_70685_l((Entity)MutantEndermanEntity.this.func_70638_az())) {
                return false;
            }
            int id = MutantEndermanEntity.this.getThrowingHand();
            if (id == -1) {
                return false;
            }
            MutantEndermanEntity.this.setActiveArm(id);
            return true;
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackID == 5 && MutantEndermanEntity.this.attackTick < 14;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.setAttackID(5);
            int id = MutantEndermanEntity.this.getActiveArm();
            ThrowableBlockEntity block = new ThrowableBlockEntity(MutantEndermanEntity.this.field_70170_p, MutantEndermanEntity.this, id);
            MutantEndermanEntity.this.field_70170_p.func_217376_c((Entity)block);
            MutantEndermanEntity.this.sendHoldBlock(id, 0);
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.setActiveArm(0);
            MutantEndermanEntity.this.triggerThrowBlock = false;
        }
    }

    class TeleSmashGoal
    extends Goal {
        private LivingEntity attackTarget;

        public TeleSmashGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            return this.attackTarget != null && MutantEndermanEntity.this.attackID == 10;
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackID == 10 && MutantEndermanEntity.this.attackTick < 30;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 5));
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76431_k, 160 + this.attackTarget.func_70681_au().nextInt(160), 0));
        }

        public void func_75246_d() {
            if (MutantEndermanEntity.this.attackTick < 20) {
                MutantEndermanEntity.this.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            }
            if (MutantEndermanEntity.this.attackTick == 17) {
                this.attackTarget.func_184210_p();
            }
            if (MutantEndermanEntity.this.attackTick == 18) {
                double x = this.attackTarget.func_226277_ct_() + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                double y = this.attackTarget.func_226278_cu_() + (double)this.attackTarget.func_70681_au().nextFloat() + (this.attackTarget instanceof PlayerEntity ? 13.0 : 7.0);
                double z = this.attackTarget.func_226281_cx_() + (double)((this.attackTarget.func_70681_au().nextFloat() - 0.5f) * 14.0f);
                MutantEndermanEntity.this.field_70170_p.func_184133_a(null, this.attackTarget.func_180425_c(), SoundEvents.field_187539_bB, this.attackTarget.func_184176_by(), 1.2f, 0.9f + this.attackTarget.func_70681_au().nextFloat() * 0.2f);
                this.attackTarget.func_70634_a(x, y, z);
                this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantEndermanEntity.this).func_76348_h(), 6.0f);
                EntityUtil.spawnLargePortalParticles((Entity)this.attackTarget, 256, 1.8f, true);
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            this.attackTarget = null;
        }
    }

    class TeleportGoal
    extends Goal {
        public TeleportGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return MutantEndermanEntity.this.attackID == 7;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.field_70699_by.func_75499_g();
            MutantEndermanEntity.this.func_184210_p();
            if (MutantEndermanEntity.this.func_70638_az() != null) {
                MutantEndermanEntity.this.func_70671_ap().func_75651_a((Entity)MutantEndermanEntity.this.func_70638_az(), 30.0f, 30.0f);
            }
            MutantEndermanEntity.teleportAttack((LivingEntity)MutantEndermanEntity.this);
            MutantEndermanEntity.this.func_70107_b((double)MutantEndermanEntity.this.getTeleportPosition().func_177958_n() + 0.5, MutantEndermanEntity.this.getTeleportPosition().func_177956_o(), (double)MutantEndermanEntity.this.getTeleportPosition().func_177952_p() + 0.5);
            MutantEndermanEntity.this.field_70170_p.func_184148_a(null, MutantEndermanEntity.this.field_70169_q, MutantEndermanEntity.this.field_70167_r + (double)MutantEndermanEntity.this.func_213302_cg() / 2.0, MutantEndermanEntity.this.field_70166_s, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, MutantEndermanEntity.this.func_184176_by(), 1.0f, 1.0f);
            MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            MutantEndermanEntity.teleportAttack((LivingEntity)MutantEndermanEntity.this);
            MutantEndermanEntity.this.func_70107_b(MutantEndermanEntity.this.field_70169_q, MutantEndermanEntity.this.field_70167_r, MutantEndermanEntity.this.field_70166_s);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && MutantEndermanEntity.this.attackTick < 10;
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.func_70107_b((double)MutantEndermanEntity.this.getTeleportPosition().func_177958_n() + 0.5, MutantEndermanEntity.this.getTeleportPosition().func_177956_o(), (double)MutantEndermanEntity.this.getTeleportPosition().func_177952_p() + 0.5);
            MutantEndermanEntity.this.setTeleportPosition(null);
            MutantEndermanEntity.this.field_70169_q = MutantEndermanEntity.this.func_226277_ct_();
            MutantEndermanEntity.this.field_70167_r = MutantEndermanEntity.this.func_226278_cu_();
            MutantEndermanEntity.this.field_70166_s = MutantEndermanEntity.this.func_226281_cx_();
        }
    }

    class ScreamGoal
    extends Goal {
        public ScreamGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.func_70638_az() != null && MutantEndermanEntity.this.attackID == 0) {
                return MutantEndermanEntity.this.screamDelayTick > 0 ? false : MutantEndermanEntity.this.field_70146_Z.nextInt(MutantEndermanEntity.this.func_70026_G() ? 400 : 1200) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackTick < 165;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.setAttackID(8);
            MutantEndermanEntity.this.field_70699_by.func_75499_g();
        }

        public void func_75246_d() {
            if (MutantEndermanEntity.this.attackTick == 40) {
                MutantEndermanEntity.this.field_70170_p.func_72912_H().func_76084_b(false);
                MutantEndermanEntity.this.spawnTeleportParticles(false);
                MutantEndermanEntity.this.func_184185_a(MBSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM, 5.0f, 0.7f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f);
                List screamEntities = MutantEndermanEntity.this.field_70170_p.func_175674_a((Entity)MutantEndermanEntity.this, MutantEndermanEntity.this.func_174813_aQ().func_72314_b(20.0, 12.0, 20.0), EndersoulFragmentEntity.IS_VALID_TARGET);
                for (int i = 0; i < screamEntities.size(); ++i) {
                    Entity entity = (Entity)screamEntities.get(i);
                    double dist = MutantEndermanEntity.this.func_70068_e(entity);
                    if (dist > 400.0) {
                        screamEntities.remove(i);
                        --i;
                        continue;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantEndermanEntity.this).func_76348_h().func_151518_m(), 4.0f);
                    if (!(entity instanceof MobEntity)) continue;
                    MobEntity living = (MobEntity)entity;
                    living.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 3));
                    if (MutantEndermanEntity.this.field_70146_Z.nextInt(2) != 0) {
                        living.func_195064_c(new EffectInstance(Effects.field_76436_u, 120 + MutantEndermanEntity.this.field_70146_Z.nextInt(180), MutantEndermanEntity.this.field_70146_Z.nextInt(2)));
                    }
                    if (MutantEndermanEntity.this.field_70146_Z.nextInt(4) != 0) {
                        living.func_195064_c(new EffectInstance(Effects.field_76437_t, 300 + MutantEndermanEntity.this.field_70146_Z.nextInt(300), MutantEndermanEntity.this.field_70146_Z.nextInt(2)));
                    }
                    if (MutantEndermanEntity.this.field_70146_Z.nextInt(3) != 0) {
                        living.func_195064_c(new EffectInstance(Effects.field_76438_s, 120 + MutantEndermanEntity.this.field_70146_Z.nextInt(60), 10 + MutantEndermanEntity.this.field_70146_Z.nextInt(2)));
                    }
                    if (MutantEndermanEntity.this.field_70146_Z.nextInt(4) == 0) continue;
                    living.func_195064_c(new EffectInstance(Effects.field_76431_k, 120 + MutantEndermanEntity.this.field_70146_Z.nextInt(400), 0));
                }
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            MutantEndermanEntity.this.screamDelayTick = 600;
        }
    }

    class CloneGoal
    extends Goal {
        private LivingEntity attackTarget;

        CloneGoal() {
        }

        public boolean func_75250_a() {
            if (MutantEndermanEntity.this.isDecoyClone() || MutantEndermanEntity.this.func_70638_az() == null) {
                return false;
            }
            if (MutantEndermanEntity.this.heldBlock[1] == 0 && MutantEndermanEntity.this.heldBlock[2] == 0) {
                if (MutantEndermanEntity.this.isClone()) {
                    return true;
                }
                return MutantEndermanEntity.this.attackID == 0 && MutantEndermanEntity.this.field_70146_Z.nextInt(300) == 0;
            }
            return false;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.setCloneState(1);
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            MutantEndermanEntity.this.func_70066_B();
            MutantEndermanEntity.this.func_195061_cb();
            MutantEndermanEntity.this.spawnTeleportParticles(true);
            double x = this.attackTarget.func_226277_ct_() + (double)((MutantEndermanEntity.this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
            double z = this.attackTarget.func_226281_cx_() + (double)((MutantEndermanEntity.this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
            double y = this.attackTarget.func_226278_cu_() + 8.0;
            for (int i = 0; i < 7; ++i) {
                x = this.attackTarget.func_226277_ct_() + (double)((MutantEndermanEntity.this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                z = this.attackTarget.func_226281_cx_() + (double)((MutantEndermanEntity.this.field_70146_Z.nextFloat() - 0.5f) * 24.0f);
                y = this.attackTarget.func_226278_cu_() + 8.0;
                MutantEndermanEntity.this.createClone(x, y, z);
            }
            MutantEndermanEntity.this.createClone(MutantEndermanEntity.this.field_70169_q, MutantEndermanEntity.this.field_70167_r, MutantEndermanEntity.this.field_70166_s);
            MutantEndermanEntity.this.teleportTo(x, y, z);
            EntityUtil.divertAttackers((MobEntity)MutantEndermanEntity.this, (LivingEntity)MutantEndermanEntity.this.getRandomClone());
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.func_70638_az() != null && MutantEndermanEntity.this.func_70638_az().func_70089_S() && !MutantEndermanEntity.this.cloneList.isEmpty() && MutantEndermanEntity.this.isClone() && MutantEndermanEntity.this.attackTick < 600;
        }

        public void func_75246_d() {
            for (int i = MutantEndermanEntity.this.cloneList.size() - 1; i >= 0; --i) {
                MutantEndermanEntity clone = (MutantEndermanEntity)((Object)MutantEndermanEntity.this.cloneList.get(i));
                if (clone.func_70089_S()) continue;
                EntityUtil.divertAttackers((MobEntity)MutantEndermanEntity.this.cloneList.remove(i), (LivingEntity)MutantEndermanEntity.this.getRandomClone());
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setCloneState(0);
            this.attackTarget = null;
        }
    }

    class MeleeGoal
    extends Goal {
        MeleeGoal() {
        }

        public boolean func_75250_a() {
            return MutantEndermanEntity.this.attackID == 4;
        }

        public boolean func_75253_b() {
            return MutantEndermanEntity.this.attackTick < 10;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
        }

        public void func_75246_d() {
            if (MutantEndermanEntity.this.attackTick == 3) {
                for (Entity entity : MutantEndermanEntity.this.field_70170_p.func_175674_a((Entity)MutantEndermanEntity.this, MutantEndermanEntity.this.func_174813_aQ().func_186662_g(4.0), EndersoulFragmentEntity.IS_VALID_TARGET)) {
                    double dist = MutantEndermanEntity.this.func_70032_d(entity);
                    double x = MutantEndermanEntity.this.func_226277_ct_() - entity.func_226277_ct_();
                    double z = MutantEndermanEntity.this.func_226281_cx_() - entity.func_226281_cx_();
                    if (!(MutantEndermanEntity.this.func_174813_aQ().field_72338_b <= entity.func_174813_aQ().field_72337_e) || !(dist <= 4.0) || !EntityUtil.isFacing((LivingEntity)MutantEndermanEntity.this, x, z, 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    boolean lower = MutantEndermanEntity.this.getActiveArm() >= 3;
                    float attackDamage = (float)MutantEndermanEntity.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    float damage = attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantEndermanEntity.this), damage);
                    float power = 0.4f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    entity.func_213293_j(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                }
            }
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
        }
    }

    class ForcedLookGoal
    extends Goal {
        private LivingEntity attackTarget;

        public ForcedLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantEndermanEntity.this.func_70638_az();
            return this.attackTarget != null && MutantEndermanEntity.this.attackID == 6;
        }

        public void func_75249_e() {
            MutantEndermanEntity.this.attackTick = 0;
            MutantEndermanEntity.this.field_70699_by.func_75499_g();
            if (!MutantEndermanEntity.this.func_174814_R()) {
                MutantEndermanEntity.this.field_70170_p.func_217384_a(null, (Entity)MutantEndermanEntity.this, MBSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE, MutantEndermanEntity.this.func_184176_by(), 2.5f, 0.7f + MutantEndermanEntity.this.field_70146_Z.nextFloat() * 0.2f);
            }
        }

        public boolean func_75253_b() {
            return this.attackTarget.func_70089_S() && MutantEndermanEntity.this.attackTick < 100 && MutantEndermanEntity.this.func_70068_e((Entity)this.attackTarget) > 9.0 && MutantEndermanEntity.this.isBeingLookedAt(this.attackTarget);
        }

        public void func_75246_d() {
            MutantEndermanEntity.this.field_70749_g.func_75651_a((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        public void func_75251_c() {
            MutantEndermanEntity.this.setAttackID(0);
            this.attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantEndermanEntity.this).func_76348_h().func_151518_m(), 2.0f);
            this.attackTarget.func_195064_c(new EffectInstance(Effects.field_76440_q, 160 + MutantEndermanEntity.this.field_70146_Z.nextInt(140)));
            double x = MutantEndermanEntity.this.func_226277_ct_() - this.attackTarget.func_226277_ct_();
            double z = MutantEndermanEntity.this.func_226281_cx_() - this.attackTarget.func_226281_cx_();
            this.attackTarget.func_213293_j(x * (double)0.1f, (double)0.3f, z * (double)0.1f);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class TargetLookerGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public TargetLookerGoal(MutantEndermanEntity mutantEnderman) {
            super((MobEntity)mutantEnderman, LivingEntity.class, 10, false, false, x$0 -> mutantEnderman.isBeingLookedAt(x$0));
        }

        public boolean func_75250_a() {
            return ((MutantEndermanEntity)this.field_75299_d).attackID == 0 && this.field_75299_d.func_70638_az() == null && super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
            ((MutantEndermanEntity)this.field_75299_d).setAttackID(6);
        }
    }
}

