/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrowableBlockEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<OptionalInt> THROWER_ENTITY_ID = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (IDataSerializer)DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> HELD = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockState blockState = Blocks.field_196658_i.func_176223_P();
    private UUID ownerUUID;

    public ThrowableBlockEntity(EntityType<? extends ThrowableBlockEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlockEntity(EntityType<? extends ThrowableBlockEntity> type, LivingEntity livingEntityIn, World worldIn) {
        super(MBEntityType.THROWABLE_BLOCK, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226278_cu_() + (double)livingEntityIn.func_70047_e() - (double)0.1f, livingEntityIn.func_226281_cx_(), worldIn);
        this.setThrower(livingEntityIn);
    }

    public ThrowableBlockEntity(World world, MutantEndermanEntity enderman, int id) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)enderman, world);
        this.blockState = Block.func_196257_b((int)enderman.heldBlock[id]);
        boolean outer = id <= 2;
        boolean right = (id & 1) == 1;
        LivingEntity attackTarget = enderman.func_70638_az();
        Vec3d forward = EntityUtil.getDirVector(this.field_70177_z, outer ? 2.7f : 1.4f);
        Vec3d strafe = EntityUtil.getDirVector(this.field_70177_z + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.func_70107_b(this.func_226277_ct_() + forward.field_72450_a + strafe.field_72450_a, this.func_226278_cu_() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.func_226281_cx_() + forward.field_72449_c + strafe.field_72449_c);
        if (attackTarget != null) {
            this.func_70186_c(attackTarget.func_226277_ct_() - this.func_226277_ct_(), attackTarget.func_226278_cu_() - this.func_226278_cu_(), attackTarget.func_226281_cx_() - this.func_226281_cx_(), 1.4f, 1.0f);
        } else {
            this.func_184538_a((Entity)enderman, enderman.field_70125_A, enderman.field_70177_z, 0.0f, 1.0f, 0.8f);
        }
    }

    public ThrowableBlockEntity(MutantSnowGolemEntity mutantSnowGolem, World worldIn) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)mutantSnowGolem, worldIn);
        this.field_70177_z = mutantSnowGolem.field_70177_z;
        this.blockState = Blocks.field_150432_aD.func_176223_P();
    }

    public ThrowableBlockEntity(World world, PlayerEntity player, BlockState blockState, BlockPos pos) {
        this(MBEntityType.THROWABLE_BLOCK, (LivingEntity)player, world);
        this.blockState = blockState;
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.setHeld(true);
    }

    public ThrowableBlockEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(MBEntityType.THROWABLE_BLOCK, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(THROWER_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(HELD, (Object)false);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public LivingEntity func_85052_h() {
        if (this.field_70192_c == null && this.ownerUUID != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID);
            if (entity instanceof LivingEntity) {
                this.setThrower((LivingEntity)entity);
            } else {
                this.ownerUUID = null;
            }
        }
        return this.field_70192_c;
    }

    private void setThrower(LivingEntity thrower) {
        this.field_70192_c = thrower;
        this.ownerUUID = thrower.func_110124_au();
        this.field_70180_af.func_187227_b(THROWER_ENTITY_ID, (Object)OptionalInt.of(thrower.func_145782_y()));
    }

    public LivingEntity getThrowerByID() {
        Entity entity;
        OptionalInt optionalInt = (OptionalInt)this.field_70180_af.func_187225_a(THROWER_ENTITY_ID);
        if (optionalInt.isPresent() && (entity = this.field_70170_p.func_73045_a(optionalInt.getAsInt())) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public boolean isHeld() {
        return (Boolean)this.field_70180_af.func_187225_a(HELD);
    }

    private void setHeld(boolean held) {
        this.field_70180_af.func_187227_b(HELD, (Object)held);
    }

    protected float func_70185_h() {
        if (this.getThrowerByID() instanceof PlayerEntity) {
            return 0.04f;
        }
        if (this.getThrowerByID() instanceof MutantSnowGolemEntity) {
            return 0.06f;
        }
        return 0.01f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_70104_M() {
        return this.isHeld() && this.func_70089_S();
    }

    public float func_70111_Y() {
        return 0.5f;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn != this.func_85052_h()) {
            super.func_70108_f(entityIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
                double y = this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg());
                double z = this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
                double motx = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                double moty = 0.5f + this.field_70146_Z.nextFloat() * 2.0f;
                double motz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.getBlockState()), x, y, z, motx, moty, motz);
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_225510_bt_());
        }
        this.func_70030_z();
        if (this.isHeld()) {
            LivingEntity thrower = this.func_85052_h();
            if (thrower == null) {
                thrower = this.getThrowerByID();
                if (thrower != null) {
                    this.field_70192_c = thrower;
                } else {
                    this.setHeld(false);
                }
            } else {
                Vec3d vec = thrower.func_70040_Z();
                double x = thrower.func_226277_ct_() + vec.field_72450_a * 1.6 - this.func_226277_ct_();
                double y = thrower.func_226278_cu_() + (double)thrower.func_70047_e() + vec.field_72448_b * 1.6 - this.func_226278_cu_();
                double z = thrower.func_226281_cx_() + vec.field_72449_c * 1.6 - this.func_226281_cx_();
                float offset = 0.6f;
                this.func_213293_j(x * (double)offset, y * (double)offset, z * (double)offset);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (!(this.field_70170_p.field_72995_K || thrower != null && thrower.func_70089_S() && !thrower.func_175149_v() && thrower.func_70685_l((Entity)this) && EntityUtil.isHolding(thrower, MBItems.ENDERSOUL_HAND))) {
                    this.setHeld(false);
                }
            }
        } else {
            float f;
            RayTraceResult raytraceresult = ProjectileHelper.func_221266_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.field_70192_c, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER);
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70184_a(raytraceresult);
            }
            Vec3d vec3d = this.func_213322_ci();
            this.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + vec3d.field_72448_b, this.func_226281_cx_() + vec3d.field_72449_c);
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - vec3d.field_72450_a * 0.25, this.func_226278_cu_() - vec3d.field_72448_b * 0.25, this.func_226281_cx_() - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                f = 0.8f;
            } else {
                f = 0.99f;
            }
            this.func_213317_d(vec3d.func_186678_a((double)f));
            if (!this.func_189652_ae()) {
                Vec3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.func_70185_h(), vec3d1.field_72449_c);
            }
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_213453_ef()) {
            return false;
        }
        if (player.func_184586_b(hand).func_77973_b() != MBItems.ENDERSOUL_HAND || player.func_184811_cZ().func_185141_a(MBItems.ENDERSOUL_HAND)) {
            return false;
        }
        if (this.isHeld()) {
            if (this.func_85052_h() == player) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setHeld(false);
                    this.throwBlock((LivingEntity)player);
                }
                player.func_184609_a(hand);
                player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
                player.func_184811_cZ().func_185145_a(MBItems.ENDERSOUL_HAND, 20);
                return true;
            }
            return false;
        }
        this.setHeld(true);
        this.setThrower((LivingEntity)player);
        return true;
    }

    private void throwBlock(LivingEntity thrower) {
        this.field_70177_z = thrower.field_70177_z;
        this.field_70125_A = thrower.field_70125_A;
        float f = 0.4f;
        float PI = (float)Math.PI;
        this.func_213293_j(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * PI)) * f, -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * PI)) * f, MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * PI)) * f);
        this.func_70186_c(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c, 1.4f, 1.0f);
    }

    protected void func_70184_a(RayTraceResult result) {
        LivingEntity thrower = this.func_85052_h();
        if (this.getThrowerByID() instanceof MutantSnowGolemEntity) {
            Entity entity2;
            for (LivingEntity livingEntity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(2.5, 2.0, 2.5), entity -> MutantSnowGolemEntity.canHarm(thrower, (Entity)entity))) {
                if (!(this.func_70068_e((Entity)livingEntity) <= 6.25)) continue;
                livingEntity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)thrower), 4.0f + (float)this.field_70146_Z.nextInt(3));
            }
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY && MutantSnowGolemEntity.canHarm(thrower, entity2 = ((EntityRayTraceResult)result).func_216348_a())) {
                entity2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)thrower), 4.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
            this.func_184185_a(this.getBlockState().func_215695_r().func_185845_c(), 0.8f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f);
        } else {
            BlockState blockState = this.getBlockState();
            BlockPos pos = this.func_180425_c();
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                if (!this.field_70170_p.field_72995_K) {
                    if (ThrowableBlockEntity.canPlaceBlock(this.field_70170_p, blockState, pos, thrower)) {
                        SoundType soundType = blockState.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)thrower);
                        this.func_184185_a(soundType.func_185841_e(), (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    } else {
                        this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockState));
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            Block.func_220075_c((BlockState)blockState, (World)this.field_70170_p, (BlockPos)pos);
                        }
                    }
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.ENTITY && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockState));
                ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)thrower), 4.0f);
            }
            for (Entity entity3 : this.field_70170_p.func_175674_a((Entity)thrower, this.func_174813_aQ().func_186662_g(2.0), EntityPredicates.field_188444_d.and(Entity::func_70067_L))) {
                if (!(this.func_70068_e(entity3) <= 4.0) || entity3.func_200600_R() == this.func_200600_R()) continue;
                double x = entity3.func_226277_ct_() - this.func_226277_ct_();
                double z = entity3.func_226281_cx_() - this.func_226281_cx_();
                double d = Math.sqrt(x * x + z * z);
                entity3.func_213293_j(x / d * (double)0.6f, (double)0.2f, z / d * (double)0.6f);
                entity3.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)thrower), (float)(6 + this.field_70146_Z.nextInt(3)));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    private static boolean canPlaceBlock(World world, BlockState blockState, BlockPos pos, LivingEntity thrower) {
        if (thrower instanceof PlayerEntity && !((PlayerEntity)thrower).func_175142_cm()) {
            return false;
        }
        if (thrower instanceof MobEntity && !ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)thrower)) {
            return false;
        }
        return blockState.func_196955_c((IWorldReader)world, pos) && world.func_175656_a(pos, blockState);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.getBlockState()));
        compound.func_74757_a("Held", this.isHeld());
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("BlockState", 10)) {
            this.blockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        }
        this.setHeld(compound.func_74767_n("Held"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(Block.func_196246_j((BlockState)this.blockState));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.blockState = Block.func_196257_b((int)additionalData.readInt());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

