/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.pathfinding;

import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MBWalkNodeProcessor
extends WalkNodeProcessor {
    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        return MBWalkNodeProcessor.func_227480_b_(blockaccessIn, x, y, z);
    }

    public static PathNodeType func_227480_b_(IBlockReader blockReader, int x, int y, int z) {
        PathNodeType pathnodetype = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, x, y, z);
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            PathNodeType pathNodeBelow = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, x, y - 1, z);
            pathnodetype = pathNodeBelow != PathNodeType.WALKABLE && pathNodeBelow != PathNodeType.OPEN && pathNodeBelow != PathNodeType.WATER && pathNodeBelow != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            switch (pathNodeBelow) {
                case DAMAGE_FIRE: 
                case DAMAGE_CACTUS: 
                case DAMAGE_OTHER: 
                case DANGER_OTHER: 
                case STICKY_HONEY: {
                    pathnodetype = pathNodeBelow;
                    break;
                }
            }
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            pathnodetype = MBWalkNodeProcessor.checkNeighborBlocks(blockReader, x, y, z, pathnodetype);
        }
        return pathnodetype;
    }

    public static PathNodeType checkNeighborBlocks(IBlockReader blockReader, int x, int y, int z, PathNodeType pathNodeType) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    block14: for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && k == 0) continue;
                        BlockPos.PooledMutable pos = blockpos$pooledmutable.func_181079_c(i + x, y, j + z);
                        PathNodeType type = MBWalkNodeProcessor.getPathNodeTypeRaw(blockReader, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        switch (type) {
                            case DAMAGE_FIRE: 
                            case DAMAGE_CACTUS: 
                            case DAMAGE_OTHER: 
                            case DANGER_OTHER: 
                            case LAVA: 
                            case DANGER_FIRE: {
                                pathNodeType = type;
                                continue block14;
                            }
                        }
                    }
                }
            }
        }
        return pathNodeType;
    }

    protected static PathNodeType getPathNodeTypeRaw(IBlockReader blockReader, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = blockReader.func_180495_p(blockpos);
        PathNodeType forgeType = blockstate.getAiPathNodeType(blockReader, blockpos);
        if (forgeType != null) {
            return forgeType;
        }
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        if (blockstate.isAir(blockReader, blockpos)) {
            return PathNodeType.OPEN;
        }
        if (!block.func_203417_a(BlockTags.field_212185_E) && block != Blocks.field_196651_dG) {
            if (block == Blocks.field_150480_ab || block == Blocks.field_196814_hQ || block instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue()) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof SweetBerryBushBlock && (Integer)blockstate.func_177229_b((IProperty)SweetBerryBushBlock.field_220125_a) > 0 || block == Blocks.field_222388_bz || block.func_203417_a(BlockTags.field_226154_ad_)) {
                return PathNodeType.DAMAGE_OTHER;
            }
            if (block instanceof SweetBerryBushBlock && (Integer)blockstate.func_177229_b((IProperty)SweetBerryBushBlock.field_220125_a) == 0 || block == Blocks.field_196553_aF || block == Blocks.field_150425_aM || block instanceof AbstractPressurePlateBlock || block instanceof TripWireBlock && blockstate.func_196959_b((IProperty)TripWireBlock.field_176293_a)) {
                return PathNodeType.DANGER_OTHER;
            }
            if (block == Blocks.field_226907_mc_ || block == Blocks.field_222420_lI) {
                return PathNodeType.STICKY_HONEY;
            }
            if (block == Blocks.field_150375_by) {
                return PathNodeType.COCOA;
            }
            if (block instanceof DoorBlock && material == Material.field_151575_d && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof DoorBlock && material == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof DoorBlock && ((Boolean)blockstate.func_177229_b((IProperty)DoorBlock.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof AbstractRailBlock) {
                return PathNodeType.RAIL;
            }
            if (block instanceof LeavesBlock) {
                return PathNodeType.LEAVES;
            }
            if (!(block.func_203417_a(BlockTags.field_219748_G) || block.func_203417_a(BlockTags.field_219757_z) || block instanceof FenceGateBlock && !((Boolean)blockstate.func_177229_b((IProperty)FenceGateBlock.field_176466_a)).booleanValue())) {
                IFluidState ifluidstate = blockReader.func_204610_c(blockpos);
                if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                    return PathNodeType.WATER;
                }
                if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
                    return PathNodeType.LAVA;
                }
                return blockstate.func_196957_g(blockReader, blockpos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

