/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.entity.SkullSpiritEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantCreeperEntity;
import chumbanotz.mutantbeasts.entity.projectile.ChemicalXEntity;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class MutatedExplosion
extends Explosion {
    private final Entity exploder;
    private final World world;
    private final float size;

    private MutatedExplosion(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode modeIn) {
        super(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
        this.exploder = exploderIn;
        this.world = worldIn;
        this.size = sizeIn;
    }

    public void func_77278_a() {
        double z;
        double y;
        double x;
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    x = this.getPosition().field_72450_a;
                    y = this.getPosition().field_72448_b;
                    z = this.getPosition().field_72449_c;
                    float attenuation = 0.3f;
                    for (float intensity = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); intensity > 0.0f; intensity -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(x, y, z);
                        BlockState blockstate = this.world.func_180495_p(blockpos);
                        if (!blockstate.isAir((IBlockReader)this.world, blockpos) && !blockstate.func_185904_a().func_76224_d()) {
                            float resistance = blockstate.getExplosionResistance((IWorldReader)this.world, blockpos, this.exploder, (Explosion)this);
                            if (this.exploder != null) {
                                resistance = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, this.world.func_204610_c(blockpos), resistance);
                            }
                            intensity -= (resistance + attenuation) * attenuation;
                        }
                        if (intensity > 0.0f && !blockstate.func_185904_a().func_76224_d() && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, intensity))) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)attenuation;
                        y += d1 * (double)attenuation;
                        z += d2 * (double)attenuation;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        float diameter = this.size * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a - (double)diameter - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.getPosition().field_72450_a + (double)diameter + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b - (double)diameter - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.getPosition().field_72448_b + (double)diameter + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c - (double)diameter - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.getPosition().field_72449_c + (double)diameter + 1.0));
        List list = this.world.func_175674_a(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ), entity -> {
            if (entity.func_180427_aV()) {
                return false;
            }
            if (this.exploder instanceof SkullSpiritEntity) {
                return !(entity instanceof LivingEntity) || ChemicalXEntity.IS_APPLICABLE.test((LivingEntity)entity);
            }
            return true;
        });
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)diameter);
        for (Entity entity2 : list) {
            PlayerEntity playerentity;
            double d13;
            double distance = MathHelper.func_76133_a((double)entity2.func_195048_a(this.getPosition())) / diameter;
            if (!(distance <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((x = entity2.func_226277_ct_() - this.getPosition().field_72450_a) * x + (y = entity2.func_226280_cw_() - this.getPosition().field_72448_b) * y + (z = entity2.func_226281_cx_() - this.getPosition().field_72449_c) * z))) == 0.0) continue;
            x /= d13;
            y /= d13;
            z /= d13;
            double impact = (1.0 - distance) * (double)MutatedExplosion.getBlockDensity(this.getPosition(), entity2);
            entity2.func_70097_a(this.func_199591_b(), (float)((int)((impact * impact + impact) / 2.0 * 6.0 * (double)diameter + 1.0)));
            double exposure = impact;
            if (entity2 instanceof LivingEntity) {
                exposure = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity2), (double)impact);
            }
            if (!(entity2 instanceof MutantCreeperEntity)) {
                entity2.func_213317_d(entity2.func_213322_ci().func_72441_c(x * exposure, y * exposure, z * exposure));
            }
            if (!(entity2 instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity2).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.func_77277_b().put(playerentity, new Vec3d(x * impact, y * impact, z * impact));
        }
    }

    public static MutatedExplosion create(@Nonnull Entity exploderIn, float sizeIn, boolean causesFireIn, Explosion.Mode mode) {
        return MutatedExplosion.create(exploderIn.field_70170_p, exploderIn, exploderIn.func_226277_ct_(), exploderIn.func_226278_cu_(), exploderIn.func_226281_cx_(), sizeIn, causesFireIn, mode);
    }

    public static MutatedExplosion create(World worldIn, @Nullable Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode mode) {
        MutatedExplosion explosion;
        if (exploderIn instanceof MobEntity && !ForgeEventFactory.getMobGriefingEvent((World)exploderIn.field_70170_p, (Entity)exploderIn)) {
            mode = Explosion.Mode.NONE;
        }
        if (ForgeEventFactory.onExplosionStart((World)explosion.world, (Explosion)(explosion = new MutatedExplosion(worldIn, exploderIn, xIn, yIn, zIn, sizeIn, causesFireIn, mode)))) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        if (explosion.world instanceof ServerWorld) {
            if (mode == Explosion.Mode.NONE) {
                explosion.func_180342_d();
            }
            for (ServerPlayerEntity serverplayerentity : ((ServerWorld)explosion.world).func_217369_A()) {
                if (!(serverplayerentity.func_70092_e(explosion.getPosition().field_72450_a, explosion.getPosition().field_72448_b, explosion.getPosition().field_72449_c) < 4096.0)) continue;
                serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(explosion.getPosition().field_72450_a, explosion.getPosition().field_72448_b, explosion.getPosition().field_72449_c, explosion.size, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(serverplayerentity)));
            }
        }
        return explosion;
    }

    public static float getBlockDensity(Vec3d endVec, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        double d0 = 1.0 / ((axisalignedbb.field_72336_d - axisalignedbb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_72337_e - axisalignedbb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_72334_f - axisalignedbb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d7;
                        double d6;
                        double d5 = MathHelper.func_219803_d((double)f, (double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72336_d);
                        Vec3d vec3d = new Vec3d(d5 + d3, d6 = MathHelper.func_219803_d((double)f1, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72337_e), (d7 = MathHelper.func_219803_d((double)f2, (double)axisalignedbb.field_72339_c, (double)axisalignedbb.field_72334_f)) + d4);
                        if (entity.field_70170_p.func_217299_a(new RayTraceContext(vec3d, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() == RayTraceResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

