/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.util.ZombieResurrection;
import java.util.List;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class SeismicWave
extends Vec3i {
    private boolean first;
    private final boolean spawnParticles;

    public SeismicWave(int x, int y, int z, boolean spawnParticles) {
        super(x, y, z);
        this.spawnParticles = spawnParticles;
    }

    public boolean isFirst() {
        return this.first;
    }

    public static void createWaves(World world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        SeismicWave wave = SeismicWave.addWave(world, list, x, y, z);
        if (wave != null) {
            wave.first = true;
        }
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        }
    }

    public static SeismicWave addWave(World world, List<SeismicWave> list, int x, int y, int z) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1) {
            wave = new SeismicWave(x, y, z, true);
            list.add(wave);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false));
        }
        return wave;
    }

    public void affectBlocks(World world, Entity entity) {
        BlockPos pos = new BlockPos((Vec3i)this);
        BlockPos posAbove = pos.func_177984_a();
        BlockState blockstate = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175142_cm() || ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity)) {
            if (block instanceof SnowyDirtBlock || block instanceof GrassPathBlock || block instanceof FarmlandBlock) {
                world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
            }
            if (block instanceof BreakableBlock || block instanceof LeavesBlock) {
                world.func_175655_b(pos, false);
            }
            if (world.func_180495_p(posAbove).func_185887_b((IBlockReader)world, posAbove) <= 1.0f && !BlockTags.field_219755_X.func_199685_a_((Object)block)) {
                world.func_175655_b(posAbove, true);
            }
            if (block instanceof DoorBlock) {
                if (blockstate.func_185904_a() == Material.field_151575_d) {
                    world.func_217377_a(posAbove, false);
                    world.func_217379_c(1021, posAbove, 0);
                } else if (blockstate.func_185904_a() == Material.field_151573_f) {
                    world.func_217379_c(1020, posAbove, 0);
                }
            }
            if (block instanceof TNTBlock) {
                block.catchFire(blockstate, world, pos, null, null);
                world.func_217377_a(pos, false);
            }
        }
        if (block instanceof BellBlock) {
            ((BellBlock)block).func_226885_a_(world, pos, null);
        }
        if (block instanceof RedstoneOreBlock || block instanceof TurtleEggBlock) {
            block.func_176199_a(world, pos, entity);
        }
        if (block instanceof TurtleEggBlock) {
            block.func_180658_a(world, pos, entity, 0.0f);
        }
        if (this.spawnParticles) {
            if (blockstate.func_204520_s().func_206888_e()) {
                int id = Block.func_196246_j((BlockState)world.func_180495_p(pos));
                world.func_217379_c(2001, posAbove, id);
            } else if (world instanceof ServerWorld) {
                if (world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a)) {
                    world.func_184133_a(null, posAbove, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 1.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218422_X, (double)posAbove.func_177958_n() + 0.5, (double)posAbove.func_177956_o(), (double)posAbove.func_177952_p() + 0.5, 100, 0.5, 0.5, 0.5, 10.0);
                } else if (world.func_204610_c(pos).func_206884_a(FluidTags.field_206960_b)) {
                    world.func_184133_a(null, posAbove, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 1.0f, 0.9f + world.field_73012_v.nextFloat() * 0.15f);
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218423_k, (double)posAbove.func_177958_n() + 0.5, (double)posAbove.func_177956_o(), (double)posAbove.func_177952_p() + 0.5, 100, 0.5, 0.5, 0.5, 10.0);
                }
            }
        }
    }
}

