/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.capability.SummonableCapability;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;

public class ZombieResurrection {
    private final int posX;
    private final int posY;
    private final int posZ;
    private int tick;
    private final World world;

    public ZombieResurrection(World world, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
        this.tick = 100 + world.field_73012_v.nextInt(40);
    }

    public ZombieResurrection(World world, BlockPos pos, int tick) {
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.world = world;
        this.tick = tick;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean update(MutantZombieEntity mutantZombie) {
        BlockPos pos = this.getPosition();
        if (this.world.func_175623_d(pos.func_177977_b())) {
            return false;
        }
        if (mutantZombie.func_70681_au().nextInt(15) == 0) {
            this.world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.world.func_180495_p(pos.func_177977_b())));
        }
        if (--this.tick <= 0) {
            ZombieEntity zombie = (ZombieEntity)ZombieResurrection.getZombieByLocation(this.world, pos).func_200721_a(this.world);
            zombie.func_213386_a((IWorld)this.world, this.world.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
            zombie.func_70606_j(zombie.func_110138_aP() * (0.6f + 0.4f * zombie.func_70681_au().nextFloat()));
            zombie.func_70642_aH();
            if (zombie.func_184187_bx() != null) {
                zombie.func_184210_p();
            }
            this.world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.world.func_180495_p(pos.func_177977_b())));
            if (this.world.func_180495_p(pos).func_185887_b((IBlockReader)this.world, pos) <= 1.0f && !BlockTags.field_219755_X.func_199685_a_((Object)this.world.func_180495_p(pos).func_177230_c()) && ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)zombie)) {
                this.world.func_175655_b(pos, false);
            }
            if (!this.world.field_72995_K) {
                SummonableCapability.getLazy((Entity)zombie).ifPresent(summonable -> {
                    summonable.setSummonerUUID(mutantZombie.func_110124_au());
                    summonable.setSpawnedBySummoner(true);
                });
                zombie.func_70107_b((double)this.posX + 0.5, (double)this.posY + 1.0, (double)this.posZ + 0.5);
                this.world.func_217376_c((Entity)zombie);
            }
            if (mutantZombie.func_96124_cp() != null) {
                this.world.func_96441_U().func_197901_a(zombie.func_195047_I_(), this.world.func_96441_U().func_96508_e(mutantZombie.func_96124_cp().func_96661_b()));
            }
            return false;
        }
        return true;
    }

    public BlockPos getPosition() {
        return new BlockPos(this.posX, this.posY + 1, this.posZ);
    }

    public static int getSuitableGround(World world, int x, int y, int z) {
        return ZombieResurrection.getSuitableGround(world, x, y, z, 4, true);
    }

    public static int getSuitableGround(World world, int x, int y, int z, int range, boolean checkDay) {
        int i = y;
        while (Math.abs(y - i) <= range) {
            BlockPos pos = new BlockPos(x, i, z);
            BlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c() != Blocks.field_150480_ab) {
                BlockPos pos1;
                float f;
                if (checkDay && !world.func_204610_c(pos).func_206884_a(FluidTags.field_206960_b) || world.func_204610_c(pos).func_206888_e()) {
                    if (world.func_175623_d(pos)) {
                        --i;
                        continue;
                    }
                    if (!world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a()) && ZombieResurrection.shouldIgnoreBlock(world, blockState, pos)) {
                        --i;
                    } else if (!(world.func_175623_d(pos) || world.func_175623_d(pos.func_177984_a()) || ZombieResurrection.shouldIgnoreBlock(world, world.func_180495_p(pos.func_177984_a()), pos.func_177984_a()))) {
                        ++i;
                        continue;
                    }
                }
                if (checkDay && world.func_72935_r() && (f = world.func_205052_D(pos1 = new BlockPos(x, y + 1, z))) > 0.5f && world.func_175710_j(pos1) && world.field_73012_v.nextInt(3) != 0) {
                    return -1;
                }
                return i;
            }
            return -1;
        }
        return -1;
    }

    private static boolean shouldIgnoreBlock(World world, BlockState blockState, BlockPos blockPos) {
        if (blockState.func_177230_c() instanceof TrapDoorBlock && blockState.func_177229_b((IProperty)TrapDoorBlock.field_176285_M) == Half.TOP) {
            return false;
        }
        if (blockState.func_177230_c() instanceof DoorBlock) {
            return true;
        }
        return blockState.func_196952_d((IBlockReader)world, blockPos).func_197766_b();
    }

    public static EntityType<? extends ZombieEntity> getZombieByLocation(World world, BlockPos pos) {
        int chance = world.field_73012_v.nextInt(100);
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return chance < 80 && world.func_226660_f_(pos) ? EntityType.field_200763_C : (chance < 1 ? EntityType.field_200727_aF : EntityType.field_200725_aD);
        }
        if ((biome.func_201856_r() == Biome.Category.OCEAN || biome.func_201856_r() == Biome.Category.RIVER) && world.func_201671_F(pos)) {
            return EntityType.field_204724_o;
        }
        return chance < 95 ? EntityType.field_200725_aD : EntityType.field_200727_aF;
    }
}

