/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    public static String[] biomeBlacklist;
    public static int distanceModifier;
    public static int sampleSpaceModifier;
    public static boolean displayWithChatOpen;
    public static boolean fixBiomeNames;
    public static int lineOffset;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "biomeSize * distanceModifier = maxSearchDistance. Raising this value will increase search accuracy but will potentially make the process more resource intensive.";
        distanceModifier = ConfigHandler.loadInt("general", "naturescompass.distanceModifier", comment, distanceModifier);
        comment = "biomeSize * sampleSpaceModifier = sampleSpace. Lowering this value will increase search accuracy but will make the process more resource intensive.";
        sampleSpaceModifier = ConfigHandler.loadInt("general", "naturescompass.sampleSpaceModifier", comment, sampleSpaceModifier);
        comment = "A list of biomes that the compass will not be able to search for. Both biome names and numerical biome IDs are accepted.";
        biomeBlacklist = ConfigHandler.loadStringArray("general", "naturescompass.biomeBlacklist", comment, biomeBlacklist);
        comment = "Displays Nature's Compass information even while chat is open.";
        displayWithChatOpen = ConfigHandler.loadBool("client", "naturescompass.displayWithChatOpen", comment, displayWithChatOpen);
        comment = "Fixes biome names by adding missing spaces. Ex: ForestHills becomes Forest Hills";
        fixBiomeNames = ConfigHandler.loadBool("client", "naturescompass.fixBiomeNames", comment, fixBiomeNames);
        comment = "The line offset for information rendered on the HUD.";
        lineOffset = ConfigHandler.loadInt("client", "naturescompass.lineOffset", comment, lineOffset);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String category, String name, String comment, int def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        int val = prop.getInt(def);
        if (val < 0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static boolean loadBool(String category, String name, String comment, boolean def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        return prop.getBoolean(def);
    }

    public static String[] loadStringArray(String category, String comment, String name, String[] def) {
        Property prop = config.get(category, name, def);
        prop.setComment(comment);
        return prop.getStringList();
    }

    public static List<String> getBiomeBlacklist() {
        return Lists.newArrayList((Object[])biomeBlacklist);
    }

    static {
        biomeBlacklist = new String[0];
        distanceModifier = 2500;
        sampleSpaceModifier = 16;
        displayWithChatOpen = true;
        fixBiomeNames = true;
        lineOffset = 1;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("naturescompass")) {
                ConfigHandler.init();
            }
        }
    }
}

