/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiBiomeInfo;
import com.chaosthedude.naturescompass.gui.GuiListBiomes;
import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiListBiomesEntry
implements GuiListExtended.IGuiListEntry {
    private final Minecraft mc;
    private final GuiNaturesCompass guiNaturesCompass;
    private final Biome biome;
    private final GuiListBiomes biomesList;
    private long lastClickTime;

    public GuiListBiomesEntry(GuiListBiomes biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.guiNaturesCompass = biomesList.getGuiNaturesCompass();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
        String precipitationState = I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]);
        if (this.biome.func_76746_c()) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]);
        } else if (this.biome.func_76738_d()) {
            precipitationState = I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]);
        }
        String title = this.guiNaturesCompass.getSortingCategory().getLocalizedName();
        Object value = this.guiNaturesCompass.getSortingCategory().getValue(this.biome);
        if (value == null) {
            title = I18n.func_135052_a((String)"string.naturescompass.topBlock", (Object[])new Object[0]);
            value = this.biome.field_76752_A.func_177230_c().func_149732_F();
        }
        this.mc.field_71466_p.func_78276_b(BiomeUtils.getBiomeName(this.biome), x + 1, y + 1, 0xFFFFFF);
        this.mc.field_71466_p.func_78276_b(title + ": " + value, x + 1, y + this.mc.field_71466_p.field_78288_b + 3, 0x808080);
        this.mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"string.naturescompass.precipitation", (Object[])new Object[0]) + ": " + precipitationState, x + 1, y + this.mc.field_71466_p.field_78288_b + 14, 0x808080);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        this.biomesList.selectBiome(slotIndex);
        if (relativeX <= 32 && relativeX < 32) {
            this.selectBiome();
            return true;
        }
        if (Minecraft.func_71386_F() - this.lastClickTime < 250L) {
            this.selectBiome();
            return true;
        }
        this.lastClickTime = Minecraft.func_71386_F();
        return false;
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    public void func_178011_a(int par1, int par2, int par3) {
    }

    public void selectBiome() {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.guiNaturesCompass.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.func_147108_a((GuiScreen)new GuiBiomeInfo(this.guiNaturesCompass, this.biome));
    }
}

